---
generated_at: 2026-01-27 12:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：71-HemisphereLight

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **シェーダーでの色補間計算ロジック**：根拠不足（シェーダーコード未参照）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/lights/HemisphereLight.js` - HemisphereLightクラスのソースコード
- E-02: `src/lights/Light.js` - Lightクラスのソースコード
- E-03: `src/core/Object3D.js` - Object3Dクラスのソースコード
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HemisphereLightはLightクラスを継承する | E-01 (18行目: class HemisphereLight extends Light) | ○ |
| C-02 | skyColorとgroundColorの2色を管理する | E-01 (27-50行目) | ○ |
| C-03 | isHemisphereLightフラグがtrueに設定される | E-01 (38行目) | ○ |
| C-04 | typeは'HemisphereLight'に設定される | E-01 (40行目) | ○ |
| C-05 | 初期位置はObject3D.DEFAULT_UPにコピーされる | E-01 (42行目) | ○ |
| C-06 | updateMatrix()が呼び出される | E-01 (43行目) | ○ |
| C-07 | groundColorはColorオブジェクトとして保存される | E-01 (50行目: this.groundColor = new Color(groundColor)) | ○ |
| C-08 | copyメソッドでgroundColorがコピーされる | E-01 (54-61行目) | ○ |
| C-09 | toJSONでgroundColorが16進数で出力される | E-01 (64-70行目) | ○ |
| C-10 | Lightクラスはcolor, intensityを管理する | E-02 (39-47行目) | ○ |
| C-11 | disposeメソッドでdisposeイベントを発行する | E-02 (55-58行目) | ○ |
| C-12 | DEFAULT_UPは(0,1,0)である | E-03 (1647行目) | ○ |
| C-13 | 関連画面はMenubar - Addである | E-05 (62行目: 画面12, 機能71, HemisphereLight) | ○ |
| C-14 | 入力パラメータskyColorはデフォルト0xffffff | E-02 (17行目: color=0xffffff) | ○ |
| C-15 | 入力パラメータintensityはデフォルト1 | E-02 (17行目: intensity=1) | ○ |
| C-16 | 影を生成できない | E-01 (9行目: This light cannot be used to cast shadows) | ○ |
| C-17 | HemisphereLightはターゲットを持たない | E-01 (コード全体にtargetプロパティが存在しない) | ○ |
| C-18 | 法線方向に基づいてskyColorとgroundColorが補間される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- シェーダーでの半球光の計算ロジック
  - 候補：`src/renderers/shaders/ShaderChunk/lights_pars_begin.glsl.js` / `src/renderers/webgpu/nodes/` / ドキュメント

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - クラス構造と基本プロパティは明確にソースコードから確認可能
- 1: 中リスク - シェーダーでの計算ロジックはコメントに基づく推測を含む

## 6) レビュアーチェックリスト（最小）

- [ ] HemisphereLightの2色管理（skyColor, groundColor）が正しく説明されているか
- [ ] 継承関係（Light -> Object3D）が正確か
- [ ] シェーダーでの計算ロジックの説明が実際の実装と一致するか確認
- [ ] 影を生成できないという制約が正しいか
