---
generated_at: 2026-01-27 12:18:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：72-RectAreaLight

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/lights/RectAreaLight.js` - RectAreaLightクラスのソースコード
- E-02: `src/lights/Light.js` - Lightクラスのソースコード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RectAreaLightはLightクラスを継承する | E-01 (28行目: class RectAreaLight extends Light) | ○ |
| C-02 | 矩形平面から均一に光を放射する | E-01 (4行目: emits light uniformly across the face a rectangular plane) | ○ |
| C-03 | isRectAreaLightフラグがtrueに設定される | E-01 (49行目) | ○ |
| C-04 | typeは'RectAreaLight'に設定される | E-01 (51行目) | ○ |
| C-05 | widthのデフォルト値は10 | E-01 (38行目: width = 10) | ○ |
| C-06 | heightのデフォルト値は10 | E-01 (38行目: height = 10) | ○ |
| C-07 | 影を生成できない | E-01 (10行目: There is no shadow support) | ○ |
| C-08 | PBRマテリアルでのみサポートされる | E-01 (11行目: Only PBR materials are supported) | ○ |
| C-09 | RectAreaLightUniformsLib/TexturesLibの初期化が必要 | E-01 (12-13行目) | ○ |
| C-10 | power getter: intensity * width * height * Math.PI | E-01 (80行目) | ○ |
| C-11 | power setter: power / (width * height * Math.PI) | E-01 (87行目) | ○ |
| C-12 | copyメソッドでwidth, heightがコピーされる | E-01 (91-100行目) | ○ |
| C-13 | toJSONでwidth, heightが出力される | E-01 (102-110行目) | ○ |
| C-14 | colorのデフォルト値は0xffffff | E-02 (17行目) | ○ |
| C-15 | intensityのデフォルト値は1 | E-02 (17行目) | ○ |
| C-16 | 画面機能マッピングに登録がない | E-04 (RectAreaLightの検索結果なし) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードのコメントおよびコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] power計算式（intensity * width * height * PI）が物理的に正確か
- [ ] PBRマテリアル必須の制約が適切に説明されているか
- [ ] 初期化処理（RectAreaLightUniformsLib/TexturesLib）の説明が正確か
