---
generated_at: 2026-01-27 12:22:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：73-LightProbe

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/lights/LightProbe.js` - LightProbeクラスのソースコード
- E-02: `src/lights/Light.js` - Lightクラスのソースコード
- E-03: `src/math/SphericalHarmonics3.js` - 球面調和関数クラスのソースコード
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LightProbeはLightクラスを継承する | E-01 (23行目: class LightProbe extends Light) | ○ |
| C-02 | 光を放射せず、光の情報を保存する | E-01 (5-8行目: コメント記述) | ○ |
| C-03 | 拡散ライトプローブのみをサポート | E-01 (17-19行目: diffuse light probes) | ○ |
| C-04 | isLightProbeフラグがtrueに設定される | E-01 (42行目) | ○ |
| C-05 | shのデフォルト値は新規SphericalHarmonics3 | E-01 (31行目: sh = new SphericalHarmonics3()) | ○ |
| C-06 | intensityのデフォルト値は1 | E-01 (31行目: intensity = 1) | ○ |
| C-07 | Lightコンストラクタにundefinedが渡される | E-01 (33行目: super(undefined, intensity)) | ○ |
| C-08 | shプロパティは球面調和関数を保持する | E-01 (48-49行目) | ○ |
| C-09 | copyメソッドでshがコピーされる | E-01 (53-61行目) | ○ |
| C-10 | toJSONでshが配列として出力される | E-01 (67行目: this.sh.toArray()) | ○ |
| C-11 | LightProbeGeneratorでCubeTextureから生成可能 | E-01 (12-13行目: コメント記述) | ○ |
| C-12 | WebXRから光推定データを取得可能 | E-01 (14-15行目: コメント記述) | ○ |
| C-13 | irradiance environment mapと機能的に等価 | E-01 (19行目: functionally equivalent to an irradiance environment map) | ○ |
| C-14 | 画面機能マッピングに登録がない | E-05 (LightProbeの検索結果なし) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードのコメントおよびコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] 球面調和関数の説明が技術的に正確か
- [ ] colorプロパティが使用されない点が正確に説明されているか
- [ ] WebXRとの連携説明が正確か
