---
generated_at: 2026-01-27 12:26:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-LightShadow

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/lights/LightShadow.js` - LightShadowクラスのソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LightShadowは抽象基底クラスである | E-01 (17行目: @abstract) | ○ |
| C-02 | コンストラクタでcameraを受け取る | E-01 (25行目) | ○ |
| C-03 | intensityのデフォルト値は1 | E-01 (41行目) | ○ |
| C-04 | biasのデフォルト値は0 | E-01 (53行目) | ○ |
| C-05 | biasNodeはnullがデフォルト | E-01 (63行目) | ○ |
| C-06 | normalBiasのデフォルト値は0 | E-01 (74行目) | ○ |
| C-07 | radiusのデフォルト値は1 | E-01 (87行目) | ○ |
| C-08 | blurSamplesのデフォルト値は8 | E-01 (95行目) | ○ |
| C-09 | mapSizeのデフォルトは512x512 | E-01 (104行目) | ○ |
| C-10 | mapTypeのデフォルトはUnsignedByteType | E-01 (112行目) | ○ |
| C-11 | mapのデフォルトはnull | E-01 (121行目) | ○ |
| C-12 | mapPassのデフォルトはnull | E-01 (131行目) | ○ |
| C-13 | autoUpdateのデフォルトはtrue | E-01 (148行目) | ○ |
| C-14 | needsUpdateのデフォルトはfalse | E-01 (158行目) | ○ |
| C-15 | updateMatricesで光源位置を取得する | E-01 (206行目) | ○ |
| C-16 | updateMatricesでカメラlookAtを設定する | E-01 (210行目) | ○ |
| C-17 | reversedDepthに応じて異なるシャドウ行列を設定 | E-01 (216-234行目) | ○ |
| C-18 | disposeでmapとmapPassを解放する | E-01 (267-281行目) | ○ |
| C-19 | copyメソッドで各プロパティがコピーされる | E-01 (289-309行目) | ○ |
| C-20 | cloneメソッドが存在する | E-01 (316-320行目) | ○ |
| C-21 | toJSONメソッドでシリアライズ可能 | E-01 (328-343行目) | ○ |
| C-22 | 画面機能マッピングに登録がない | E-03 (LightShadowの検索結果なし) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] シャドウ行列の計算式が正確に説明されているか
- [ ] reversedDepthの条件分岐が正しく説明されているか
- [ ] 各バイアスパラメータの用途が正確に説明されているか
- [ ] dispose処理が正確に説明されているか
