---
generated_at: 2026-01-27 12:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：76-InstancedMesh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/objects/InstancedMesh.js` - InstancedMeshクラスのソースコード
- E-02: `src/objects/Mesh.js` - Meshクラスのソースコード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InstancedMeshはMeshを継承する | E-01 (28行目: class InstancedMesh extends Mesh) | ○ |
| C-02 | isInstancedMeshフラグがtrueに設定される | E-01 (48行目) | ○ |
| C-03 | instanceMatrixはInstancedBufferAttributeで作成 | E-01 (57行目) | ○ |
| C-04 | instanceMatrixはcount * 16のFloat32Array | E-01 (57行目) | ○ |
| C-05 | previousInstanceMatrixはnullで初期化 | E-01 (66行目) | ○ |
| C-06 | instanceColorはnullで初期化 | E-01 (76行目) | ○ |
| C-07 | morphTextureはnullで初期化 | E-01 (86行目) | ○ |
| C-08 | boundingBoxはnullで初期化 | E-01 (101行目) | ○ |
| C-09 | boundingSphereはnullで初期化 | E-01 (109行目) | ○ |
| C-10 | 全インスタンスが単位行列で初期化される | E-01 (111-115行目) | ○ |
| C-11 | computeBoundingBoxで全インスタンスをイテレート | E-01 (124-153行目) | ○ |
| C-12 | computeBoundingSphereで全インスタンスをイテレート | E-01 (160-189行目) | ○ |
| C-13 | getMatrixAtで配列から行列を読み取る | E-01 (229-232行目) | ○ |
| C-14 | setMatrixAtで行列を配列に書き込む | E-01 (337-341行目) | ○ |
| C-15 | setColorAtで初回呼び出し時にinstanceColorを作成 | E-01 (320-324行目) | ○ |
| C-16 | setMorphAtで初回呼び出し時にmorphTextureを作成 | E-01 (357-361行目) | ○ |
| C-17 | raycastで各インスタンスについて個別にraycast実行 | E-01 (280-307行目) | ○ |
| C-18 | raycast結果にinstanceIdが追加される | E-01 (299行目) | ○ |
| C-19 | updateMorphTargetsは空のメソッド | E-01 (383-385行目) | ○ |
| C-20 | disposeでmorphTextureが解放される | E-01 (391-402行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] instanceMatrix/instanceColorのneedsUpdate必要性が正確に説明されているか
- [ ] 境界計算の処理フローが正確か
- [ ] レイキャストのインスタンス単位処理が正確か
- [ ] モーフテクスチャの構造説明が正確か
