---
generated_at: 2026-01-27 12:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：77-BatchedMesh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/objects/BatchedMesh.js` - BatchedMeshクラスのソースコード
- E-02: `src/objects/Mesh.js` - Meshクラスのソースコード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BatchedMeshはMeshを継承する | E-01 (182行目: class BatchedMesh extends Mesh) | ○ |
| C-02 | isBatchedMeshフラグがtrueに設定される | E-01 (203行目) | ○ |
| C-03 | perObjectFrustumCulledのデフォルトはtrue | E-01 (211行目) | ○ |
| C-04 | sortObjectsのデフォルトはtrue | E-01 (221行目) | ○ |
| C-05 | boundingBoxのデフォルトはnull | E-01 (229行目) | ○ |
| C-06 | boundingSphereのデフォルトはnull | E-01 (237行目) | ○ |
| C-07 | customSortのデフォルトはnull | E-01 (247行目) | ○ |
| C-08 | maxIndexCountのデフォルトはmaxVertexCount*2 | E-01 (192行目) | ○ |
| C-09 | _matricesTextureで行列を管理 | E-01 (278行目, 335-353行目) | ○ |
| C-10 | _indirectTextureでインダイレクトインデックスを管理 | E-01 (279行目, 355-365行目) | ○ |
| C-11 | _colorsTextureで色を管理（オプション） | E-01 (280行目, 367-379行目) | ○ |
| C-12 | addGeometryでジオメトリを追加 | E-01 (627-703行目) | ○ |
| C-13 | addInstanceでインスタンスを追加 | E-01 (561-610行目) | ○ |
| C-14 | setMatrixAtで行列を設定 | E-01 (1075-1086行目) | ○ |
| C-15 | setColorAtで色を設定 | E-01 (1109-1124行目) | ○ |
| C-16 | deleteGeometryで関連インスタンスも削除 | E-01 (826-853行目) | ○ |
| C-17 | validateInstanceIdでインスタンスIDを検証 | E-01 (452-462行目) | ○ |
| C-18 | validateGeometryIdでジオメトリIDを検証 | E-01 (469-479行目) | ○ |
| C-19 | optimize()でメモリ断片化を解消 | E-01 (879-968行目) | ○ |
| C-20 | onBeforeRenderで視錐台カリングとソートを実行 | E-01 (1503-1645行目) | ○ |
| C-21 | dispose()でテクスチャを解放 | E-01 (1483-1501行目) | ○ |
| C-22 | 画面機能マッピングに登録がない | E-04 (BatchedMeshの検索結果なし) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] マルチドロー機能の説明が正確か
- [ ] ジオメトリ追加時の容量チェックが正確か
- [ ] onBeforeRenderの処理フローが正確か
- [ ] optimize()の動作が正確に説明されているか
