---
generated_at: 2026-01-27 12:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：78-Line

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/objects/Line.js` - Lineクラスのソースコード
- E-02: `src/core/Object3D.js` - Object3Dクラスのソースコード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LineはObject3Dを継承する | E-01 (41行目: class Line extends Object3D) | ○ |
| C-02 | isLineフラグがtrueに設定される | E-01 (60行目) | ○ |
| C-03 | typeは'Line'に設定される | E-01 (62行目) | ○ |
| C-04 | geometryのデフォルトは新規BufferGeometry | E-01 (49行目) | ○ |
| C-05 | materialのデフォルトは新規LineBasicMaterial | E-01 (49行目) | ○ |
| C-06 | morphTargetDictionaryはundefinedで初期化 | E-01 (87行目) | ○ |
| C-07 | morphTargetInfluencesはundefinedで初期化 | E-01 (97行目) | ○ |
| C-08 | updateMorphTargetsがコンストラクタで呼ばれる | E-01 (99行目) | ○ |
| C-09 | computeLineDistancesで累積距離を計算 | E-01 (121-152行目) | ○ |
| C-10 | インデックス付きジオメトリで警告を出力 | E-01 (144-148行目) | ○ |
| C-11 | lineDistance属性として保存 | E-01 (142行目) | ○ |
| C-12 | raycastで境界球テストを最初に実行 | E-01 (169-175行目) | ○ |
| C-13 | threshold（Line.threshold）を使用 | E-01 (164行目) | ○ |
| C-14 | stepは1（Lineの場合） | E-01 (185行目) | ○ |
| C-15 | isLineSegmentsでstepが2になる | E-01 (185行目) | ○ |
| C-16 | isLineLoopで最終頂点と最初の頂点を接続 | E-01 (211-224行目, 243-253行目) | ○ |
| C-17 | checkIntersectionでdistanceSqToSegmentを使用 | E-01 (303行目) | ○ |
| C-18 | 画面機能マッピングに登録がない | E-04 (Lineの検索結果なし) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] computeLineDistancesの動作が正確に説明されているか
- [ ] レイキャストの閾値処理が正確か
- [ ] step変数の役割が正確に説明されているか
- [ ] Line/LineSegments/LineLoopの違いが明確か
