---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-Layers.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/core/Layers.js` - Layersクラスのソースコード
- E-02: `src/core/Object3D.js` - layers使用元
- E-03: `src/core/Raycaster.js` - layers使用元
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | maskのデフォルトは1 | E-01 (27行目: `this.mask = 1 | 0`) | ○ |
| C-02 | set()でmask = (1 << layer) >>> 0 | E-01 (38行目: `this.mask = ( 1 << layer | 0 ) >>> 0`) | ○ |
| C-03 | enable()でmask OR= 1 << layer | E-01 (49行目: `this.mask |= 1 << layer | 0`) | ○ |
| C-04 | enableAll()でmask = 0xffffffff | E-01 (58行目: `this.mask = 0xffffffff | 0`) | ○ |
| C-05 | toggle()でmask XOR= 1 << layer | E-01 (69行目: `this.mask ^= 1 << layer | 0`) | ○ |
| C-06 | disable()でmask AND= ~(1 << layer) | E-01 (80行目: `this.mask &= ~ ( 1 << layer | 0 )`) | ○ |
| C-07 | disableAll()でmask = 0 | E-01 (89行目: `this.mask = 0`) | ○ |
| C-08 | test()で(mask & layers.mask) !== 0を返す | E-01 (102行目: `return ( this.mask & layers.mask ) !== 0`) | ○ |
| C-09 | isEnabled()で(mask & (1 << layer)) !== 0を返す | E-01 (114行目: `return ( this.mask & ( 1 << layer | 0 ) ) !== 0`) | ○ |
| C-10 | Object3DがLayersインスタンスを持つ | E-02 (281行目付近: `this.layers = new Layers()`) | ○ |
| C-11 | RaycasterがLayersインスタンスを持つ | E-03 (69行目: `this.layers = new Layers()`) | ○ |
| C-12 | Raycasterでlayers.test()が使われる | E-03 (240行目: `object.layers.test( raycaster.layers )`) | ○ |
| C-13 | 32レイヤー制限はJavaScriptの32ビット整数制限による | E-01（ビットシフト演算の仕様より） | ○ |
| C-14 | 関連画面として1画面が該当 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ビット演算の動作が正確か確認（特に符号なし変換 >>> 0）
- [ ] Object3DとCameraでのlayers使用パターンを確認
- [ ] Raycasterでのlayers.test()の使用を確認
- [ ] 関連画面の一覧が画面機能マッピングと一致しているか確認
