---
generated_at: 2026-01-27 12:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：81-Points

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **画面機能マッピング**：該当機能の画面関連情報が不在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/objects/Points.js` - Pointsクラス本体
- E-02: `src/core/Object3D.js` - 基底クラス
- E-03: `src/materials/PointsMaterial.js` - 点群マテリアル
- E-04: `src/core/BufferGeometry.js` - ジオメトリクラス
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PointsはObject3Dを継承する | E-01: 19行目 `class Points extends Object3D` | ○ |
| C-02 | デフォルトでBufferGeometryとPointsMaterialを使用 | E-01: 27行目 コンストラクタのデフォルト引数 | ○ |
| C-03 | isPointsフラグがtrueに設定される | E-01: 38行目 `this.isPoints = true` | ○ |
| C-04 | typeは'Points'に設定される | E-01: 40行目 `this.type = 'Points'` | ○ |
| C-05 | morphTargetDictionaryとmorphTargetInfluencesをサポート | E-01: 65-75行目 プロパティ定義 | ○ |
| C-06 | updateMorphTargets()でモーフターゲットを初期化 | E-01: 163-192行目 メソッド実装 | ○ |
| C-07 | raycast()で点との交差判定を実行 | E-01: 98-157行目 raycastメソッド | ○ |
| C-08 | 境界球チェックを最初に実行 | E-01: 107-113行目 boundingSphere判定 | ○ |
| C-09 | threshold値でレイキャスト判定距離を制御 | E-01: 102行目 `raycaster.params.Points.threshold` | ○ |
| C-10 | スケールで閾値を補正 | E-01: 120行目 スケール平均での除算 | ○ |
| C-11 | インデックス付きジオメトリをサポート | E-01: 127-141行目 index !== null の分岐 | ○ |
| C-12 | 非インデックスジオメトリをサポート | E-01: 142-155行目 else分岐 | ○ |
| C-13 | drawRangeで描画範囲を制限 | E-01: 103行目, 129-130行目, 144-145行目 | ○ |
| C-14 | testPoint()で個別点との距離判定 | E-01: 196-226行目 ヘルパー関数 | ○ |
| C-15 | 交差結果にdistance, point, index, objectを含む | E-01: 211-222行目 push対象オブジェクト | ○ |
| C-16 | copy()でmaterialとgeometryをコピー | E-01: 81-90行目 copyメソッド | ○ |
| C-17 | PointsMaterialにsize, sizeAttenuation, color, mapプロパティあり | E-03: 96行目, 104行目, 61行目, 71行目 | ○ |
| C-18 | 機能No.81の関連画面情報 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 画面機能マッピング.csvに機能No.81の記載がない
  - 候補：Viewportでの点群表示 / Examples画面での使用 / 手動追加が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接抽出した情報が大半
- 0: 低リスク - 継承関係・メソッド実装が明確
- 1: 中リスク - 画面マッピング情報の欠落（ドキュメント整合性の問題）

## 6) レビュアーチェックリスト（最小）
- [ ] Points.jsのraycast()実装が設計書の記述と一致するか確認
- [ ] モーフターゲット関連の説明が実装と整合しているか確認
- [ ] 画面機能マッピングに本機能を追加する必要があるか判断
