---
generated_at: 2026-01-27 12:18:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：82-Sprite

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/objects/Sprite.js` - Spriteクラス本体
- E-02: `src/core/Object3D.js` - 基底クラス
- E-03: `src/materials/SpriteMaterial.js` - スプライトマテリアル
- E-04: `src/core/InterleavedBuffer.js` - インターリーブバッファ
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SpriteはObject3Dを継承する | E-01: 47行目 `class Sprite extends Object3D` | ○ |
| C-02 | デフォルトでSpriteMaterialを使用 | E-01: 54行目 コンストラクタのデフォルト引数 | ○ |
| C-03 | isSpriteフラグがtrueに設定される | E-01: 65行目 `this.isSprite = true` | ○ |
| C-04 | typeは'Sprite'に設定される | E-01: 67行目 `this.type = 'Sprite'` | ○ |
| C-05 | 共有ジオメトリ（_geometry）を使用 | E-01: 12行目 `let _geometry;`, 69-86行目 初期化 | ○ |
| C-06 | InterleavedBufferで頂点/UV結合 | E-01: 73-84行目 InterleavedBuffer使用 | ○ |
| C-07 | centerプロパティのデフォルトは(0.5, 0.5) | E-01: 110行目 `this.center = new Vector2(0.5, 0.5)` | ○ |
| C-08 | countプロパティのデフォルトは1 | E-01: 119行目 `this.count = 1` | ○ |
| C-09 | raycast時にcameraが必須 | E-01: 131-135行目 camera===null チェック | ○ |
| C-10 | sizeAttenuation=falseでサイズ固定 | E-01: 144-148行目 sizeAttenuation判定 | ○ |
| C-11 | material.rotationで回転制御 | E-01: 150-158行目 rotation使用 | ○ |
| C-12 | 2つの三角形で四角形を構成 | E-01: 82行目 `setIndex([0, 1, 2, 0, 2, 3])` | ○ |
| C-13 | transformVertex()でビルボード変換 | E-01: 162-164行目, 218-243行目 | ○ |
| C-14 | 交差結果にdistance, point, uv, objectを含む | E-01: 192-200行目 push対象オブジェクト | ○ |
| C-15 | Triangle.getInterpolationでUV補間 | E-01: 196行目 Triangle.getInterpolation呼び出し | ○ |
| C-16 | copy()でcenterとmaterialをコピー | E-01: 204-214行目 copyメソッド | ○ |
| C-17 | SpriteMaterialにrotation, sizeAttenuation, transparentプロパティあり | E-03: 83行目, 91行目, 100行目 | ○ |
| C-18 | SpriteMaterialのtransparentデフォルトはtrue | E-03: 100行目 `this.transparent = true` | ○ |
| C-19 | Spriteは影を落とさない | E-01: 32-35行目 コメントで明記 | ○ |
| C-20 | 画面No.12でスプライト追加機能として使用 | E-06: 66行目 `"12","Menubar - Add","82","Sprite"` | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接抽出した情報が大半
- 0: 低リスク - 画面マッピング情報も確認済み
- 0: 低リスク - 継承関係・メソッド実装が明確

## 6) レビュアーチェックリスト（最小）
- [ ] Sprite.jsのraycast()実装が設計書の記述と一致するか確認
- [ ] ビルボード変換の説明が実装と整合しているか確認
- [ ] SpriteMaterialのプロパティ説明が正確か確認
