---
generated_at: 2026-01-27 12:22:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：84-LOD

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **画面機能マッピング**：該当機能の画面関連情報が不在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/objects/LOD.js` - LODクラス本体
- E-02: `src/core/Object3D.js` - 基底クラス
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LODはObject3Dを継承する | E-01: 33行目 `class LOD extends Object3D` | ○ |
| C-02 | isLODフラグがtrueに設定される | E-01: 49行目 `this.isLOD = true` | ○ |
| C-03 | _currentLevelのデフォルトは0 | E-01: 58行目 `this._currentLevel = 0` | ○ |
| C-04 | levelsはObject.definePropertiesで定義 | E-01: 62-72行目 Object.defineProperties | ○ |
| C-05 | autoUpdateのデフォルトはtrue | E-01: 83行目 `this.autoUpdate = true` | ○ |
| C-06 | addLevelのdistanceデフォルトは0 | E-01: 116行目 `distance = 0` | ○ |
| C-07 | addLevelのhysteresisデフォルトは0 | E-01: 116行目 `hysteresis = 0` | ○ |
| C-08 | distanceは絶対値に変換される | E-01: 118行目 `Math.abs(distance)` | ○ |
| C-09 | レベルは距離順でソート挿入される | E-01: 124-132行目 ソート挿入ロジック | ○ |
| C-10 | addLevel後にObject3D.add()が呼ばれる | E-01: 136行目 `this.add(object)` | ○ |
| C-11 | removeLevel()で距離一致レベルを削除 | E-01: 149-168行目 removeLevelメソッド | ○ |
| C-12 | getCurrentLevel()で現在レベル取得 | E-01: 175-179行目 getCurrentLevelメソッド | ○ |
| C-13 | getObjectForDistance()でヒステリシス適用 | E-01: 200-204行目 ヒステリシス計算 | ○ |
| C-14 | update()でカメラズームを考慮 | E-01: 259行目 `distance / camera.zoom` | ○ |
| C-15 | raycast()でgetObjectForDistance()を使用 | E-01: 236-238行目 raycastメソッド | ○ |
| C-16 | toJSON()でシリアライズ対応 | E-01: 300-324行目 toJSONメソッド | ○ |
| C-17 | copy()でlevelsを複製 | E-01: 87-105行目 copyメソッド | ○ |
| C-18 | 機能No.84の関連画面情報 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 画面機能マッピング.csvに機能No.84の記載がない
  - 候補：3Dサンプルでの使用例 / パフォーマンス最適化デモ / 手動追加が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接抽出した情報が大半
- 0: 低リスク - アルゴリズムが明確に実装されている
- 1: 中リスク - 画面マッピング情報の欠落（ドキュメント整合性の問題）

## 6) レビュアーチェックリスト（最小）
- [ ] LOD.jsのupdate()実装が設計書の記述と一致するか確認
- [ ] ヒステリシス計算の説明が実装と整合しているか確認
- [ ] 画面機能マッピングに本機能を追加する必要があるか判断
