---
generated_at: 2026-01-27 12:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-SkinnedMesh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/objects/SkinnedMesh.js` - SkinnedMeshクラス本体
- E-02: `src/objects/Mesh.js` - 基底クラス
- E-03: `src/objects/Skeleton.js` - Skeletonクラス
- E-04: `src/constants.js` - 定数定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SkinnedMeshはMeshを継承する | E-01: 38行目 `class SkinnedMesh extends Mesh` | ○ |
| C-02 | isSkinnedMeshフラグがtrueに設定される | E-01: 57行目 `this.isSkinnedMesh = true` | ○ |
| C-03 | bindModeのデフォルトはAttachedBindMode | E-01: 69行目 `this.bindMode = AttachedBindMode` | ○ |
| C-04 | bindMatrixは新規Matrix4で初期化 | E-01: 76行目 `this.bindMatrix = new Matrix4()` | ○ |
| C-05 | bindMatrixInverseは新規Matrix4で初期化 | E-01: 83行目 `this.bindMatrixInverse = new Matrix4()` | ○ |
| C-06 | boundingBoxのデフォルトはnull | E-01: 91行目 `this.boundingBox = null` | ○ |
| C-07 | boundingSphereのデフォルトはnull | E-01: 99行目 `this.boundingSphere = null` | ○ |
| C-08 | bind()でskeletonを設定 | E-01: 232行目 `this.skeleton = skeleton` | ○ |
| C-09 | bind()でcalculateInverses呼び出し | E-01: 238行目 `this.skeleton.calculateInverses()` | ○ |
| C-10 | bind()でbindMatrixを設定 | E-01: 244行目 `this.bindMatrix.copy(bindMatrix)` | ○ |
| C-11 | bind()でbindMatrixInverseを計算 | E-01: 245行目 `this.bindMatrixInverse.copy(bindMatrix).invert()` | ○ |
| C-12 | pose()でskeleton.pose()呼び出し | E-01: 254行目 `this.skeleton.pose()` | ○ |
| C-13 | normalizeSkinWeights()でウェイト正規化 | E-01: 262-288行目 normalizeSkinWeightsメソッド | ○ |
| C-14 | updateMatrixWorld()でAttachedモード判定 | E-01: 294行目 `if (bindMode === AttachedBindMode)` | ○ |
| C-15 | AttachedモードでmatrixWorldから逆行列計算 | E-01: 296行目 `this.bindMatrixInverse.copy(this.matrixWorld).invert()` | ○ |
| C-16 | DetachedモードでbindMatrixから逆行列計算 | E-01: 300行目 `this.bindMatrixInverse.copy(this.bindMatrix).invert()` | ○ |
| C-17 | applyBoneTransform()で4ボーン処理 | E-01: 331行目 `for (let i = 0; i < 4; i++)` | ○ |
| C-18 | applyBoneTransform()でボーン行列とboneInverse乗算 | E-01: 339行目 `multiplyMatrices(skeleton.bones[boneIndex].matrixWorld, skeleton.boneInverses[boneIndex])` | ○ |
| C-19 | applyBoneTransform()で最後にbindMatrixInverse適用 | E-01: 347行目 `return target.applyMatrix4(this.bindMatrixInverse)` | ○ |
| C-20 | raycast()でboundingSphereチェック | E-01: 187-192行目 境界球判定 | ○ |
| C-21 | computeBoundingBox()で全頂点をgetVertexPosition | E-01: 123-127行目 ループ処理 | ○ |
| C-22 | 画面No.37でスキンメッシュプレビュー | E-06: 117行目 `"37","Bones Browser","85","SkinnedMesh"` | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接抽出した情報が大半
- 0: 低リスク - スキニング計算の実装が明確
- 0: 低リスク - 画面マッピング情報も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] applyBoneTransform()の計算式が設計書の記述と一致するか確認
- [ ] bindMode切り替えの説明が実装と整合しているか確認
- [ ] バウンディング計算の説明が正確か確認
