---
generated_at: 2026-01-27 12:28:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：86-Skeleton

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/objects/Skeleton.js` - Skeletonクラス本体
- E-02: `src/objects/Bone.js` - Boneクラス
- E-03: `src/textures/DataTexture.js` - DataTextureクラス
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bonesデフォルトは空配列 | E-01: 46行目 `bones = []` | ○ |
| C-02 | boneInversesデフォルトは空配列 | E-01: 46行目 `boneInverses = []` | ○ |
| C-03 | uuidはgenerateUUID()で生成 | E-01: 48行目 `this.uuid = generateUUID()` | ○ |
| C-04 | bones.slice()でコピー保存 | E-01: 55行目 `this.bones = bones.slice(0)` | ○ |
| C-05 | boneMatricesはnullで初期化 | E-01: 71行目 `this.boneMatrices = null` | ○ |
| C-06 | previousBoneMatricesはnullで初期化 | E-01: 80行目 `this.previousBoneMatrices = null` | ○ |
| C-07 | boneTextureはnullで初期化 | E-01: 89行目 `this.boneTexture = null` | ○ |
| C-08 | init()でboneMatrices確保 | E-01: 105行目 `this.boneMatrices = new Float32Array(bones.length * 16)` | ○ |
| C-09 | boneInverses空でcalculateInverses呼び出し | E-01: 109-111行目 条件分岐 | ○ |
| C-10 | bones数とboneInverses数の不一致で警告 | E-01: 117-119行目 warn呼び出し | ○ |
| C-11 | calculateInverses()でmatrixWorld.invert | E-01: 149行目 `inverse.copy(this.bones[i].matrixWorld).invert()` | ○ |
| C-12 | pose()で逆行列からmatrixWorld復元 | E-01: 172行目 `bone.matrixWorld.copy(this.boneInverses[i]).invert()` | ○ |
| C-13 | update()でオフセット行列計算 | E-01: 223行目 `_offsetMatrix.multiplyMatrices(matrix, boneInverses[i])` | ○ |
| C-14 | update()でboneTexture.needsUpdate設定 | E-01: 230行目 `boneTexture.needsUpdate = true` | ○ |
| C-15 | computeBoneTexture()でサイズ計算 | E-01: 261-263行目 サイズ計算ロジック | ○ |
| C-16 | computeBoneTexture()でDataTexture生成 | E-01: 268行目 `new DataTexture(boneMatrices, size, size, RGBAFormat, FloatType)` | ○ |
| C-17 | getBoneByName()で名前検索 | E-01: 285-301行目 getBoneByNameメソッド | ○ |
| C-18 | dispose()でboneTexture.dispose呼び出し | E-01: 309-313行目 disposeメソッド | ○ |
| C-19 | toJSON()でbones.uuidを保存 | E-01: 379行目 `data.bones.push(bone.uuid)` | ○ |
| C-20 | 画面No.37でスケルトン構造表示 | E-05: 118行目 `"37","Bones Browser","86","Skeleton"` | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接抽出した情報が大半
- 0: 低リスク - 行列計算の実装が明確
- 0: 低リスク - 画面マッピング情報も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] update()のオフセット行列計算が設計書の記述と一致するか確認
- [ ] computeBoneTexture()のサイズ計算が正確か確認
- [ ] init()のboneInverses検証ロジックが正確か確認
