---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：95-DepthTexture

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張にコード根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/textures/DepthTexture.js` - 主要実装ファイル（105行）
- E-02: `src/textures/Texture.js` - 基底クラス実装
- E-03: `src/textures/Source.js` - Sourceクラス実装
- E-04: `src/constants.js` - 定数定義ファイル
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DepthTextureはTextureクラスを継承する | E-01: 11行目 `class DepthTexture extends Texture` | ○ |
| C-02 | typeのデフォルト値はUnsignedIntType | E-01: 28行目 `type = UnsignedIntType` | ○ |
| C-03 | magFilterのデフォルト値はNearestFilter | E-01: 28行目 `magFilter = NearestFilter` | ○ |
| C-04 | minFilterのデフォルト値はNearestFilter | E-01: 28行目 `minFilter = NearestFilter` | ○ |
| C-05 | formatのデフォルト値はDepthFormat | E-01: 28行目 `format = DepthFormat` | ○ |
| C-06 | depthのデフォルト値は1 | E-01: 28行目 `depth = 1` | ○ |
| C-07 | フォーマット検証でDepthFormat/DepthStencilFormat以外はエラー | E-01: 30-34行目 `if ( format !== DepthFormat && format !== DepthStencilFormat ) { throw new Error(...) }` | ○ |
| C-08 | imageオブジェクトは{width, height, depth}を含む | E-01: 36行目 `const image = { width: width, height: height, depth: depth }` | ○ |
| C-09 | isDepthTextureはtrueに設定される | E-01: 47行目 `this.isDepthTexture = true` | ○ |
| C-10 | flipYはfalseに設定される | E-01: 58行目 `this.flipY = false` | ○ |
| C-11 | generateMipmapsはfalseに設定される | E-01: 68行目 `this.generateMipmaps = false` | ○ |
| C-12 | compareFunctionはnullに設定される | E-01: 76行目 `this.compareFunction = null` | ○ |
| C-13 | copyメソッドはSourceを新規作成する | E-01: 85行目 `this.source = new Source( Object.assign( {}, source.image ) )` | ○ |
| C-14 | copyメソッドはcompareFunctionをコピーする | E-01: 86行目 `this.compareFunction = source.compareFunction` | ○ |
| C-15 | toJSONメソッドはcompareFunctionをシリアライズする | E-01: 96行目 `if ( this.compareFunction !== null ) data.compareFunction = this.compareFunction` | ○ |
| C-16 | NearestFilter, UnsignedIntType等はconstants.jsからインポート | E-01: 3行目 import文 | ○ |
| C-17 | 機能一覧ではNo.95としてDepthTextureが定義 | E-05: 96行目 | ○ |
| C-18 | カテゴリは「テクスチャ」 | E-05: 96行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（すべての主張にソースコード根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能
- フォーマット検証のエラーメッセージが正確に文書化されているか確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] DepthTextureのコンストラクタパラメータがドキュメントと一致するか確認
- [ ] フォーマット制限（DepthFormat/DepthStencilFormat）が正しく説明されているか確認
- [ ] compareFunctionの用途と設定可能な値が明記されているか確認
- [ ] copyメソッドでのSourceの新規作成理由（#30540）が適切に説明されているか確認
