---
generated_at: 2026-01-27 12:42:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：98-Loader

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張にコード根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/loaders/Loader.js` - 主要実装ファイル（223行）
- E-02: `src/loaders/LoadingManager.js` - LoadingManager実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Loaderは抽象基底クラスである | E-01: 7行目 JSDoc `@abstract` | ○ |
| C-02 | コンストラクタはmanager引数を受け取る | E-01: 15行目 `constructor( manager )` | ○ |
| C-03 | managerのデフォルト値はDefaultLoadingManager | E-01: 23行目 `this.manager = ( manager !== undefined ) ? manager : DefaultLoadingManager` | ○ |
| C-04 | crossOriginのデフォルト値は'anonymous' | E-01: 32行目 `this.crossOrigin = 'anonymous'` | ○ |
| C-05 | withCredentialsのデフォルト値はfalse | E-01: 40行目 `this.withCredentials = false` | ○ |
| C-06 | pathのデフォルト値は空文字 | E-01: 47行目 `this.path = ''` | ○ |
| C-07 | resourcePathのデフォルト値は空文字 | E-01: 54行目 `this.resourcePath = ''` | ○ |
| C-08 | requestHeaderのデフォルト値は空オブジェクト | E-01: 62行目 `this.requestHeader = {}` | ○ |
| C-09 | DevToolsへの登録処理がある | E-01: 64-68行目 `if ( typeof __THREE_DEVTOOLS__ !== 'undefined' )` | ○ |
| C-10 | load()メソッドは空実装（抽象） | E-01: 82行目 `load( /* url, onLoad, onProgress, onError */ ) {}` | ○ |
| C-11 | loadAsync()メソッドはPromiseを返す | E-01: 91-101行目 `return new Promise( function ( resolve, reject ) { ... })` | ○ |
| C-12 | parse()メソッドは空実装（抽象） | E-01: 110行目 `parse( /* data */ ) {}` | ○ |
| C-13 | setCrossOrigin()メソッドがある | E-01: 119-124行目 | ○ |
| C-14 | setWithCredentials()メソッドがある | E-01: 135-140行目 | ○ |
| C-15 | setPath()メソッドがある | E-01: 148-153行目 | ○ |
| C-16 | setResourcePath()メソッドがある | E-01: 161-166行目 | ○ |
| C-17 | setRequestHeader()メソッドがある | E-01: 175-180行目 | ○ |
| C-18 | abort()メソッドがある | E-01: 188-192行目 | ○ |
| C-19 | DEFAULT_MATERIAL_NAMEは静的プロパティ | E-01: 220行目 `Loader.DEFAULT_MATERIAL_NAME = '__DEFAULT'` | ○ |
| C-20 | 機能一覧ではNo.98としてLoaderが定義 | E-03: 99行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（すべての主張にソースコード根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Loaderの各プロパティのデフォルト値がドキュメントと一致するか確認
- [ ] load(), parse()が抽象メソッドであることが明記されているか確認
- [ ] loadAsync()のPromiseラッパーとしての動作が正しく説明されているか確認
- [ ] 各setterメソッドが正しく文書化されているか確認
- [ ] DEFAULT_MATERIAL_NAME静的プロパティの用途が説明されているか確認
