---
generated_at: 2026-01-27 12:46:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：99-LoadingManager

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張にコード根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/loaders/LoadingManager.js` - 主要実装ファイル（330行）
- E-02: `src/loaders/Loader.js` - Loaderクラス実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LoadingManagerはクラスとして定義されている | E-01: 18行目 `class LoadingManager` | ○ |
| C-02 | コンストラクタはonLoad, onProgress, onError引数を受け取る | E-01: 27行目 `constructor( onLoad, onProgress, onError )` | ○ |
| C-03 | isLoading, itemsLoaded, itemsTotal, handlersはクロージャ変数 | E-01: 31-35行目 | ○ |
| C-04 | onStartは初期値undefined | E-01: 46行目 `this.onStart = undefined` | ○ |
| C-05 | onLoadは引数から設定される | E-01: 54行目 `this.onLoad = onLoad` | ○ |
| C-06 | onProgressは引数から設定される | E-01: 62行目 `this.onProgress = onProgress` | ○ |
| C-07 | onErrorは引数から設定される | E-01: 70行目 `this.onError = onError` | ○ |
| C-08 | _abortControllerは初期値null | E-01: 78行目 `this._abortController = null` | ○ |
| C-09 | itemStart()はitemsTotal++する | E-01: 88行目 `itemsTotal ++` | ○ |
| C-10 | itemStart()は初回時にonStartを呼び出す | E-01: 90-96行目 | ○ |
| C-11 | itemEnd()はitemsLoaded++する | E-01: 112行目 `itemsLoaded ++` | ○ |
| C-12 | itemEnd()はonProgressを呼び出す | E-01: 114-118行目 | ○ |
| C-13 | itemEnd()は全完了時にonLoadを呼び出す | E-01: 120-128行目 | ○ |
| C-14 | itemError()はonErrorを呼び出す | E-01: 140-146行目 | ○ |
| C-15 | resolveURL()はurlModifierがあれば変換する | E-01: 157-167行目 | ○ |
| C-16 | setURLModifier()はurlModifierを設定する | E-01: 203-209行目 | ○ |
| C-17 | addHandler()はhandlers配列に追加する | E-01: 227行目 `handlers.push( regex, loader )` | ○ |
| C-18 | removeHandler()はhandlers配列から削除する | E-01: 243-247行目 | ○ |
| C-19 | getHandler()は正規表現でマッチングする | E-01: 261-277行目 | ○ |
| C-20 | abort()はabortController.abort()を呼び出す | E-01: 290-291行目 | ○ |
| C-21 | DefaultLoadingManagerはグローバルインスタンス | E-01: 327行目 `const DefaultLoadingManager = /*@__PURE__*/ new LoadingManager()` | ○ |
| C-22 | 機能一覧ではNo.99としてLoadingManagerが定義 | E-03: 100行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（すべての主張にソースコード根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] LoadingManagerの各コールバックプロパティがドキュメントと一致するか確認
- [ ] itemStart/itemEnd/itemErrorの呼び出しフローが正しく説明されているか確認
- [ ] ハンドラー機能（addHandler/removeHandler/getHandler）の用途が明記されているか確認
- [ ] setURLModifierの使用例が適切に説明されているか確認
- [ ] abort()とAbortControllerの関係が正しく文書化されているか確認
- [ ] DefaultLoadingManagerの役割が説明されているか確認
