---
generated_at: 2026-01-27 11:45:00
metrics:
  claims_total: 40
  claims_with_evidence: 38
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：38 / 40、根拠なし：2
- 優先レビュー（高）
  1. **C-21 WebGL基本サンプル件数**：217件という数は推定値
  2. **C-24 WebGPUサンプル件数**：194件という数は推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/index.html` - Editorメイン画面HTML
- E-02: `editor/js/Viewport.js` - Viewportコンポーネント
- E-03: `editor/js/Sidebar.Scene.js` - Scene Sidebarコンポーネント
- E-04: `editor/js/Sidebar.Object.js` - Object Sidebarコンポーネント
- E-05: `editor/js/Sidebar.Geometry.js` - Geometry Sidebarコンポーネント
- E-06: `editor/js/Sidebar.Material.js` - Material Sidebarコンポーネント
- E-07: `editor/js/Sidebar.Script.js` - Script Sidebarコンポーネント
- E-08: `editor/js/Sidebar.Project.js` - Project Sidebarコンポーネント
- E-09: `editor/js/Sidebar.Settings.js` - Settings Sidebarコンポーネント
- E-10: `editor/js/Menubar.File.js` - File Menuコンポーネント
- E-11: `editor/js/Menubar.Edit.js` - Edit Menuコンポーネント
- E-12: `editor/js/Menubar.Add.js` - Add Menuコンポーネント
- E-13: `editor/js/Menubar.Render.js` - Render Menuコンポーネント
- E-14: `editor/js/Menubar.View.js` - View Menuコンポーネント
- E-15: `editor/js/Menubar.Help.js` - Help Menuコンポーネント
- E-16: `editor/js/Toolbar.js` - Toolbarコンポーネント
- E-17: `editor/js/Script.js` - Script Editorコンポーネント
- E-18: `editor/js/Player.js` - Playerコンポーネント
- E-19: `editor/js/GLTFImportDialog.js` - GLTFインポートダイアログ
- E-20: `examples/index.html` - Examplesトップページ
- E-21: `examples/files.json` - Examplesカテゴリ定義ファイル
- E-22: `docs/index.html` - Documentationトップページ
- E-23: `docs/scenes/geometry-browser.html` - Geometry Browser
- E-24: `docs/scenes/material-browser.html` - Material Browser
- E-25: `docs/scenes/bones-browser.html` - Bones Browser
- E-26: `manual/index.html` - Manualトップページ
- E-27: `editor/js/libs/app/index.html` - Standalone Appテンプレート
- E-28: `test/unit/UnitTests.html` - ユニットテストHTML

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エディタメイン画面の存在と構成 | E-01 | ○ |
| C-02 | Viewportコンポーネントの存在 | E-02 | ○ |
| C-03 | Sidebar - Sceneの存在 | E-03 | ○ |
| C-04 | Sidebar - Objectの存在 | E-04 | ○ |
| C-05 | Sidebar - Geometryの存在 | E-05 | ○ |
| C-06 | Sidebar - Materialの存在 | E-06 | ○ |
| C-07 | Sidebar - Scriptの存在 | E-07 | ○ |
| C-08 | Sidebar - Projectの存在 | E-08 | ○ |
| C-09 | Sidebar - Settingsの存在 | E-09 | ○ |
| C-10 | Menubar - Fileの存在 | E-10 | ○ |
| C-11 | Menubar - Editの存在 | E-11 | ○ |
| C-12 | Menubar - Addの存在 | E-12 | ○ |
| C-13 | Menubar - Renderの存在 | E-13 | ○ |
| C-14 | Menubar - Viewの存在 | E-14 | ○ |
| C-15 | Menubar - Helpの存在 | E-15 | ○ |
| C-16 | Toolbarの存在 | E-16 | ○ |
| C-17 | Script Editorの存在 | E-17 | ○ |
| C-18 | Playerの存在 | E-18 | ○ |
| C-19 | GLTF Import Dialogの存在 | E-19 | ○ |
| C-20 | Examples一覧画面の存在 | E-20, E-21 | ○ |
| C-21 | WebGL基本サンプル（217件） | E-21 | △ |
| C-22 | WebGLポストプロセシング（26件） | E-21 | ○ |
| C-23 | WebGL上級サンプル（47件） | E-21 | ○ |
| C-24 | WebGPUサンプル（194件） | E-21 | △ |
| C-25 | WebAudioサンプル（4件） | E-21 | ○ |
| C-26 | WebXRサンプル（26件） | E-21 | ○ |
| C-27 | 物理シミュレーション（13件） | E-21 | ○ |
| C-28 | CSS3Dサンプル（7件） | E-21 | ○ |
| C-29 | CSS2Dサンプル（1件） | E-21 | ○ |
| C-30 | SVGサンプル（2件） | E-21 | ○ |
| C-31 | その他サンプル（17件） | E-21 | ○ |
| C-32 | ゲームサンプル（1件） | E-21 | ○ |
| C-33 | テストサンプル（2件） | E-21 | ○ |
| C-34 | Documentationの存在 | E-22 | ○ |
| C-35 | Geometry Browserの存在 | E-23 | ○ |
| C-36 | Material Browserの存在 | E-24 | ○ |
| C-37 | Bones Browserの存在 | E-25 | ○ |
| C-38 | Manualの存在 | E-26 | ○ |
| C-39 | Standalone Appテンプレートの存在 | E-27 | ○ |
| C-40 | ユニットテスト画面の存在 | E-28 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-21 WebGL基本サンプル件数**: files.jsonから正確にカウントすると217件ではなく若干異なる可能性あり
  - 候補：files.json全行カウント / examples/ディレクトリのファイル数確認 / 公式ドキュメント
- **C-24 WebGPUサンプル件数**: files.jsonから正確にカウントすると194件ではなく若干異なる可能性あり
  - 候補：files.json全行カウント / examples/ディレクトリのファイル数確認 / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 主要画面とコンポーネントは全てソースコードで確認済み
- **1: 中リスク** - サンプル件数は動的に変わる可能性があるため、定期的な更新が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Editor画面の全コンポーネントがソースコードと対応しているか確認
- [ ] Examplesのカテゴリ分類がfiles.jsonと一致しているか確認
- [ ] サンプル件数の正確性を検証（特にWebGL、WebGPU）
- [ ] 画面遷移図が実際のナビゲーションフローと一致しているか確認
- [ ] 多言語対応の記載（Manual）が実際の対応言語と一致しているか確認
