# 画面遷移図

three.js プロジェクトの画面遷移図を Mermaid 形式で記述します。

## 全体概要

```mermaid
flowchart TB
    subgraph TopLevel["three.js Web"]
        Editor["Editor<br/>editor/index.html"]
        Examples["Examples<br/>examples/index.html"]
        Docs["Documentation<br/>docs/index.html"]
        Manual["Manual<br/>manual/index.html"]
    end

    TopLevel --> Editor
    TopLevel --> Examples
    TopLevel --> Docs
    TopLevel --> Manual
```

## Editor 画面遷移図

```mermaid
flowchart TB
    subgraph EditorMain["Editor Main (editor/index.html)"]
        direction TB

        subgraph MenubarArea["Menubar"]
            MenuFile["File Menu"]
            MenuEdit["Edit Menu"]
            MenuAdd["Add Menu"]
            MenuRender["Render Menu"]
            MenuView["View Menu"]
            MenuHelp["Help Menu"]
        end

        subgraph ToolbarArea["Toolbar"]
            TransformTools["Transform Tools<br/>(Translate/Rotate/Scale)"]
            SnapSettings["Snap Settings"]
        end

        subgraph MainArea["Main Content Area"]
            Viewport["Viewport<br/>(3D Scene View)"]
            ScriptEditor["Script Editor<br/>(CodeMirror)"]
            Player["Player<br/>(Preview)"]
        end

        subgraph SidebarArea["Sidebar"]
            SidebarScene["Scene Panel"]
            SidebarObject["Object Panel"]
            SidebarGeometry["Geometry Panel"]
            SidebarMaterial["Material Panel"]
            SidebarScript["Script Panel"]
            SidebarProject["Project Panel"]
            SidebarSettings["Settings Panel"]
        end
    end

    MenuFile -->|New/Open/Save| Viewport
    MenuFile -->|Import| GLTFDialog["GLTF Import Dialog"]
    MenuFile -->|Export| ExportDialog["Export Dialog"]
    MenuAdd -->|Add Object| Viewport
    MenuRender -->|Render| RenderOutput["Render Output"]
    MenuView -->|Toggle Panels| SidebarArea

    GLTFDialog -->|Load| Viewport
    ExportDialog -->|Export| StandaloneApp["Standalone App<br/>(editor/js/libs/app/index.html)"]

    Viewport <-->|Select Object| SidebarObject
    Viewport <-->|Edit Geometry| SidebarGeometry
    Viewport <-->|Edit Material| SidebarMaterial

    SidebarScene -->|Select Object| Viewport
    SidebarScript -->|Edit Script| ScriptEditor

    TransformTools -->|Transform| Viewport

    Player <-->|Play/Stop| Viewport
```

## Editor Sidebar 詳細遷移図

```mermaid
flowchart LR
    subgraph Sidebar["Sidebar Navigation"]
        direction TB
        TabScene["Scene Tab"]
        TabProject["Project Tab"]
        TabSettings["Settings Tab"]
    end

    TabScene --> ScenePanel
    TabProject --> ProjectPanel
    TabSettings --> SettingsPanel

    subgraph ScenePanel["Scene Panel"]
        Outliner["Outliner<br/>(Scene Hierarchy)"]
        Background["Background Settings"]
        Environment["Environment Settings"]
        Fog["Fog Settings"]
    end

    subgraph ObjectSection["Object Properties (when selected)"]
        ObjectProps["Object Properties"]
        GeometryProps["Geometry Properties"]
        MaterialProps["Material Properties"]
        ScriptProps["Script Properties"]
    end

    Outliner -->|Select Object| ObjectSection

    subgraph ProjectPanel["Project Panel"]
        AppSettings["App Settings"]
        RendererSettings["Renderer Settings"]
        Resources["Resources"]
        Materials["Materials"]
    end

    subgraph SettingsPanel["Settings Panel"]
        Language["Language"]
        Theme["Theme"]
        History["History"]
        Shortcuts["Shortcuts"]
    end
```

## Editor Menu 操作フロー

```mermaid
flowchart TB
    subgraph FileMenu["File Menu Operations"]
        NewScene["New"] --> ClearScene["Clear Scene"]
        OpenFile["Open"] --> LoadJSON["Load JSON"]
        SaveFile["Save"] --> SaveJSON["Save to IndexedDB"]

        ImportGroup["Import"]
        ImportGroup --> ImportGLTF["Import GLTF/GLB"]
        ImportGroup --> ImportFBX["Import FBX"]
        ImportGroup --> ImportOBJ["Import OBJ"]
        ImportGroup --> ImportOther["Import Others..."]

        ExportGroup["Export"]
        ExportGroup --> ExportGLTF["Export GLTF"]
        ExportGroup --> ExportOBJ["Export OBJ"]
        ExportGroup --> ExportSTL["Export STL"]
        ExportGroup --> ExportApp["Publish App"]
    end

    ImportGLTF --> GLTFImportDialog["GLTF Import Dialog"]
    GLTFImportDialog --> SceneLoaded["Scene Updated"]

    ExportApp --> StandaloneApp["Standalone HTML App"]
```

## Examples 画面遷移図

```mermaid
flowchart TB
    subgraph ExamplesMain["Examples Main (examples/index.html)"]
        SearchFilter["Search/Filter"]
        CategoryList["Category List"]
        ThumbnailView["Thumbnail View"]
        ExampleViewer["Example Viewer (iframe)"]
    end

    SearchFilter --> FilteredList["Filtered Examples"]
    CategoryList --> FilteredList
    FilteredList --> ThumbnailView
    ThumbnailView -->|Click| ExampleViewer

    subgraph Categories["Example Categories"]
        WebGL["WebGL (217)"]
        WebGLPost["WebGL Postprocessing (26)"]
        WebGLAdv["WebGL Advanced (47)"]
        WebGPU["WebGPU (194)"]
        WebAudio["WebAudio (4)"]
        WebXR["WebXR (26)"]
        Physics["Physics (13)"]
        CSS3D["CSS3D (7)"]
        CSS2D["CSS2D (1)"]
        SVGCat["SVG (2)"]
        Misc["Misc (17)"]
        Games["Games (1)"]
        Tests["Tests (2)"]
    end

    Categories --> ThumbnailView

    ExampleViewer -->|View Source| GitHubSource["GitHub Source"]
```

## Documentation 画面遷移図

```mermaid
flowchart TB
    subgraph DocsMain["Documentation (docs/index.html)"]
        DocsSearch["Search"]
        DocsNav["Navigation Tree"]
        DocsContent["Content Viewer (iframe)"]
    end

    DocsSearch --> SearchResults["Search Results"]
    SearchResults --> DocsContent
    DocsNav --> DocsContent

    subgraph InteractiveDocs["Interactive Documentation"]
        GeoBrowser["Geometry Browser<br/>docs/scenes/geometry-browser.html"]
        MatBrowser["Material Browser<br/>docs/scenes/material-browser.html"]
        BonesBrowser["Bones Browser<br/>docs/scenes/bones-browser.html"]
        CCDIKBrowser["CCDIK Browser<br/>docs/scenes/ccdiksolver-browser.html"]
    end

    DocsContent --> InteractiveDocs
```

## Manual 画面遷移図

```mermaid
flowchart TB
    subgraph ManualMain["Manual (manual/index.html)"]
        ManualSearch["Search"]
        ManualNav["Chapter Navigation"]
        ManualContent["Content Viewer (iframe)"]
        LangSelect["Language Selector<br/>(en/fr/ru/ko/zh/ja)"]
    end

    LangSelect --> ManualNav
    ManualSearch --> ManualContent
    ManualNav --> ManualContent

    subgraph Chapters["Manual Chapters"]
        Fundamentals["Fundamentals"]
        Techniques["Techniques"]
        Solutions["Solutions"]
        Tips["Tips"]
    end

    ManualNav --> Chapters
    Chapters --> ManualContent
```

## スタンドアロンアプリ遷移

```mermaid
flowchart LR
    Editor["Editor"] -->|Export/Publish| StandaloneApp["Standalone App<br/>(editor/js/libs/app/index.html)"]
    StandaloneApp -->|Load| RuntimeScene["Runtime Scene"]
    RuntimeScene -->|User Interaction| ScriptExecution["Script Execution"]
    ScriptExecution --> RuntimeScene
```

## 備考

- Editor は Single Page Application (SPA) 構成で、各パネル間の遷移はDOM操作による表示切替
- Examples は iframe を使用して各サンプルを表示
- Documentation/Manual も iframe ベースの表示構造
- Editor から export した Standalone App は独立して動作可能
