---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 107
  claims_with_evidence: 95
  claims_without_evidence: 12
confidence_derived: 0.89
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：95 / 107、根拠なし：12
- 優先レビュー（高）
  1. **物理シミュレーションサンプル（画面27）**：物理エンジン連携は外部ライブラリ依存のため詳細確認必要
  2. **CSS3D/CSS2D/SVGサンプル（画面28-30）**：専用レンダラー使用のため機能マッピング要確認
  3. **Examples系画面の機能関連**：サンプル数が多く全てのマッピングを網羅できていない可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `editor/js/Viewport.js`
- E-04: `editor/js/Sidebar.Scene.js`
- E-05: `editor/js/Sidebar.Object.js`
- E-06: `editor/js/Sidebar.Geometry.js`
- E-07: `editor/js/Sidebar.Material.js`
- E-08: `editor/js/Menubar.File.js`
- E-09: `editor/js/Menubar.Add.js`
- E-10: `editor/js/Menubar.Edit.js`
- E-11: `editor/js/Menubar.Render.js`
- E-12: `editor/js/Player.js`
- E-13: `editor/js/Script.js`
- E-14: `src/core/Object3D.js` (機能一覧より参照)
- E-15: `src/renderers/WebGLRenderer.js` (機能一覧より参照)
- E-16: `src/scenes/Scene.js` (機能一覧より参照)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エディタメイン画面とWebGLRenderer/WebGPURendererの関連 | E-03, E-15 | ○ |
| C-02 | ViewportとRaycasterの関連（オブジェクト選択） | E-03 | ○ |
| C-03 | ViewportとGridHelper/BoxHelperの関連 | E-03 | ○ |
| C-04 | Sidebar - SceneとScene/Fog/FogExp2の関連 | E-04, E-16 | ○ |
| C-05 | Sidebar - ObjectとObject3D/Vector3/Eulerの関連 | E-05, E-14 | ○ |
| C-06 | Sidebar - GeometryとBufferGeometry各種の関連 | E-06 | ○ |
| C-07 | Sidebar - MaterialとMaterial各種の関連 | E-07 | ○ |
| C-08 | Menubar - FileとFileLoader/ObjectLoaderの関連 | E-08 | ○ |
| C-09 | Menubar - AddとMesh/Geometry/Light/Cameraの関連 | E-09 | ○ |
| C-10 | Menubar - EditとObject3D/Vector3/Box3の関連 | E-10 | ○ |
| C-11 | Menubar - RenderとWebGLRenderer/PostProcessingの関連 | E-11 | ○ |
| C-12 | PlayerとAnimationMixer/Clock/WebGLRendererの関連 | E-12 | ○ |
| C-13 | Script EditorとShaderMaterial/RawShaderMaterialの関連 | E-13 | ○ |
| C-14 | WebGL基本サンプルとWebGLRenderer/BufferGeometry/Materialの関連 | E-02 | ○ |
| C-15 | WebGPUサンプルとWebGPURenderer/TSLの関連 | E-02 | ○ |
| C-16 | WebAudioサンプルとAudio/AudioListener/PositionalAudioの関連 | E-02 | ○ |
| C-17 | WebXRサンプルとWebXRController/XRManagerの関連 | E-02 | ○ |
| C-18 | Geometry BrowserとBoxGeometry/SphereGeometryの関連 | E-01, E-02 | ○ |
| C-19 | Material Browserとマテリアル各種の関連 | E-01, E-02 | ○ |
| C-20 | Bones BrowserとSkinnedMesh/Skeleton/Boneの関連 | E-01, E-02 | ○ |
| C-21 | 物理シミュレーションとObject3D/Mesh/Matrix4の関連 | **根拠不足** | △ |
| C-22 | CSS3DサンプルとObject3Dの関連 | **根拠不足** | △ |
| C-23 | CSS2DサンプルとObject3Dの関連 | **根拠不足** | △ |
| C-24 | SVGサンプルとObject3Dの関連 | **根拠不足** | △ |
| C-25 | その他サンプルとControlsの関連 | E-02 | ○ |
| C-26 | GLTF Import DialogとObjectLoader/LoadingManagerの関連 | E-01, E-08 | ○ |
| C-27 | ユニットテストと各コア機能の関連 | E-01 | ○ |
| C-28 | Examples一覧画面とEventDispatcherの関連 | **推定** | △ |
| C-29 | ドキュメントトップとEventDispatcherの関連 | **推定** | △ |
| C-30 | マニュアルトップとEventDispatcherの関連 | **推定** | △ |
| C-31 | スタンドアロンアプリとWebGLRenderer/AnimationMixerの関連 | E-01, E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- 物理シミュレーションサンプルは外部ライブラリ（Ammo.js、Rapier、Jolt）との連携詳細が未確認
  - 候補：examples/physics_*.html / 外部ドキュメント / 物理エンジンドキュメント
- CSS3D/CSS2D/SVGサンプルは専用レンダラーファイルの詳細調査が必要
  - 候補：examples/jsm/renderers/CSS3DRenderer.js / CSS2DRenderer.js / SVGRenderer.js
- Examples一覧画面のイベント管理詳細はJavaScriptファイル要調査
  - 候補：examples/index.html / examples/files.js
- ドキュメント・マニュアルのイベント管理は別途調査が必要
  - 候補：docs/index.html / manual/index.html

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - 物理シミュレーションサンプルのマッピングは外部ライブラリ依存のため正確性要確認
- **1: 中リスク** - CSS3D/CSS2D/SVGサンプルは専用レンダラー使用のため追加調査推奨
- **0: 低リスク** - Editorコンポーネント（画面1-19）のマッピングはソースコード解析により高精度
- **0: 低リスク** - Geometry Browser/Material Browser/Bones Browserのマッピングは画面一覧・機能一覧との整合性確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] エディタコンポーネント（画面1-19）の機能マッピングが実際のUIと一致しているか
- [ ] Examplesサンプル（画面20-33）の主機能が適切に割り当てられているか
- [ ] 物理シミュレーションサンプルの外部ライブラリ連携が正確か確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か
- [ ] 画面一覧.csvの全画面がマッピングに含まれているか（40画面中40画面をカバー）
- [ ] 機能一覧.csvの主要機能がマッピングに含まれているか
