# 画面設計書 1-エディタメイン画面

## 概要

three.js Editorのメインエントリーポイントとなる画面設計書。本ドキュメントでは、3Dシーンを編集するためのメインエディタ画面の構成、機能、操作について詳細に記述する。

### 本画面の処理概要

エディタメイン画面は、three.js Editorの中核となるSingle Page Application (SPA)構成の画面である。Viewport、Sidebar、Menubar、Toolbar、Scriptエディタ、Playerなど複数のコンポーネントを統合し、3Dコンテンツの作成・編集・プレビュー・エクスポートまでの一連のワークフローを提供する。

**業務上の目的・背景**：3Dグラフィックスの開発において、コーディングなしで視覚的に3Dシーンを構築・編集できる環境を提供する。デザイナーや開発者が直感的に3Dコンテンツを作成し、WebGL/WebGPUアプリケーションとしてエクスポートできるようにすることで、3D開発の敷居を下げることを目的とする。PWA (Progressive Web App) に対応しており、オフライン環境でも利用可能。

**画面へのアクセス方法**：ブラウザで `editor/index.html` を直接開く、またはthree.jsプロジェクトのドキュメントサイトからEditorリンクをクリックしてアクセスする。URLハッシュパラメータ `#file=` を使用してプロジェクトファイルを直接読み込むことも可能。

**主要な操作・処理内容**：
1. 3Dオブジェクト（メッシュ、ライト、カメラなど）の追加・削除・編集
2. オブジェクトの位置、回転、スケールの変形操作
3. マテリアルとテクスチャの設定・編集
4. シーンの背景、環境、フォグの設定
5. JavaScriptスクリプトによるインタラクティブ動作の追加
6. プロジェクトの保存・読み込み・エクスポート
7. 各種3Dフォーマット（GLTF、FBX、OBJなど）のインポート
8. シーンの再生プレビュー

**画面遷移**：本画面はSPA構成のため、内部的にはパネルの表示/非表示切り替えで状態が変化する。外部への遷移としては、エクスポートしたスタンドアロンアプリ（`editor/js/libs/app/index.html`）への遷移がある。

**権限による表示制御**：本エディタはクライアントサイドのみで動作し、認証・認可機能は存在しない。すべての機能がすべてのユーザーに開放されている。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | WebGLRenderer | 主機能 | 3Dシーンのレンダリング処理を担当 |
| 14 | WebGPURenderer | 主機能 | WebGPU APIを使用したレンダリング処理 |
| 24 | Scene | 主機能 | 編集対象のシーングラフを管理 |
| 19 | PerspectiveCamera | 主機能 | 3Dビューのカメラ制御 |
| 110 | AnimationMixer | 補助機能 | シーン内オブジェクトのアニメーション再生 |

## 画面種別

統合開発環境（IDE）型 / 編集画面

## URL/ルーティング

- ベースURL: `editor/index.html`
- ハッシュパラメータ: `#file={プロジェクトファイルパス}` - 指定されたプロジェクトファイルを起動時に読み込む

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 説明 |
|--------|----------|----------|------|
| プロジェクトJSON | 入力/出力 | JSON | シーン、カメラ、スクリプト、履歴を含む完全なプロジェクトデータ |
| 3Dモデルファイル | 入力 | File | GLTF/GLB、FBX、OBJ、STL等の3Dモデルファイル |
| テクスチャ画像 | 入力 | File | PNG、JPG、HDR等の画像ファイル |
| エクスポートファイル | 出力 | File | GLTF、OBJ、STL、USDZ等のエクスポート形式 |

## 表示項目

| 領域 | 表示内容 | 説明 |
|------|----------|------|
| Menubar | File, Edit, Add, Render, View, Helpメニュー | 主要操作へのアクセス |
| Toolbar | 変形ツール（移動/回転/スケール）、スナップ設定 | オブジェクト操作ツール |
| Viewport | 3Dシーンビュー、グリッド、ヘルパー | メイン編集領域 |
| Sidebar | Scene/Project/Settingsタブ、オブジェクトプロパティ | 詳細設定パネル |
| Script Editor | CodeMirrorベースのJavaScriptエディタ | スクリプト編集領域 |
| Player | シーンプレビュー領域 | 再生/停止コントロール |

## イベント仕様

### 1-初期化処理

画面読み込み時に以下の処理が実行される：

1. Editorインスタンスの生成（行78）
2. 各コンポーネント（Viewport、Toolbar、Script、Player、Sidebar、Menubar、Resizer）の初期化と DOM への追加（行83-102）
3. IndexedDBストレージの初期化とプロジェクトデータの復元（行106-131）
4. 自動保存機能の設定（行134-175）
5. ドラッグ&ドロップイベントのセットアップ（行180-205）
6. ServiceWorkerの登録（行245-255）

### 2-ファイルドラッグ&ドロップ

ファイルをエディタにドロップした際の処理：

1. `dragover`イベントで`preventDefault()`を呼び、ドロップを許可
2. `drop`イベントでファイルを受け取り、`editor.loader.loadFiles()`または`loadItemList()`を呼び出し
3. ローダーがファイル形式を判定し、適切なパーサーでシーンに追加

### 3-自動保存処理

シーンの変更が発生した際、1秒後に自動的にIndexedDBに保存：

- 対象シグナル: geometryChanged, objectAdded, objectChanged, objectRemoved, materialChanged, sceneBackgroundChanged, sceneEnvironmentChanged, sceneFogChanged, sceneGraphChanged, scriptChanged, historyChanged
- 保存形式: `editor.toJSON()`の結果

### 4-URLハッシュからのプロジェクト読み込み

URLに`#file=`パラメータが含まれる場合：

1. ユーザーに確認ダイアログを表示
2. 承諾された場合、`THREE.FileLoader`でファイルを読み込み
3. `editor.clear()`で現在のプロジェクトをクリア
4. `editor.fromJSON()`でプロジェクトを復元

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ストレージ | 操作種別 | 概要 |
|----------------|---------------|---------|------|
| 自動保存 | IndexedDB | UPDATE | プロジェクト状態の永続化 |
| プロジェクトクリア | IndexedDB | DELETE | 保存データの削除 |

### テーブル別更新項目詳細

#### IndexedDB (editor.storage)

| 操作 | キー | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SET | state | editor.toJSON()の結果 | JSON形式のプロジェクトデータ |
| GET | state | - | 起動時にプロジェクトを復元 |
| CLEAR | - | - | 新規プロジェクト作成時 |

## メッセージ仕様

| 種別 | キー | メッセージ内容 | 表示条件 |
|------|------|--------------|----------|
| 確認 | prompt/file/open | プロジェクトを開きますか？ | ファイル読み込み時 |

## 例外処理

| 状況 | 処理 |
|------|------|
| プロジェクトJSON読み込み失敗 | コンソールにエラー出力、読み込み処理を中断 |
| ServiceWorker登録失敗 | エラーをキャッチし、処理を継続（PWA機能のみ無効化） |
| ファイルドロップ処理失敗 | ローダー内でエラーハンドリング |

## 備考

- PWA対応：ServiceWorkerにより、オフラインでも利用可能
- Import Maps使用：ESM形式のモジュール読み込みにImport Mapsを使用
- 外部ライブラリ：CodeMirror（スクリプトエディタ）、signals.js（イベント管理）、esprima（JS解析）、jsonlint（JSON検証）、acorn/tern（コード補完）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Editorクラスの構造とシグナルシステムを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Editor.js | `editor/js/Editor.js` | Editorクラスの全体構造、シグナル定義（行19-98）、プロパティ（行101-136） |
| 1-2 | Config.js | `editor/js/Config.js` | 設定管理の仕組み |
| 1-3 | Storage.js | `editor/js/Storage.js` | IndexedDBを使用した永続化 |

**読解のコツ**: signals.jsライブラリのSignalパターンを理解しておくと、コンポーネント間通信の仕組みが把握しやすい。

#### Step 2: エントリーポイントを理解する

処理の起点となるindex.htmlのスクリプト部分を読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `editor/index.html` | Import Maps（行15-27）、モジュール初期化（行60-257） |

**主要処理フロー**:
1. **行62-71**: THREE、各コンポーネントのimport
2. **行78**: Editorインスタンス生成
3. **行83-102**: 各UIコンポーネントの初期化とDOM追加
4. **行106-176**: ストレージ初期化と自動保存設定
5. **行180-205**: ドラッグ&ドロップ設定
6. **行219-241**: URLハッシュからの読み込み
7. **行245-255**: ServiceWorker登録

#### Step 3: 主要コンポーネントを理解する

各UIコンポーネントの役割と相互作用を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Viewport.js | `editor/js/Viewport.js` | 3Dビューの描画、オブジェクト選択、変形操作 |
| 3-2 | Sidebar.js | `editor/js/Sidebar.js` | サイドバーの構成、タブ管理 |
| 3-3 | Menubar.js | `editor/js/Menubar.js` | メニューバーの構成 |
| 3-4 | Toolbar.js | `editor/js/Toolbar.js` | 変形ツールの切り替え |

#### Step 4: シグナルによるイベントフローを理解する

コンポーネント間のイベント連携を追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Editor.js | `editor/js/Editor.js` | シグナル定義（行19-98）とメソッド（行142-780） |
| 4-2 | Selector.js | `editor/js/Selector.js` | オブジェクト選択処理 |
| 4-3 | History.js | `editor/js/History.js` | Undo/Redo管理 |

### プログラム呼び出し階層図

```
editor/index.html
    │
    ├─ Editor.js (new Editor())
    │      ├─ Config.js
    │      ├─ Loader.js
    │      ├─ History.js
    │      ├─ Strings.js
    │      ├─ Storage.js
    │      └─ Selector.js
    │
    ├─ Viewport.js (new Viewport(editor))
    │      ├─ EditorControls.js
    │      ├─ ViewportControls.js
    │      ├─ ViewportInfo.js
    │      ├─ ViewHelper.js
    │      ├─ Viewport.XR.js
    │      └─ Viewport.Pathtracer.js
    │
    ├─ Toolbar.js (new Toolbar(editor))
    │
    ├─ Script.js (new Script(editor))
    │
    ├─ Player.js (new Player(editor))
    │
    ├─ Sidebar.js (new Sidebar(editor))
    │      ├─ Sidebar.Scene.js
    │      ├─ Sidebar.Object.js
    │      ├─ Sidebar.Geometry.js
    │      ├─ Sidebar.Material.js
    │      ├─ Sidebar.Script.js
    │      ├─ Sidebar.Project.js
    │      └─ Sidebar.Settings.js
    │
    ├─ Menubar.js (new Menubar(editor))
    │      ├─ Menubar.File.js
    │      ├─ Menubar.Edit.js
    │      ├─ Menubar.Add.js
    │      ├─ Menubar.Render.js
    │      ├─ Menubar.View.js
    │      └─ Menubar.Help.js
    │
    └─ Resizer.js (new Resizer(editor))
```

### データフロー図

```
[入力]               [処理]                    [出力]

ファイルドロップ ──▶ editor.loader ─────────▶ editor.scene
                         │
                         ▼
プロジェクトJSON ──▶ editor.fromJSON() ────▶ scene/camera/scripts
                         │
                         ▼
URLハッシュ ───────▶ FileLoader ────────────▶ editor.fromJSON()
                         │
                         │
シーン変更 ─────────▶ signals.xxxChanged ──▶ editor.storage.set()
      │                                            │
      ▼                                            ▼
  Viewport描画                              IndexedDB永続化
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `editor/index.html` | テンプレート | メインHTMLエントリーポイント |
| Editor.js | `editor/js/Editor.js` | ソース | エディタ中核クラス |
| Viewport.js | `editor/js/Viewport.js` | ソース | 3Dビュー管理 |
| Sidebar.js | `editor/js/Sidebar.js` | ソース | サイドバー統合 |
| Menubar.js | `editor/js/Menubar.js` | ソース | メニューバー統合 |
| Toolbar.js | `editor/js/Toolbar.js` | ソース | ツールバー |
| Script.js | `editor/js/Script.js` | ソース | スクリプトエディタ |
| Player.js | `editor/js/Player.js` | ソース | シーンプレビュー |
| Config.js | `editor/js/Config.js` | ソース | 設定管理 |
| Loader.js | `editor/js/Loader.js` | ソース | ファイルインポート |
| History.js | `editor/js/History.js` | ソース | Undo/Redo管理 |
| Storage.js | `editor/js/Storage.js` | ソース | IndexedDB永続化 |
| Strings.js | `editor/js/Strings.js` | ソース | 多言語文字列管理 |
| Selector.js | `editor/js/Selector.js` | ソース | オブジェクト選択 |
| main.css | `editor/css/main.css` | スタイル | メインスタイルシート |
| sw.js | `editor/sw.js` | ソース | ServiceWorker |
| manifest.json | `editor/manifest.json` | 設定 | PWAマニフェスト |
