# 画面設計書 16-Toolbar

## 概要

本ドキュメントは、three.js エディタにおける変形ツールバー（Toolbar）の画面設計書である。このツールバーは、3Dオブジェクトの変形操作（移動、回転、スケール）を切り替えるためのボタン群を提供する。

### 本画面の処理概要

**業務上の目的・背景**：3Dシーン編集において、オブジェクトの位置調整（移動）、向きの調整（回転）、サイズ調整（スケール）は最も基本的かつ頻繁に行われる操作である。これらの操作モードを素早く切り替えられることは、作業効率に直結する。ツールバーは、アイコンボタンによる直感的な操作モード切り替えを提供し、3Dコンテンツ制作のワークフローを支援する。

**画面へのアクセス方法**：エディタメイン画面（editor/index.html）の上部に常時表示される。ツールバーはViewportの上部に固定配置されている。

**主要な操作・処理内容**：
1. **Translate（移動）**：オブジェクトの位置を変更するモードに切り替え
2. **Rotate（回転）**：オブジェクトの回転を変更するモードに切り替え
3. **Scale（スケール）**：オブジェクトのサイズを変更するモードに切り替え

**画面遷移**：ツールバー操作によりViewportの操作モードが変更される。選択されたボタンはハイライト表示され、Viewport上のTransformControlsの表示が変更される。

**権限による表示制御**：特別な権限制御は存在しない。すべてのユーザーがすべての変形ツールを使用できる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Object3D | 主機能 | 変形ツール（移動・回転・スケール）の制御 |

## 画面種別

ツールバー

## URL/ルーティング

エディタメイン画面の一部として `editor/index.html` に含まれる。独立したルーティングは持たない。

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 説明 |
|--------|----------|---------|------|
| transformMode | 出力 | String | 現在の変形モード（'translate' / 'rotate' / 'scale'） |

## 表示項目

| 項目 | アイコン | ツールチップ | 初期状態 |
|------|---------|-------------|---------|
| Translate | images/translate.svg | toolbar/translate | 選択状態（selected） |
| Rotate | images/rotate.svg | toolbar/rotate | 非選択状態 |
| Scale | images/scale.svg | toolbar/scale | 非選択状態 |

## イベント仕様

### 1-Translate（移動モード）

- **トリガー**：Translateボタンクリック
- **処理内容**：
  1. `signals.transformModeChanged.dispatch('translate')` を発行
  2. TransformControlsの表示が移動用ギズモに変更される
- **画面更新**：Translateボタンがselectedクラスでハイライト、他のボタンは非選択状態

### 2-Rotate（回転モード）

- **トリガー**：Rotateボタンクリック
- **処理内容**：
  1. `signals.transformModeChanged.dispatch('rotate')` を発行
  2. TransformControlsの表示が回転用ギズモに変更される
- **画面更新**：Rotateボタンがselectedクラスでハイライト、他のボタンは非選択状態

### 3-Scale（スケールモード）

- **トリガー**：Scaleボタンクリック
- **処理内容**：
  1. `signals.transformModeChanged.dispatch('scale')` を発行
  2. TransformControlsの表示がスケール用ギズモに変更される
- **画面更新**：Scaleボタンがselectedクラスでハイライト、他のボタンは非選択状態

### 4-transformModeChanged（モード変更時）

- **トリガー**：`signals.transformModeChanged` が発行された時（外部からの変更含む）
- **処理内容**：
  1. すべてのボタンから `selected` クラスを削除
  2. 現在のモードに対応するボタンに `selected` クラスを追加
- **目的**：キーボードショートカット等、ツールバー以外からのモード変更にも対応

## データベース更新仕様

本画面はブラウザ上で動作する3Dエディタであり、データベースへの直接的な更新は行わない。

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| なし | - | 本ツールバーでは特別なメッセージ表示はない |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| なし | 本ツールバーでは特別な例外処理はない |

## 備考

- Translateボタンがデフォルトで選択状態（`Button selected`クラス）
- アイコン画像は `images/` ディレクトリに配置されたSVGファイルを使用
- ボタンのツールチップは `strings.getKey()` で多言語対応
- `signals.transformModeChanged` を購読することで、外部からのモード変更にも同期する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Toolbar.js | `editor/js/Toolbar.js` | ツールバー構築とイベントハンドラ |

**主要処理フロー**:
1. **3-9行目**: UIPanel作成、id='toolbar'を設定
2. **11-25行目**: Translateボタンの作成（初期状態: selected）
3. **27-38行目**: Rotateボタンの作成
4. **40-51行目**: Scaleボタンの作成
5. **55-69行目**: transformModeChangedシグナル購読（ボタン状態の同期）

**読解のコツ**: 各ボタンはimg要素を内包するUIButtonとして作成される。クリック時にsignals.transformModeChanged.dispatch()を呼び出す。

#### Step 2: Viewportとの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Viewport.js | `editor/js/Viewport.js` | transformModeChangedシグナルのハンドラ |

**主要処理フロー**:
- ViewportではtransformModeChangedシグナルを購読し、TransformControlsのmodeプロパティを更新

### プログラム呼び出し階層図

```
Toolbar (Toolbar.js)
    │
    ├─ translate.onClick()
    │      └─ signals.transformModeChanged.dispatch('translate')
    │             └─ Viewport.js: transformControls.setMode('translate')
    │
    ├─ rotate.onClick()
    │      └─ signals.transformModeChanged.dispatch('rotate')
    │             └─ Viewport.js: transformControls.setMode('rotate')
    │
    ├─ scale.onClick()
    │      └─ signals.transformModeChanged.dispatch('scale')
    │             └─ Viewport.js: transformControls.setMode('scale')
    │
    └─ signals.transformModeChanged.add(callback)
           └─ ボタンのselected状態を更新
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ボタンクリック ─────────▶ Toolbar.js ──────────────▶ signals.transformModeChanged
                              │                              │
                              │                              ▼
                              │                        Viewport.js
                              │                        (TransformControls更新)
                              │                              │
signals.transformModeChanged ◀───────────────────────────────┘
        │                            (外部からのモード変更)
        ▼
  ボタン状態更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Toolbar.js | `editor/js/Toolbar.js` | ソース | ツールバーの主要実装 |
| ui.js | `editor/js/libs/ui.js` | ソース | UIコンポーネント（UIPanel, UIButton等） |
| Viewport.js | `editor/js/Viewport.js` | ソース | transformModeChangedシグナル処理 |
| Editor.js | `editor/js/Editor.js` | ソース | signalsオブジェクトの管理 |
| translate.svg | `editor/images/translate.svg` | 画像 | 移動ツールアイコン |
| rotate.svg | `editor/images/rotate.svg` | 画像 | 回転ツールアイコン |
| scale.svg | `editor/images/scale.svg` | 画像 | スケールツールアイコン |
