# 画面設計書 18-Player

## 概要

本ドキュメントは、three.js エディタにおけるプレイヤー（Player）の画面設計書である。Playerは、編集中の3Dシーンをランタイムモードで再生/停止するプレビュー機能を提供し、スクリプトの動作確認やアニメーションのテストを可能にする。

### 本画面の処理概要

**業務上の目的・背景**：3Dコンテンツ制作において、編集中のシーンが実際にどのように動作するかを確認することは不可欠である。特に、JavaScriptスクリプトで実装したインタラクション、アニメーション、ユーザー入力への応答などは、実際に再生してみないと検証できない。Playerは、エディタ内で即座にシーンを再生し、スクリプトの動作を確認できるプレビュー環境を提供する。

**画面へのアクセス方法**：エディタメイン画面（editor/index.html）でPlay/Stopボタン（または対応するショートカット）を操作することでPlayerが表示/非表示になる。

**主要な操作・処理内容**：
1. **Play（再生）**：シーンをJSON化し、APP.Playerに読み込んで再生開始
2. **Stop（停止）**：再生を停止し、Playerパネルを非表示にしてエディタモードに戻る

**画面遷移**：Play時にPlayerパネルがViewportを覆う形で表示される。Stop時にPlayerパネルが非表示になり、通常のエディタ画面に戻る。

**権限による表示制御**：特別な権限制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 110 | AnimationMixer | 主機能 | シーン再生時のアニメーション制御 |
| 13 | WebGLRenderer | 主機能 | プレビュー再生時のレンダリング |
| 6 | Clock | 補助機能 | 再生時間の管理 |

## 画面種別

プレビューパネル（オーバーレイ）

## URL/ルーティング

エディタメイン画面の一部として `editor/index.html` に含まれる。独立したルーティングは持たない。

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 説明 |
|--------|----------|---------|------|
| editor.toJSON() | 入力 | Object | シーン、カメラ、スクリプトを含むプロジェクトJSON |

## 表示項目

| 項目 | 表示内容 | 説明 |
|------|---------|------|
| Playerパネル | 全画面オーバーレイ | 再生中のシーンを表示 |
| Canvas | WebGL/WebGPU描画領域 | APP.Playerのレンダリング出力 |

## イベント仕様

### 1-startPlayer（再生開始）

- **トリガー**：`signals.startPlayer` が発行された時
- **処理内容**：
  1. `container.setDisplay('')` でPlayerパネルを表示
  2. `player.load(editor.toJSON())` でシーンをロード（非同期）
  3. `player.setSize()` でサイズを設定
  4. `player.play()` で再生開始
- **画面更新**：Playerパネルが表示され、シーンが再生される

### 2-stopPlayer（再生停止）

- **トリガー**：`signals.stopPlayer` が発行された時
- **処理内容**：
  1. `container.setDisplay('none')` でPlayerパネルを非表示
  2. `player.stop()` で再生停止
  3. `player.dispose()` でリソース解放
- **画面更新**：Playerパネルが非表示になり、エディタ画面に戻る

### 3-windowResize（ウィンドウリサイズ）

- **トリガー**：`window.resize` イベントまたは `signals.windowResize` 発行時
- **処理内容**：
  1. `player.setSize(container.dom.clientWidth, container.dom.clientHeight)` でサイズ更新
- **目的**：ウィンドウサイズ変更に追従

## データベース更新仕様

本画面はブラウザ上で動作する3Dエディタであり、データベースへの直接的な更新は行わない。

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| なし | - | 本画面では特別なメッセージ表示はない |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| スクリプトエラー | console.error()でエラー出力、再生は継続 |

## 備考

- APP.Playerはプロジェクト設定（renderer, shadows, toneMapping等）を尊重する
- WebGPURendererとWebGLRendererの両方に対応
- スクリプトイベント（init, start, stop, keydown, keyup, pointerdown, pointerup, pointermove, update）をサポート
- スクリプトはオブジェクトのコンテキストでバインドされて実行される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

APP.Playerが受け取るJSONの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Editor.js | `editor/js/Editor.js` | editor.toJSON()の出力形式（scene, camera, scripts, project） |

**読解のコツ**: JSONにはscene、camera、scripts（uuid別）、project設定が含まれる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Player.js | `editor/js/Player.js` | Playerコンポーネントの構築 |

**主要処理フロー**:
1. **4-16行目**: UIPanelとAPP.Playerの初期化
2. **18-28行目**: windowResizeイベントの処理
3. **30-38行目**: startPlayerシグナルのハンドラ（load → setSize → play）
4. **40-47行目**: stopPlayerシグナルのハンドラ（stop → dispose）

#### Step 3: APP.Playerを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | app.js | `editor/js/libs/app.js` | APP.Playerの実装 |

**主要処理フロー**:
- **19-120行目**: load()関数（レンダラー作成、シーン/カメラパース、スクリプト実行環境構築）
- **32-42行目**: WebGPU/WebGLレンダラーの選択と作成
- **56-116行目**: スクリプトの解析とイベント登録
- **194-208行目**: play()関数（イベントリスナー登録、アニメーションループ開始）
- **210-222行目**: stop()関数（イベントリスナー解除、アニメーションループ停止）

### プログラム呼び出し階層図

```
Player (Player.js)
    │
    ├─ signals.startPlayer.add(callback)
    │      ├─ container.setDisplay('')
    │      ├─ player.load(editor.toJSON())
    │      │      ├─ レンダラー作成 (WebGL/WebGPU)
    │      │      ├─ ObjectLoader.parse(scene)
    │      │      ├─ ObjectLoader.parse(camera)
    │      │      └─ スクリプトのパースとイベント登録
    │      ├─ player.setSize()
    │      └─ player.play()
    │             ├─ イベントリスナー登録
    │             └─ renderer.setAnimationLoop(animate)
    │
    └─ signals.stopPlayer.add(callback)
           ├─ container.setDisplay('none')
           ├─ player.stop()
           │      ├─ イベントリスナー解除
           │      └─ renderer.setAnimationLoop(null)
           └─ player.dispose()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

editor.toJSON() ────────▶ Player.js ───────────────▶ 再生画面表示
                              │
signals.startPlayer ──────────┤
                              │
                              ▼
                         APP.Player
                              │
                              ├─ scene / camera
                              ├─ scripts (イベント)
                              └─ renderer (WebGL/WebGPU)
                                      │
                                      ▼
                              アニメーションループ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Player.js | `editor/js/Player.js` | ソース | Playerコンポーネント |
| app.js | `editor/js/libs/app.js` | ソース | APP.Player実装 |
| ui.js | `editor/js/libs/ui.js` | ソース | UIコンポーネント |
| Editor.js | `editor/js/Editor.js` | ソース | toJSON()実装、signals管理 |
