# 画面設計書 20-Examples一覧画面

## 概要

本ドキュメントは、three.js プロジェクトにおけるサンプル一覧画面（Examples）の画面設計書である。この画面は、three.jsライブラリの各種機能を示すサンプルコードを、カテゴリ別に整理して表示・閲覧できるギャラリー画面である。

### 本画面の処理概要

**業務上の目的・背景**：three.jsは多様な3D機能を提供するライブラリであり、ユーザーが各機能の使い方を学ぶためにはサンプルコードが不可欠である。Examples画面は、500件以上のサンプルをカテゴリ別（WebGL, WebGPU, WebXR, Physics等）に整理し、検索・フィルタリング・サムネイルプレビュー機能を通じて、ユーザーが効率的に目的のサンプルを見つけられるようにする。

**画面へのアクセス方法**：ブラウザで `examples/index.html` に直接アクセスする。three.jsの公式サイトからもリンクされている。

**主要な操作・処理内容**：
1. **カテゴリ表示**：サンプルをカテゴリ別（WebGL, WebGPU, WebXR等）に分類表示
2. **検索・フィルタ**：テキスト入力によるサンプル名・タグでのフィルタリング
3. **サムネイルプレビュー**：各サンプルのスクリーンショットを表示
4. **サンプル実行**：クリックでiframe内にサンプルを読み込み実行
5. **ソースコード表示**：GitHubへのリンクでソースコードを表示

**画面遷移**：サンプルクリックでiframe内にサンプルが読み込まれる。パネルは折りたたみ可能。URLハッシュでサンプル選択状態が保持される。

**権限による表示制御**：特別な権限制御は存在しない。全サンプルが公開されている。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | EventDispatcher | 主機能 | サンプル検索・フィルタイベント管理 |

## 画面種別

一覧（ギャラリー）

## URL/ルーティング

- ベースURL: `examples/index.html`
- クエリパラメータ: `?q={検索クエリ}`
- ハッシュ: `#{サンプル名}` （例: `#webgl_animation_keyframes`）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 説明 |
|--------|----------|---------|------|
| filterInput | 入力 | String | 検索キーワード |
| files.json | 入力 | Object | カテゴリ別サンプル一覧 |
| tags.json | 入力 | Object | サンプルのタグ情報 |
| selected | 出力 | String | 選択中のサンプル名 |

## 表示項目

### パネル部分

| 項目 | 表示内容 | 説明 |
|------|---------|------|
| ヘッダー | three.jsロゴ + "examples"タブ | ナビゲーション |
| 検索入力欄 | テキストボックス | フィルタリング用 |
| クリアボタン | X | 検索クリア |
| カテゴリ見出し | h2要素 | カテゴリ名（webgl, webgpu等） |
| サンプルカード | サムネイル + タイトル | 各サンプルへのリンク |
| サムネイルトグル | アイコン | サムネイル表示/非表示切替 |

### ビューア部分

| 項目 | 表示内容 | 説明 |
|------|---------|------|
| iframe | サンプル実行画面 | 選択されたサンプルを表示 |
| View Sourceボタン | GitHubリンク | ソースコード表示 |

### カテゴリ一覧

| カテゴリ | サンプル数（概算） | 説明 |
|---------|-------------------|------|
| webgl | 217 | WebGL基本サンプル |
| webgl_postprocessing | 26 | 後処理エフェクト |
| webgl_advanced | 47 | 上級者向け |
| webgpu | 194 | WebGPUサンプル |
| webaudio | 4 | 3Dオーディオ |
| webxr | 26 | VR/AR |
| physics | 13 | 物理シミュレーション |
| css3d | 7 | CSS3Dレンダラー |
| css2d | 1 | CSS2Dラベル |
| svg | 2 | SVGレンダラー |
| misc | 17 | その他 |
| games | 1 | ゲーム |
| tests | 2 | テスト用 |

## イベント仕様

### 1-init（初期化）

- **トリガー**：ページロード時
- **処理内容**：
  1. files.jsonとtags.jsonをfetch
  2. カテゴリ別にサンプルリンクを生成
  3. URLハッシュがあればそのサンプルを選択・表示
  4. クエリパラメータがあればフィルタを適用
- **画面更新**：カテゴリ別サンプル一覧が表示される

### 2-サンプル選択

- **トリガー**：サンプルカードクリック
- **処理内容**：
  1. 前回選択のselectedクラスを削除
  2. クリックされたサンプルにselectedクラスを追加
  3. URLハッシュを更新
  4. iframeにサンプルHTMLを読み込み
  5. View Sourceボタンのhrefを更新
  6. パネルを閉じる
- **画面更新**：iframeにサンプルが表示される

### 3-検索・フィルタ

- **トリガー**：検索入力欄への入力
- **処理内容**：
  1. 入力値を正規化（複数スペースを単一に）
  2. URLクエリパラメータを更新
  3. 正規表現でサンプル名・タグをマッチング
  4. マッチしないサンプルにhiddenクラスを追加
  5. カテゴリ内の全サンプルが非表示ならカテゴリ見出しも非表示
- **画面更新**：フィルタ結果に応じてサンプルが表示/非表示

### 4-パネル展開/折りたたみ

- **トリガー**：expandButtonまたはpanelScrimクリック
- **処理内容**：
  1. panelにopenクラスをトグル
- **画面更新**：パネルが展開/折りたたまれる

### 5-サムネイルトグル

- **トリガー**：previewsTogglerクリック
- **処理内容**：
  1. contentにminimalクラスをトグル
- **画面更新**：サムネイルが表示/非表示になる

## データベース更新仕様

本画面は静的なギャラリーページであり、データベースへの更新は行わない。

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| プレースホルダー | "Select an example from the sidebar" | サンプル未選択時のiframe内 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 無効なURLハッシュ | validRedirectsマップで検証し、無効な場合は無視 |
| files.json読み込み失敗 | fetchエラー（ページが正常に機能しない） |

## 備考

- サムネイル画像は `screenshots/{サンプル名}.jpg` に配置
- コミュニティ提供サンプルには「community」タグが付与され、バッジ表示される
- iOS向けにiframeのリサイズワークアラウンドが実装されている
- css3d_mixedサンプルはキャッシュ回避のためタイムスタンプ付きURLを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

サンプル一覧とタグ情報の構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | files.json | `examples/files.json` | カテゴリ別サンプル名の配列 |
| 1-2 | tags.json | `examples/tags.json` | サンプル名をキーとしたタグ配列 |

**読解のコツ**: files.jsonはカテゴリ名をキーとしたオブジェクトで、各値はサンプル名の配列。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `examples/index.html` | HTML構造とインラインJavaScript |

**主要処理フロー**:
1. **45-63行目**: DOM要素の取得、グローバル変数の初期化
2. **65-200行目**: init()関数 - files.json/tags.json読み込み、リンク生成
3. **202-238行目**: createLink()関数 - サンプルカードのHTML生成
4. **240-258行目**: selectFile()関数 - サンプル選択処理
5. **269-300行目**: updateFilter()関数 - フィルタリング処理
6. **302-318行目**: filterExample()関数 - 個別サンプルのフィルタ判定
7. **328-361行目**: layoutList()関数 - カテゴリ表示/非表示

### プログラム呼び出し階層図

```
index.html
    │
    └─ init()
           ├─ fetch('files.json')
           ├─ fetch('tags.json')
           │
           ├─ for (key in files)
           │      ├─ createHeader(key)
           │      └─ for (file in files[key])
           │             └─ createLink(file, tags[file])
           │
           ├─ URLハッシュあり?
           │      └─ selectFile(file) + viewer.src設定
           │
           └─ イベントリスナー登録
                  ├─ filterInput.oninput → updateFilter()
                  ├─ expandButton.onclick → panel.toggle('open')
                  ├─ previewsToggler.onclick → content.toggle('minimal')
                  └─ サンプルリンク.onclick → selectFile()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

files.json ─────────────▶ init() ───────────────────▶ カテゴリ別一覧
tags.json ──────────────▶                            サンプルカード
                              │
URLハッシュ ────────────────────┤                    ▶ iframe表示
                              │
検索入力 ───────────────────────┼─ updateFilter() ─▶ フィルタ結果
                              │
サンプルクリック ───────────────┴─ selectFile() ───▶ URLハッシュ更新
                                                    iframe src設定
                                                    View Sourceリンク設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `examples/index.html` | HTML | メイン画面 |
| files.json | `examples/files.json` | データ | カテゴリ別サンプル一覧 |
| tags.json | `examples/tags.json` | データ | サンプルタグ情報 |
| main.css | `files/main.css` | CSS | スタイル定義 |
| screenshots/ | `examples/screenshots/` | 画像 | サンプルサムネイル |
