# 画面設計書 21-WebGL基本サンプル

## 概要

本ドキュメントは、three.js Examples における WebGL を使用した基本的な 3D サンプル群（約217件）の画面設計書である。WebGL (Web Graphics Library) API を活用した様々な 3D レンダリング技術のデモンストレーションを提供する。

### 本画面の処理概要

WebGL基本サンプル画面は、three.js ライブラリの基本機能を学習・検証するための対話型3Dサンプル集である。各サンプルは独立したHTMLファイルとして実装され、Examples一覧画面（examples/index.html）から iframe 経由で表示される。

**業務上の目的・背景**：three.js を使用した Web 3D アプリケーション開発者に対して、ライブラリの基本機能（アニメーション、カメラ制御、ジオメトリ、マテリアル、ライティング、ローダーなど）の実装例を提供する。開発者はこれらのサンプルを参照・改変することで、効率的に3Dアプリケーションを構築できる。学習目的のリファレンス実装として、またコードスニペットのソースとして活用される。

**画面へのアクセス方法**：
1. examples/index.html にアクセス
2. 左側パネルの「webgl」カテゴリから目的のサンプルを選択
3. 検索フィルタで「webgl_」プレフィックスのサンプルを絞り込み可能
4. サムネイルクリックで右側の iframe にサンプルが表示される

**主要な操作・処理内容**：
1. 3Dシーンの自動レンダリング（requestAnimationLoop使用）
2. マウス/タッチによるカメラ操作（OrbitControls等のコントロール使用）
3. GLTFモデルの読み込みと表示
4. アニメーションの再生・停止
5. GUI によるパラメータ調整（lil-gui 使用）
6. ウィンドウリサイズ時の自動調整

**画面遷移**：
- 遷移元：Examples一覧画面（examples/index.html）
- 遷移先：なし（各サンプルは独立して動作）
- GitHub ソースコードページへの外部リンクあり

**権限による表示制御**：なし（パブリックアクセス）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | WebGLRenderer | 主機能 | WebGLを使用した3Dレンダリング |
| 2 | BufferGeometry | 補助機能 | ジオメトリデータの管理 |
| 48 | Material | 補助機能 | マテリアルの設定 |
| 19 | PerspectiveCamera | 補助機能 | 透視投影カメラの設定 |
| 110 | AnimationMixer | 補助機能 | アニメーションの再生制御 |
| 169 | Controls | 補助機能 | カメラ操作コントロール |

## 画面種別

サンプル / デモンストレーション

## URL/ルーティング

- 一覧: `examples/index.html#webgl_*`
- 個別サンプル: `examples/webgl_*.html`
  - 例: `examples/webgl_animation_keyframes.html`
  - 例: `examples/webgl_geometry_cube.html`
  - 例: `examples/webgl_loader_gltf.html`

## 入出力項目

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| 3Dモデルファイル | 入力 | File (GLTF/OBJ/FBX等) | 外部モデルファイルの読み込み |
| テクスチャファイル | 入力 | File (PNG/JPG/HDR等) | テクスチャマップの読み込み |
| マウス座標 | 入力 | Vector2 | カメラ操作用の座標入力 |
| GUI パラメータ | 入力 | Number/Boolean/Color | リアルタイムパラメータ調整 |
| レンダリング結果 | 出力 | Canvas | WebGL描画結果 |
| 統計情報 | 出力 | DOM (Stats) | FPS、メモリ使用量等 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 3Dシーン | Canvas | WebGLRenderer による3Dレンダリング結果 |
| 情報パネル | HTML div | サンプル説明、クレジット、操作ガイド |
| Stats | DOM overlay | FPS、レンダリング統計情報 |
| GUI パネル | DOM overlay | パラメータ調整用のコントロールパネル |

## イベント仕様

### 1-アニメーションループ

サンプル読み込み後、requestAnimationFrame ベースのレンダリングループが開始される。毎フレーム以下の処理を実行：
1. Timer.update() で経過時間を取得
2. AnimationMixer.update() でアニメーション更新
3. Controls.update() でカメラ状態更新
4. Stats.update() で統計情報更新
5. Renderer.render() でシーン描画

### 2-マウス操作

OrbitControls 等のコントロールクラスにより、マウス操作がカメラ制御に変換される：
- 左ドラッグ: 回転
- 右ドラッグ: パン
- ホイール: ズーム
- ダブルクリック: リセット（一部サンプル）

### 3-ウィンドウリサイズ

window.resize イベントでカメラとレンダラーのサイズを更新：
1. camera.aspect を新しいアスペクト比に設定
2. camera.updateProjectionMatrix() を呼び出し
3. renderer.setSize() で新しいサイズを設定

### 4-モデル読み込み

GLTFLoader 等のローダーでモデルファイルを非同期読み込み：
1. loader.load() または loader.loadAsync() で読み込み開始
2. 読み込み完了後、シーンに追加
3. アニメーションがある場合は AnimationMixer を設定
4. レンダリングループを開始

## データベース更新仕様

### 操作別データベース影響一覧

本画面はフロントエンドのみで動作するサンプルであり、データベースへのアクセスは行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|-----------|----------|
| エラー | コンソールエラー出力 | モデル読み込み失敗時 |
| 警告 | WebGL context lost warning | GPUリソース不足時 |
| 情報 | Stats パネル | FPS、メモリ使用量の表示 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| WebGL非対応ブラウザ | エラーメッセージ表示、フォールバック案内 |
| モデル読み込み失敗 | console.error() でエラーログ出力 |
| テクスチャ読み込み失敗 | デフォルトマテリアルで表示継続 |
| GPUメモリ不足 | context lost イベントハンドリング |

## 備考

- 各サンプルは ES Modules (import/export) 形式で実装
- Import Map を使用してモジュールパスを解決
- three.js コアは `../build/three.module.js` から読み込み
- アドオンモジュールは `./jsm/` ディレクトリから読み込み
- サンプルごとに必要なアドオン（コントロール、ローダー、ポストプロセッシング等）をインポート

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

three.js の基本的なシーングラフ構造と、サンプル間で共通して使用されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | three.module.js | `build/three.module.js` | Scene, Camera, Renderer の基本クラス構造 |
| 1-2 | BufferGeometry.js | `src/core/BufferGeometry.js` | 頂点データの格納形式 |
| 1-3 | Material.js | `src/materials/Material.js` | マテリアルの基本プロパティ |

**読解のコツ**: three.js では Object3D を継承したオブジェクトがシーングラフを構成する。Scene, Camera, Mesh, Light は全て Object3D の派生クラスである。

#### Step 2: エントリーポイントを理解する

典型的なサンプルのエントリーポイントと初期化フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | webgl_animation_keyframes.html | `examples/webgl_animation_keyframes.html` | 基本的なサンプル構造 |

**主要処理フロー**:
1. **Line 39-41**: three.js コアとアドオンのインポート
2. **Line 51-55**: Timer, Stats, Renderer の初期化
3. **Line 60-64**: WebGLRenderer 設定（antialiasing, pixelRatio, size）
4. **Line 66-82**: Scene, Sky, PMREMGenerator による環境設定
5. **Line 84-90**: Camera, OrbitControls の設定
6. **Line 92-113**: GLTFLoader によるモデル読み込みと AnimationMixer 設定
7. **Line 124-138**: animate() 関数でのレンダリングループ

#### Step 3: レンダラーの初期化を理解する

WebGLRenderer の初期化と設定オプションを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WebGLRenderer.js | `src/renderers/WebGLRenderer.js` | レンダラーの初期化パラメータ |

**主要処理フロー**:
- **setPixelRatio()**: デバイスピクセル比の設定
- **setSize()**: キャンバスサイズの設定
- **setAnimationLoop()**: レンダリングループの登録
- **toneMapping**: HDR→SDR変換の設定

#### Step 4: カメラコントロールを理解する

OrbitControls によるインタラクティブなカメラ操作の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | OrbitControls.js | `examples/jsm/controls/OrbitControls.js` | マウス/タッチ入力からカメラ変換への変換ロジック |

**主要処理フロー**:
- **update()**: カメラ位置・向きの更新
- **enableDamping**: 慣性効果の有効化
- **target**: 注視点の設定

#### Step 5: モデルローダーを理解する

GLTFLoader によるモデル読み込みとシーンへの追加を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | GLTFLoader.js | `examples/jsm/loaders/GLTFLoader.js` | GLTF/GLBファイルのパース処理 |
| 5-2 | DRACOLoader.js | `examples/jsm/loaders/DRACOLoader.js` | Draco圧縮のデコード処理 |

**主要処理フロー**:
- **load()**: 非同期読み込み（コールバック形式）
- **loadAsync()**: 非同期読み込み（Promise形式）
- **setDRACOLoader()**: Draco圧縮対応の設定

### プログラム呼び出し階層図

```
webgl_animation_keyframes.html (エントリーポイント)
    |
    +-- THREE.WebGLRenderer
    |      +-- setPixelRatio()
    |      +-- setSize()
    |      +-- setAnimationLoop()
    |      +-- render()
    |
    +-- THREE.Scene
    |      +-- add()
    |      +-- background
    |      +-- environment
    |
    +-- THREE.PerspectiveCamera
    |      +-- updateProjectionMatrix()
    |
    +-- OrbitControls
    |      +-- update()
    |      +-- target
    |
    +-- GLTFLoader
    |      +-- setDRACOLoader()
    |      +-- load()
    |          +-- callback(gltf)
    |              +-- scene.add(gltf.scene)
    |              +-- AnimationMixer(model)
    |                  +-- clipAction()
    |                  +-- play()
    |
    +-- animate() [レンダリングループ]
           +-- timer.update()
           +-- mixer.update()
           +-- controls.update()
           +-- stats.update()
           +-- renderer.render()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GLTFファイル ────────> GLTFLoader.load() ───────────> Scene Graph
                          |
テクスチャ ──────────> TextureLoader ─────────────┘
                          |
マウス入力 ──────────> OrbitControls ──────────────> Camera Transform
                          |
時間経過 ────────────> Timer.getDelta() ──────────> Animation State
                          |                              |
                          v                              v
                    AnimationMixer.update() ──────> Mesh Transforms
                          |
                          v
                    WebGLRenderer.render() ────────> Canvas (WebGL)
                                                         |
                                                         v
                                                    画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `examples/index.html` | テンプレート | サンプル一覧表示・iframe親ページ |
| files.json | `examples/files.json` | 設定 | サンプルファイルのカテゴリ分類 |
| tags.json | `examples/tags.json` | 設定 | サンプルのタグ情報 |
| main.css | `examples/main.css` | スタイル | 共通スタイルシート |
| three.module.js | `build/three.module.js` | ソース | three.js コアモジュール |
| OrbitControls.js | `examples/jsm/controls/OrbitControls.js` | ソース | カメラ操作コントロール |
| GLTFLoader.js | `examples/jsm/loaders/GLTFLoader.js` | ソース | GLTF/GLBローダー |
| DRACOLoader.js | `examples/jsm/loaders/DRACOLoader.js` | ソース | Draco圧縮デコーダー |
| stats.module.js | `examples/jsm/libs/stats.module.js` | ソース | パフォーマンス統計表示 |
| lil-gui.module.min.js | `examples/jsm/libs/lil-gui.module.min.js` | ソース | GUI コントロールパネル |
| webgl_*.html | `examples/webgl_*.html` | テンプレート | 各種WebGLサンプル (約217件) |
