# 画面設計書 22-WebGLポストプロセシング

## 概要

本ドキュメントは、three.js Examples における WebGL 後処理エフェクトサンプル群（約26件）の画面設計書である。レンダリング結果に対してリアルタイムで視覚効果を適用するポストプロセッシング技術のデモンストレーションを提供する。

### 本画面の処理概要

WebGLポストプロセシングサンプル画面は、three.js の EffectComposer を使用した後処理パイプラインの実装例を提供する。基本的な3Dレンダリング結果に対して、Bloom（グロー効果）、DOF（被写界深度）、FXAA（アンチエイリアス）、SSAO（環境遮蔽）などの視覚効果をGPUシェーダーで適用する。

**業務上の目的・背景**：映画やゲームで見られる高品質なビジュアルエフェクトをWebブラウザ上で実現したい開発者に対して、後処理パイプラインの構築方法を提供する。レンダリングパスを組み合わせることで、フォトリアリスティックな表現やスタイライズドな表現を実現できる。パフォーマンスとビジュアル品質のトレードオフを理解するための実験環境としても活用される。

**画面へのアクセス方法**：
1. examples/index.html にアクセス
2. 左側パネルの「webgl / postprocessing」カテゴリを選択
3. 検索フィルタで「postprocessing」を入力して絞り込み
4. 目的のエフェクトサンプルを選択

**主要な操作・処理内容**：
1. シーンのオフスクリーンレンダリング（RenderPass）
2. エフェクトパスの連鎖適用（UnrealBloomPass, DOFPass等）
3. 最終出力パス（OutputPass）でのトーンマッピングとガンマ補正
4. GUI によるエフェクトパラメータのリアルタイム調整
5. ウィンドウリサイズ時の RenderTarget サイズ更新

**画面遷移**：
- 遷移元：Examples一覧画面（examples/index.html）
- 遷移先：なし（各サンプルは独立して動作）
- GitHub ソースコードページへの外部リンクあり

**権限による表示制御**：なし（パブリックアクセス）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | PostProcessing | 主機能 | 後処理エフェクトの適用 |
| 13 | WebGLRenderer | 補助機能 | ベースレンダリング |
| 15 | WebGLRenderTarget | 補助機能 | オフスクリーンレンダリング |
| 19 | PerspectiveCamera | 補助機能 | カメラ設定 |
| 110 | AnimationMixer | 補助機能 | アニメーション再生 |

## 画面種別

サンプル / デモンストレーション

## URL/ルーティング

- カテゴリ: `examples/index.html#webgl_postprocessing`
- 個別サンプル:
  - `examples/webgl_postprocessing.html` - 基本的な後処理
  - `examples/webgl_postprocessing_unreal_bloom.html` - Bloom効果
  - `examples/webgl_postprocessing_dof.html` - 被写界深度
  - `examples/webgl_postprocessing_fxaa.html` - FXAA アンチエイリアス
  - `examples/webgl_postprocessing_ssao.html` - 環境遮蔽
  - 他約21件

## 入出力項目

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| エフェクトパラメータ | 入力 | Number/Boolean | Bloom強度、DOF焦点距離等 |
| exposure | 入力 | Number | トーンマッピング露出値 |
| threshold | 入力 | Number | Bloom閾値 |
| strength | 入力 | Number | Bloom強度 |
| radius | 入力 | Number | Bloomぼかし半径 |
| レンダリング結果 | 出力 | Canvas | エフェクト適用後の描画結果 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 3Dシーン（エフェクト適用後） | Canvas | ポストプロセッシング適用後のレンダリング結果 |
| GUI パネル | DOM overlay | エフェクトパラメータ調整用のコントロール |
| Stats | DOM overlay | FPS、レンダリング統計情報 |
| 情報パネル | HTML div | サンプル説明、エフェクト名、クレジット |

## イベント仕様

### 1-EffectComposer 初期化

EffectComposer を初期化し、レンダリングパスを設定する：
1. EffectComposer インスタンス作成（renderer を渡す）
2. RenderPass を追加（シーンとカメラのレンダリング）
3. エフェクトパスを追加（UnrealBloomPass, DOFPass等）
4. OutputPass を追加（最終出力）

### 2-レンダリングループ

毎フレームの処理：
1. timer.update() で経過時間取得
2. mixer.update() でアニメーション更新
3. stats.update() で統計情報更新
4. composer.render() で後処理パイプライン実行

### 3-パラメータ変更

GUI でパラメータが変更された場合：
1. エフェクトパスのプロパティを直接更新
2. 次のフレームで新しいパラメータが反映

### 4-ウィンドウリサイズ

window.resize イベントで以下を実行：
1. camera.aspect を新しいアスペクト比に設定
2. camera.updateProjectionMatrix() を呼び出し
3. renderer.setSize() で新しいサイズを設定
4. composer.setSize() で RenderTarget サイズを更新

## データベース更新仕様

### 操作別データベース影響一覧

本画面はフロントエンドのみで動作するサンプルであり、データベースへのアクセスは行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|-----------|----------|
| 警告 | コンソール警告 | RenderTarget サイズ不正時 |
| 情報 | GUI ラベル | 各パラメータの現在値表示 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| WebGL2非対応ブラウザ | 一部エフェクトが動作しない可能性、代替処理 |
| GPU メモリ不足 | RenderTarget 作成失敗、エラーログ出力 |
| シェーダーコンパイルエラー | コンソールにエラー出力 |

## 備考

- EffectComposer はパスを連鎖させて複数のエフェクトを組み合わせ可能
- 各パスは WebGLRenderTarget を内部で使用
- パフォーマンスはエフェクトの数と複雑さに依存
- モバイルデバイスでは高負荷エフェクトに注意

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ポストプロセッシングで使用される主要なクラスとその関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | EffectComposer.js | `examples/jsm/postprocessing/EffectComposer.js` | パスの管理と実行順序 |
| 1-2 | Pass.js | `examples/jsm/postprocessing/Pass.js` | パスの基底クラス |
| 1-3 | WebGLRenderTarget | `src/renderers/WebGLRenderTarget.js` | オフスクリーンレンダリング先 |

**読解のコツ**: EffectComposer は passes 配列を保持し、render() 時に順番に実行する。各パスは読み込み元・書き込み先の RenderTarget を持つ。

#### Step 2: エントリーポイントを理解する

Unreal Bloom サンプルを例に、ポストプロセッシングの初期化と実行フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | webgl_postprocessing_unreal_bloom.html | `examples/webgl_postprocessing_unreal_bloom.html` | Bloom効果の実装例 |

**主要処理フロー**:
1. **Line 45-48**: EffectComposer, RenderPass, UnrealBloomPass, OutputPass のインポート
2. **Line 53-58**: パラメータオブジェクトの定義（threshold, strength, radius, exposure）
3. **Line 92-97**: WebGLRenderer の初期化と toneMapping 設定
4. **Line 101-113**: EffectComposer の初期化とパスの追加
5. **Line 129-157**: GUI でパラメータ変更時にパスのプロパティを更新
6. **Line 176-188**: animate() で composer.render() を呼び出し

#### Step 3: RenderPass を理解する

シーンをオフスクリーンにレンダリングする基本パスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RenderPass.js | `examples/jsm/postprocessing/RenderPass.js` | シーンレンダリングパス |

**主要処理フロー**:
- **render()**: renderer.render(scene, camera, writeBuffer) を実行
- シーン全体をテクスチャに描画

#### Step 4: UnrealBloomPass を理解する

Bloom（グロー）効果の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | UnrealBloomPass.js | `examples/jsm/postprocessing/UnrealBloomPass.js` | Bloom効果のシェーダー処理 |

**主要処理フロー**:
- **threshold**: 明るい部分の閾値
- **strength**: Bloom の強度
- **radius**: ぼかしの半径
- 多段階のダウンサンプリングとガウスブラーを適用

#### Step 5: OutputPass を理解する

最終出力でのトーンマッピングとガンマ補正を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | OutputPass.js | `examples/jsm/postprocessing/OutputPass.js` | 最終出力パス |

**主要処理フロー**:
- トーンマッピング（HDR→SDR変換）
- ガンマ補正（リニア→sRGB変換）

### プログラム呼び出し階層図

```
webgl_postprocessing_unreal_bloom.html (エントリーポイント)
    |
    +-- THREE.WebGLRenderer
    |      +-- setPixelRatio()
    |      +-- setSize()
    |      +-- setAnimationLoop()
    |      +-- toneMapping = ACESFilmicToneMapping
    |
    +-- EffectComposer(renderer)
    |      |
    |      +-- addPass(RenderPass)
    |      |      +-- render(scene, camera, writeBuffer)
    |      |
    |      +-- addPass(UnrealBloomPass)
    |      |      +-- threshold
    |      |      +-- strength
    |      |      +-- radius
    |      |      +-- render(readBuffer, writeBuffer)
    |      |
    |      +-- addPass(OutputPass)
    |      |      +-- render(readBuffer, writeBuffer)
    |      |
    |      +-- render() [全パスを順次実行]
    |
    +-- GUI
    |      +-- add(params, 'threshold').onChange()
    |      +-- add(params, 'strength').onChange()
    |      +-- add(params, 'radius').onChange()
    |
    +-- animate()
           +-- timer.update()
           +-- mixer.update()
           +-- stats.update()
           +-- composer.render()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Scene + Camera ────────> RenderPass ─────────────────> RenderTarget A
                              |
                              v
RenderTarget A ────────> UnrealBloomPass ────────────> RenderTarget B
                         (threshold/strength/radius)
                              |
                              v
RenderTarget B ────────> OutputPass ─────────────────> Screen (Canvas)
                         (toneMapping/gamma)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EffectComposer.js | `examples/jsm/postprocessing/EffectComposer.js` | ソース | パス管理・実行 |
| RenderPass.js | `examples/jsm/postprocessing/RenderPass.js` | ソース | シーンレンダリング |
| UnrealBloomPass.js | `examples/jsm/postprocessing/UnrealBloomPass.js` | ソース | Bloom効果 |
| BokehPass.js | `examples/jsm/postprocessing/BokehPass.js` | ソース | 被写界深度 |
| SSAOPass.js | `examples/jsm/postprocessing/SSAOPass.js` | ソース | 環境遮蔽 |
| FXAAShader.js | `examples/jsm/shaders/FXAAShader.js` | ソース | FXAAシェーダー |
| OutputPass.js | `examples/jsm/postprocessing/OutputPass.js` | ソース | 最終出力 |
| ShaderPass.js | `examples/jsm/postprocessing/ShaderPass.js` | ソース | 汎用シェーダーパス |
| CopyShader.js | `examples/jsm/shaders/CopyShader.js` | ソース | テクスチャコピー |
| webgl_postprocessing_*.html | `examples/webgl_postprocessing_*.html` | テンプレート | 各種ポストプロセシングサンプル (約26件) |
