# 画面設計書 23-WebGL上級サンプル

## 概要

本ドキュメントは、three.js Examples における WebGL 上級者向けサンプル群（約47件）の画面設計書である。BufferGeometry の直接操作、GPGPU（汎用GPUコンピューティング）、シャドウマップ、カスタムシェーダーなど、高度な WebGL 技術のデモンストレーションを提供する。

### 本画面の処理概要

WebGL上級サンプル画面は、three.js の低レベル API を直接活用した高度な実装例を提供する。BufferGeometry のカスタム頂点属性、インスタンシング、GPGPU によるシミュレーション、高度なシャドウマップ技術などを実装したサンプルが含まれる。

**業務上の目的・背景**：three.js の基本機能を超えた高度なカスタマイズや最適化が必要な開発者に対して、低レベル API の使用方法を提供する。大規模なパーティクルシステム、流体シミュレーション、高精度なシャドウ表現など、パフォーマンスと品質を両立させるための技術を学習できる。ゲームエンジン開発者やシミュレーション開発者向けのリファレンス実装として活用される。

**画面へのアクセス方法**：
1. examples/index.html にアクセス
2. 左側パネルの「webgl / advanced」カテゴリを選択
3. 検索フィルタで「buffergeometry」「gpgpu」「shadowmap」等を入力して絞り込み
4. 目的のサンプルを選択

**主要な操作・処理内容**：
1. BufferGeometry のカスタム属性設定（position, color, uv, normal, custom attributes）
2. BufferAttribute の直接更新（needsUpdate フラグ）
3. InstancedMesh によるインスタンシング描画
4. WebGLRenderTarget を使用した GPGPU シミュレーション
5. CSM（Cascaded Shadow Maps）による高品質シャドウ
6. PCSS（Percentage Closer Soft Shadows）によるソフトシャドウ

**画面遷移**：
- 遷移元：Examples一覧画面（examples/index.html）
- 遷移先：なし（各サンプルは独立して動作）
- GitHub ソースコードページへの外部リンクあり

**権限による表示制御**：なし（パブリックアクセス）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | BufferGeometry | 主機能 | カスタムジオメトリの構築 |
| 3 | BufferAttribute | 補助機能 | 頂点属性データの管理 |
| 76 | InstancedMesh | 補助機能 | インスタンス描画 |
| 13 | WebGLRenderer | 補助機能 | レンダリング処理 |
| 15 | WebGLRenderTarget | 補助機能 | GPGPU 用オフスクリーンレンダリング |

## 画面種別

サンプル / デモンストレーション

## URL/ルーティング

- カテゴリ: `examples/index.html` (webgl / advanced)
- 個別サンプル:
  - `examples/webgl_buffergeometry.html` - 基本的な BufferGeometry
  - `examples/webgl_buffergeometry_instancing.html` - インスタンシング
  - `examples/webgl_gpgpu_birds.html` - GPGPU 群衆シミュレーション
  - `examples/webgl_gpgpu_water.html` - GPGPU 水面シミュレーション
  - `examples/webgl_shadowmap_csm.html` - カスケードシャドウマップ
  - `examples/webgl_shadowmap_pcss.html` - ソフトシャドウ
  - 他約41件

## 入出力項目

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| 頂点位置配列 | 入力 | Float32Array | 頂点座標データ |
| 頂点カラー配列 | 入力 | Float32Array | 頂点カラーデータ |
| カスタム属性配列 | 入力 | Float32Array/Uint8Array等 | カスタムシェーダー用属性 |
| インスタンス行列 | 入力 | Matrix4[] | インスタンス変換行列 |
| GPGPU テクスチャ | 入出力 | DataTexture | シミュレーションデータ |
| レンダリング結果 | 出力 | Canvas | WebGL描画結果 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 3Dシーン | Canvas | 高度な技術を使用したレンダリング結果 |
| Stats | DOM overlay | FPS、頂点数、描画コール数等 |
| GUI パネル | DOM overlay | パラメータ調整用のコントロール |

## イベント仕様

### 1-BufferGeometry 頂点更新

頂点データを動的に更新する場合：
1. BufferAttribute の array プロパティを直接更新
2. needsUpdate = true を設定
3. 次のフレームで GPU にデータ転送

### 2-インスタンシング更新

InstancedMesh のインスタンス変換を更新する場合：
1. setMatrixAt(index, matrix) で個別の変換行列を設定
2. instanceMatrix.needsUpdate = true を設定
3. setColorAt(index, color) でインスタンスカラーを設定（オプション）

### 3-GPGPU シミュレーション

GPGPU によるシミュレーションのフレーム更新：
1. 現在の状態テクスチャを読み込み
2. シミュレーションシェーダーで新しい状態を計算
3. 結果を別の RenderTarget に出力
4. テクスチャをスワップ（ピンポンバッファリング）

### 4-CSM シャドウ更新

カメラ移動時のシャドウマップ更新：
1. カメラ frustum を複数のカスケードに分割
2. 各カスケードごとに光源からシャドウマップをレンダリング
3. フラグメントシェーダーで適切なカスケードを選択

## データベース更新仕様

### 操作別データベース影響一覧

本画面はフロントエンドのみで動作するサンプルであり、データベースへのアクセスは行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|-----------|----------|
| 警告 | コンソール警告 | 頂点数超過、テクスチャサイズ制限 |
| エラー | シェーダーコンパイルエラー | カスタムシェーダーの構文エラー |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| WebGL2非対応 | 一部サンプルが動作しない可能性、警告表示 |
| テクスチャサイズ制限超過 | サイズを制限内に縮小 |
| GPUメモリ不足 | オブジェクト数を削減、エラーログ出力 |

## 備考

- GPGPU サンプルは WebGL2 または OES_texture_float 拡張が必要
- CSM は広大なシーンでの高品質シャドウに有効
- BufferGeometry の直接操作はパフォーマンス最適化に重要
- インスタンシングは大量の同一オブジェクト描画に有効

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BufferGeometry と BufferAttribute のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BufferGeometry.js | `src/core/BufferGeometry.js` | 頂点属性の管理方法 |
| 1-2 | BufferAttribute.js | `src/core/BufferAttribute.js` | TypedArray によるデータ格納 |
| 1-3 | InstancedBufferAttribute.js | `src/core/InstancedBufferAttribute.js` | インスタンシング用属性 |

**読解のコツ**: BufferGeometry は attributes オブジェクトに BufferAttribute を格納する。各 BufferAttribute は TypedArray（Float32Array等）とアイテムサイズを持つ。

#### Step 2: エントリーポイントを理解する

代表的な上級サンプルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | webgl_buffergeometry.html | `examples/webgl_buffergeometry.html` | カスタム BufferGeometry 構築 |

**主要処理フロー**:
1. Float32Array で頂点位置・色を生成
2. BufferGeometry に setAttribute() で属性を設定
3. computeBoundingSphere() でバウンディング球を計算

#### Step 3: インスタンシングを理解する

InstancedMesh による効率的な大量オブジェクト描画を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | webgl_buffergeometry_instancing.html | `examples/webgl_buffergeometry_instancing.html` | インスタンシングの実装 |
| 3-2 | InstancedMesh.js | `src/objects/InstancedMesh.js` | インスタンシングの内部実装 |

**主要処理フロー**:
- InstancedMesh(geometry, material, count) でインスタンス数を指定
- setMatrixAt(i, matrix) で各インスタンスの変換を設定
- instanceMatrix.needsUpdate = true で GPU に転送

#### Step 4: GPGPU を理解する

WebGLRenderTarget を使用したGPUコンピューティングを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | webgl_gpgpu_birds.html | `examples/webgl_gpgpu_birds.html` | 群衆シミュレーション |
| 4-2 | GPUComputationRenderer.js | `examples/jsm/misc/GPUComputationRenderer.js` | GPGPU ヘルパークラス |

**主要処理フロー**:
- DataTexture に初期状態を格納
- フルスクリーンクワッドでシミュレーションシェーダーを実行
- 結果を RenderTarget に出力
- テクスチャをスワップして次のフレームへ

#### Step 5: CSM シャドウを理解する

カスケードシャドウマップの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | webgl_shadowmap_csm.html | `examples/webgl_shadowmap_csm.html` | CSM の使用例 |
| 5-2 | CSM.js | `examples/jsm/csm/CSM.js` | CSM の実装 |

**主要処理フロー**:
- カメラ frustum を距離に応じて分割
- 各カスケードで別々のシャドウマップを生成
- フラグメントシェーダーで適切なカスケードを選択

### プログラム呼び出し階層図

```
webgl_buffergeometry_instancing.html (エントリーポイント)
    |
    +-- THREE.BufferGeometry
    |      +-- setAttribute('position', BufferAttribute)
    |      +-- setAttribute('color', BufferAttribute)
    |
    +-- THREE.InstancedMesh(geometry, material, count)
    |      +-- setMatrixAt(index, matrix)
    |      +-- setColorAt(index, color)
    |      +-- instanceMatrix.needsUpdate = true
    |
    +-- THREE.WebGLRenderer
           +-- render(scene, camera)
               +-- GPU インスタンシング描画


webgl_gpgpu_birds.html (GPGPU サンプル)
    |
    +-- GPUComputationRenderer
    |      +-- createTexture()
    |      +-- addVariable()
    |      +-- setVariableDependencies()
    |      +-- init()
    |      +-- compute()
    |
    +-- ポジションテクスチャ
    |      +-- 各ピクセル = 1つの個体の位置
    |
    +-- ベロシティテクスチャ
           +-- 各ピクセル = 1つの個体の速度
```

### データフロー図

```
[BufferGeometry のデータフロー]

Float32Array ────────> BufferAttribute ────────> GPU Buffer
(CPU メモリ)              |                      (VRAM)
                    needsUpdate=true
                          |
                          v
                    次フレームで転送


[GPGPU のデータフロー]

Position Texture A ──────> Simulation Shader ──────> Position Texture B
                               |
Velocity Texture A ──────────┘     ┌─────────────> Velocity Texture B
                                   |
                         次フレームでスワップ
                                   |
                    A <────────────┘ B
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| BufferGeometry.js | `src/core/BufferGeometry.js` | ソース | 頂点データ管理 |
| BufferAttribute.js | `src/core/BufferAttribute.js` | ソース | 頂点属性データ |
| InstancedMesh.js | `src/objects/InstancedMesh.js` | ソース | インスタンシング描画 |
| InstancedBufferAttribute.js | `src/core/InstancedBufferAttribute.js` | ソース | インスタンス属性 |
| GPUComputationRenderer.js | `examples/jsm/misc/GPUComputationRenderer.js` | ソース | GPGPU ヘルパー |
| CSM.js | `examples/jsm/csm/CSM.js` | ソース | カスケードシャドウマップ |
| webgl_buffergeometry_*.html | `examples/webgl_buffergeometry_*.html` | テンプレート | BufferGeometry サンプル |
| webgl_gpgpu_*.html | `examples/webgl_gpgpu_*.html` | テンプレート | GPGPU サンプル |
| webgl_shadowmap_*.html | `examples/webgl_shadowmap_*.html` | テンプレート | シャドウマップサンプル |
