# 画面設計書 24-WebGPUサンプル

## 概要

本ドキュメントは、three.js Examples における WebGPU API を使用したサンプル群（約194件）の画面設計書である。次世代グラフィックス API である WebGPU を活用した 3D レンダリングと TSL（Three.js Shading Language）によるノードベースシェーダーのデモンストレーションを提供する。

### 本画面の処理概要

WebGPUサンプル画面は、WebGPU API を使用した最新の3Dレンダリング技術のサンプル集である。WebGPURenderer を使用し、Compute Shader によるGPGPU、TSL によるノードベースシェーダー、高度なレンダリング技術を実装している。WebGPU は WebGL の後継として設計された低レベルグラフィックス API であり、より効率的なGPUリソース管理とコンピュートシェーダーのネイティブサポートを提供する。

**業務上の目的・背景**：WebGPU は次世代の Web グラフィックス標準として策定されており、WebGL より優れたパフォーマンスと機能を提供する。three.js の WebGPU 対応を学習し、将来的な移行に備えることができる。TSL（Three.js Shading Language）はノードベースのシェーダー記述を可能にし、より直感的なシェーダー開発を実現する。研究開発やプロトタイピングにおいて最新技術を試すことができる。

**画面へのアクセス方法**：
1. examples/index.html にアクセス
2. 左側パネルの「webgpu (wip)」カテゴリを選択
3. 検索フィルタで「webgpu」「tsl」「compute」等を入力して絞り込み
4. 目的のサンプルを選択

**主要な操作・処理内容**：
1. WebGPURenderer によるシーンレンダリング
2. TSL（Three.js Shading Language）によるノードベースシェーダー
3. Compute Shader によるGPGPU処理（パーティクル、流体等）
4. Storage Buffer によるGPUデータ管理
5. マルチレンダーターゲット（MRT）
6. GUI によるパラメータ調整

**画面遷移**：
- 遷移元：Examples一覧画面（examples/index.html）
- 遷移先：なし（各サンプルは独立して動作）
- GitHub ソースコードページへの外部リンクあり

**権限による表示制御**：なし（パブリックアクセス）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | WebGPURenderer | 主機能 | WebGPU APIを使用したレンダリング処理 |
| 174 | TSL | 補助機能 | ノードベースシェーダー |
| 175 | NodeManager | 補助機能 | ノードシステムの管理 |
| 19 | PerspectiveCamera | 補助機能 | カメラ設定 |
| 110 | AnimationMixer | 補助機能 | アニメーション再生 |

## 画面種別

サンプル / デモンストレーション

## URL/ルーティング

- カテゴリ: `examples/index.html` (webgpu (wip))
- 個別サンプル:
  - `examples/webgpu_camera.html` - カメラ設定
  - `examples/webgpu_compute_particles.html` - コンピュートパーティクル
  - `examples/webgpu_tsl_earth.html` - TSL 地球表現
  - `examples/webgpu_tsl_galaxy.html` - TSL 銀河表現
  - `examples/webgpu_materials.html` - マテリアル
  - 他約189件

## 入出力項目

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| TSL ノード定義 | 入力 | Node | シェーダーノードの構成 |
| Storage Buffer | 入出力 | GPUBuffer | コンピュートシェーダー用データ |
| GUI パラメータ | 入力 | Number/Boolean/Color | リアルタイムパラメータ調整 |
| レンダリング結果 | 出力 | Canvas | WebGPU描画結果 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 3Dシーン | Canvas | WebGPURenderer による3Dレンダリング結果 |
| Stats | DOM overlay | FPS、GPU使用率等 |
| GUI パネル | DOM overlay | パラメータ調整用のコントロール |
| 情報パネル | HTML div | サンプル説明、操作ガイド |

## イベント仕様

### 1-WebGPURenderer 初期化

WebGPURenderer の初期化と設定：
1. new THREE.WebGPURenderer() でインスタンス作成
2. setPixelRatio() でデバイスピクセル比設定
3. setSize() でキャンバスサイズ設定
4. setAnimationLoop() でレンダリングループ登録

### 2-TSL シェーダー定義

TSL によるノードベースシェーダーの定義：
1. three/tsl からノード関数をインポート
2. ノードを組み合わせてシェーダーを構築
3. MeshBasicNodeMaterial 等のノードマテリアルに適用

### 3-コンピュートシェーダー実行

Compute Shader の実行フロー：
1. Storage Buffer でデータを定義
2. コンピュートシェーダーを定義
3. renderer.compute() でシェーダー実行
4. 結果を描画に使用

### 4-レンダリングループ

毎フレームの処理：
1. コントロール更新
2. コンピュートシェーダー実行（必要な場合）
3. renderer.render(scene, camera) で描画

## データベース更新仕様

### 操作別データベース影響一覧

本画面はフロントエンドのみで動作するサンプルであり、データベースへのアクセスは行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|-----------|----------|
| エラー | WebGPU not supported | ブラウザがWebGPU非対応 |
| 警告 | コンソール警告 | 機能制限がある場合 |
| 情報 | Stats パネル | パフォーマンス情報表示 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| WebGPU非対応ブラウザ | エラーメッセージ表示、WebGL へのフォールバック案内 |
| GPU初期化失敗 | エラーログ出力、リトライガイダンス |
| シェーダーコンパイルエラー | エラー詳細をコンソールに出力 |

## 備考

- WebGPU は現在 Work In Progress (WIP) 状態
- Chrome 113+、Firefox Nightly、Safari 17+ でサポート
- TSL は three.js 独自のノードベースシェーダー言語
- Import Map で `three/webgpu` と `three/tsl` を別途指定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

WebGPU と TSL の基本構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | three.webgpu.js | `build/three.webgpu.js` | WebGPU 用のエントリーポイント |
| 1-2 | three.tsl.js | `build/three.tsl.js` | TSL ノード関数群 |
| 1-3 | WebGPURenderer.js | `src/renderers/webgpu/WebGPURenderer.js` | WebGPU レンダラー実装 |

**読解のコツ**: WebGPU サンプルでは Import Map で `three/webgpu` を指定し、TSL を使用する場合は `three/tsl` も追加する。

#### Step 2: エントリーポイントを理解する

代表的な WebGPU サンプルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | webgpu_camera.html | `examples/webgpu_camera.html` | 基本的な WebGPU サンプル構造 |

**主要処理フロー**:
1. **Line 21-30**: Import Map で three/webgpu を設定
2. **Line 34**: `import * as THREE from 'three/webgpu'`
3. **Line 132**: `new THREE.WebGPURenderer({ antialias: true })`
4. **Line 135**: `renderer.setAnimationLoop(animate)`
5. **Line 248**: `renderer.render(scene, camera)` または `renderer.render(scene, activeCamera)`

#### Step 3: TSL を理解する

TSL によるノードベースシェーダーの記述方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | webgpu_tsl_earth.html | `examples/webgpu_tsl_earth.html` | TSL による地球表現 |

**主要処理フロー**:
- `import { ... } from 'three/tsl'` で TSL ノード関数をインポート
- ノードを組み合わせてシェーダーを構築
- `MeshBasicNodeMaterial` 等にノードを設定

#### Step 4: コンピュートシェーダーを理解する

Compute Shader による GPGPU 処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | webgpu_compute_particles.html | `examples/webgpu_compute_particles.html` | コンピュートパーティクル |

**主要処理フロー**:
- Storage Buffer でパーティクルデータを定義
- コンピュートシェーダーで位置・速度を更新
- `renderer.compute()` でシェーダー実行
- 結果をポイントクラウドとして描画

#### Step 5: WebGPURenderer の詳細を理解する

WebGPURenderer の内部動作を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | WebGPURenderer.js | `src/renderers/webgpu/WebGPURenderer.js` | レンダラー本体 |
| 5-2 | WebGPUBackend.js | `src/renderers/webgpu/WebGPUBackend.js` | GPU バックエンド |

**主要処理フロー**:
- GPU デバイスの取得と初期化
- パイプラインの作成とキャッシュ
- 描画コマンドの発行

### プログラム呼び出し階層図

```
webgpu_camera.html (エントリーポイント)
    |
    +-- Import Map
    |      +-- "three": "../build/three.webgpu.js"
    |      +-- "three/webgpu": "../build/three.webgpu.js"
    |      +-- "three/tsl": "../build/three.tsl.js"
    |
    +-- THREE.WebGPURenderer
    |      +-- setPixelRatio()
    |      +-- setSize()
    |      +-- setAnimationLoop()
    |      +-- setScissorTest()
    |      +-- setClearColor()
    |      +-- render(scene, camera)
    |      +-- compute() [コンピュートシェーダー用]
    |
    +-- THREE.Scene
    |      +-- add()
    |
    +-- THREE.PerspectiveCamera / OrthographicCamera
    |      +-- updateProjectionMatrix()
    |
    +-- animate()
           +-- render()
               +-- renderer.render(scene, camera)
```

### データフロー図

```
[TSL シェーダーのデータフロー]

TSL ノード定義 ──────> ノードグラフ構築 ──────> WGSL シェーダー生成
                                                    |
                                                    v
マテリアル ─────────────────────────────────> GPU パイプライン
                                                    |
                                                    v
                                               レンダリング


[コンピュートシェーダーのデータフロー]

Storage Buffer ────────> Compute Shader ────────> Storage Buffer (更新)
(パーティクル位置)              |                   |
                              v                   v
                    renderer.compute()    ポイントクラウド描画
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| three.webgpu.js | `build/three.webgpu.js` | ソース | WebGPU 用 three.js ビルド |
| three.tsl.js | `build/three.tsl.js` | ソース | TSL ノード関数群 |
| WebGPURenderer.js | `src/renderers/webgpu/WebGPURenderer.js` | ソース | WebGPU レンダラー |
| WebGPUBackend.js | `src/renderers/webgpu/WebGPUBackend.js` | ソース | GPU バックエンド |
| example.css | `examples/example.css` | スタイル | WebGPU サンプル用スタイル |
| webgpu_*.html | `examples/webgpu_*.html` | テンプレート | 各種 WebGPU サンプル (約194件) |
| webgpu_tsl_*.html | `examples/webgpu_tsl_*.html` | テンプレート | TSL サンプル |
| webgpu_compute_*.html | `examples/webgpu_compute_*.html` | テンプレート | コンピュートシェーダーサンプル |
