# 画面設計書 28-CSS3Dサンプル

## 概要

本ドキュメントは、three.js Examples における CSS3D レンダラーを使用したサンプル群（7件）の画面設計書である。DOM 要素を 3D 空間に配置する CSS3DRenderer のデモンストレーションを提供する。

### 本画面の処理概要

CSS3Dサンプル画面は、three.js の CSS3DRenderer を使用して HTML DOM 要素を 3D 空間に配置するサンプル集である。WebGL を使用せず、CSS の 3D Transform（perspective, rotateX, rotateY, translateZ 等）を活用して DOM 要素の 3D 表示を実現する。テキスト、画像、YouTube 動画などの DOM 要素を 3D シーン内に配置できる。

**業務上の目的・背景**：テキストやフォーム、動画などの DOM コンテンツを 3D 空間に配置したい場合に、WebGL のテクスチャとして描画するよりも高品質で、インタラクティブ性を維持できる。元素周期表のような情報可視化、3D ギャラリー、プレゼンテーションなどに活用できる。WebGL と組み合わせて使用することも可能（css3d_mixed）。

**画面へのアクセス方法**：
1. examples/index.html にアクセス
2. 左側パネルの「css3d」カテゴリを選択
3. 検索フィルタで「css3d」を入力して絞り込み
4. 目的のサンプルを選択

**主要な操作・処理内容**：
1. CSS3DRenderer の初期化と DOM への追加
2. CSS3DObject による DOM 要素の 3D 配置
3. TrackballControls または OrbitControls によるカメラ操作
4. TWEEN.js によるアニメーション遷移
5. レイアウト切り替え（テーブル、球、ヘリックス、グリッド等）

**画面遷移**：
- 遷移元：Examples一覧画面（examples/index.html）
- 遷移先：なし（各サンプルは独立して動作）
- GitHub ソースコードページへの外部リンクあり

**権限による表示制御**：なし（パブリックアクセス）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Object3D | 主機能 | CSS3D要素の3D配置 |
| 19 | PerspectiveCamera | 補助機能 | カメラ設定 |
| 24 | Scene | 補助機能 | シーングラフ管理 |
| 169 | Controls | 補助機能 | カメラ操作 |

## 画面種別

サンプル / デモンストレーション

## URL/ルーティング

- カテゴリ: `examples/index.html` (css3d)
- 個別サンプル:
  - `examples/css3d_periodictable.html` - 元素周期表
  - `examples/css3d_molecules.html` - 分子構造表示
  - `examples/css3d_sprites.html` - 3D スプライト
  - `examples/css3d_youtube.html` - YouTube 動画
  - `examples/css3d_sandbox.html` - サンドボックス
  - `examples/css3d_orthographic.html` - 正射影
  - `examples/css3d_mixed.html` - WebGL と混合

## 入出力項目

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| DOM 要素 | 入力 | HTMLElement | 3D 空間に配置する要素 |
| レイアウトボタン | 入力 | Event (click) | レイアウト切り替えトリガー |
| マウス操作 | 入力 | Event (mouse/touch) | カメラ操作 |
| CSS3D 変換 | 出力 | CSS transform | 3D 変換スタイル |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 3D 配置された DOM | HTML/CSS | CSS3DRenderer による 3D 表示 |
| コントロールボタン | HTML button | レイアウト切り替え用のUI |
| 情報パネル | HTML div | サンプル説明 |

## イベント仕様

### 1-CSS3DRenderer 初期化

レンダラーの初期化と DOM への追加：
1. new CSS3DRenderer() でインスタンス作成
2. renderer.setSize() でサイズ設定
3. document.body.appendChild(renderer.domElement) で DOM に追加
4. renderer.domElement は CSS スタイルで position: absolute, top: 0px

### 2-CSS3DObject 作成

DOM 要素を 3D オブジェクトとして作成：
1. DOM 要素（div, iframe 等）を作成
2. new CSS3DObject(element) でラップ
3. object.position.set(x, y, z) で位置設定
4. object.rotation.set(rx, ry, rz) で回転設定
5. scene.add(object) でシーンに追加

### 3-レイアウト切り替え

ボタンクリックでレイアウトを変更：
1. ボタンに addEventListener('click', callback) を設定
2. transform(targets, duration) 関数を呼び出し
3. TWEEN.js で各オブジェクトの position と rotation をアニメーション
4. アニメーション中は TWEEN.update() を呼び出し

### 4-レンダリングループ

毎フレームの処理：
1. requestAnimationFrame(animate) でループ
2. TWEEN.update() でアニメーション更新
3. controls.update() でカメラ更新
4. renderer.render(scene, camera) で CSS3D レンダリング

## データベース更新仕様

### 操作別データベース影響一覧

本画面はフロントエンドのみで動作するサンプルであり、データベースへのアクセスは行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|-----------|----------|
| なし | - | CSS3DRenderer は特にメッセージを出力しない |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| CSS3D Transform 非対応 | 古いブラウザでは 3D 変換が適用されない |
| 大量の DOM 要素 | パフォーマンス低下、要素数を制限 |

## 備考

- CSS3DRenderer は WebGL を使用しないため、GPU 負荷が低い
- DOM 要素のインタラクティブ性（クリック、入力等）が維持される
- css3d_mixed サンプルでは WebGLRenderer と CSS3DRenderer を重ねて使用
- YouTube 動画なども iframe として 3D 配置可能
- TWEEN.js でスムーズなアニメーション遷移を実現

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CSS3DRenderer と CSS3DObject の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CSS3DRenderer.js | `examples/jsm/renderers/CSS3DRenderer.js` | CSS3D レンダリングの実装 |

**読解のコツ**: CSS3DRenderer は各 CSS3DObject の position/rotation を CSS transform: matrix3d() に変換して適用する。WebGL のようにピクセル描画するのではなく、DOM 要素に CSS スタイルを設定する。

#### Step 2: エントリーポイントを理解する

元素周期表サンプルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | css3d_periodictable.html | `examples/css3d_periodictable.html` | 代表的な CSS3D サンプル |

**主要処理フロー**:
1. **Line 107-109**: TWEEN, TrackballControls, CSS3DRenderer のインポート
2. **Line 111-229**: table 配列に元素データを定義
3. **Line 241-246**: PerspectiveCamera の作成
4. **Line 248**: Scene の作成
5. **Line 250-287**: 各元素の DOM 要素と CSS3DObject を作成
6. **Line 289-343**: 各レイアウト（table, sphere, helix, grid）の目標位置を計算
7. **Line 347-349**: CSS3DRenderer を作成して DOM に追加
8. **Line 353-356**: TrackballControls を設定
9. **Line 358-384**: ボタンのイベントハンドラを設定
10. **Line 394-420**: transform() 関数で TWEEN アニメーション
11. **Line 433-447**: animate() と render() 関数

#### Step 3: CSS3DObject を理解する

DOM 要素の 3D 配置方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CSS3DRenderer.js | `examples/jsm/renderers/CSS3DRenderer.js` | CSS3DObject クラス |

**主要処理フロー**:
- CSS3DObject は Object3D を継承
- element プロパティに DOM 要素を保持
- render() 時に element.style.transform を更新

#### Step 4: TWEEN アニメーションを理解する

レイアウト遷移のアニメーションを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | tween.module.js | `examples/jsm/libs/tween.module.js` | TWEEN ライブラリ |

**主要処理フロー**:
- new TWEEN.Tween(object.position).to({ x, y, z }, duration)
- .easing(TWEEN.Easing.Exponential.InOut)
- .start()
- animate ループで TWEEN.update() を呼び出し

### プログラム呼び出し階層図

```
css3d_periodictable.html (エントリーポイント)
    |
    +-- init()
    |      |
    |      +-- THREE.PerspectiveCamera()
    |      +-- THREE.Scene()
    |      |
    |      +-- [各元素について]
    |      |      +-- document.createElement('div')
    |      |      +-- new CSS3DObject(element)
    |      |      +-- scene.add(objectCSS)
    |      |      +-- objects.push(objectCSS)
    |      |
    |      +-- [目標位置の計算]
    |      |      +-- targets.table[] - 表形式
    |      |      +-- targets.sphere[] - 球形式
    |      |      +-- targets.helix[] - ヘリックス形式
    |      |      +-- targets.grid[] - グリッド形式
    |      |
    |      +-- CSS3DRenderer()
    |      |      +-- setSize()
    |      |      +-- document.body.appendChild()
    |      |
    |      +-- TrackballControls(camera, renderer.domElement)
    |      |      +-- addEventListener('change', render)
    |      |
    |      +-- button.addEventListener('click', () => transform())
    |
    +-- transform(targets, duration)
    |      +-- TWEEN.removeAll()
    |      +-- [各オブジェクトについて]
    |             +-- new TWEEN.Tween(object.position).to().start()
    |             +-- new TWEEN.Tween(object.rotation).to().start()
    |
    +-- animate()
    |      +-- requestAnimationFrame(animate)
    |      +-- TWEEN.update()
    |      +-- controls.update()
    |
    +-- render()
           +-- renderer.render(scene, camera)
```

### データフロー図

```
[CSS3D レンダリングのデータフロー]

DOM 要素 ────────> CSS3DObject ────────> Scene
(div, iframe等)        |                   |
                      |                   v
               position/rotation    scene.traverse()
                      |                   |
                      v                   v
              CSS3DRenderer.render()
                      |
                      v
              element.style.transform = matrix3d(...)
                      |
                      v
              ブラウザが CSS 3D Transform を適用
                      |
                      v
              画面表示


[レイアウト遷移のデータフロー]

ボタンクリック ──> transform(targets, duration)
                        |
                        v
                  TWEEN.Tween(position).to(target).start()
                        |
                        v
                  animate() で TWEEN.update()
                        |
                        v
                  object.position が徐々に変化
                        |
                        v
                  render() で CSS transform 更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CSS3DRenderer.js | `examples/jsm/renderers/CSS3DRenderer.js` | ソース | CSS3D レンダラー |
| tween.module.js | `examples/jsm/libs/tween.module.js` | ソース | TWEEN アニメーション |
| TrackballControls.js | `examples/jsm/controls/TrackballControls.js` | ソース | トラックボールコントロール |
| css3d_periodictable.html | `examples/css3d_periodictable.html` | テンプレート | 元素周期表 |
| css3d_molecules.html | `examples/css3d_molecules.html` | テンプレート | 分子構造 |
| css3d_sprites.html | `examples/css3d_sprites.html` | テンプレート | スプライト |
| css3d_youtube.html | `examples/css3d_youtube.html` | テンプレート | YouTube 動画 |
| css3d_sandbox.html | `examples/css3d_sandbox.html` | テンプレート | サンドボックス |
| css3d_orthographic.html | `examples/css3d_orthographic.html` | テンプレート | 正射影 |
| css3d_mixed.html | `examples/css3d_mixed.html` | テンプレート | WebGL 混合 |
