# 画面設計書 3-Sidebar - Scene

## 概要

three.js EditorのSidebar - Sceneパネルの設計書。本ドキュメントでは、シーン階層（Outliner）と背景、環境、霧の設定機能について詳細に記述する。

### 本画面の処理概要

Sidebar - Sceneパネルは、シーン全体の構造と環境設定を管理するための画面である。Outlinerによるシーン階層のツリー表示、背景（Background）設定、環境（Environment）設定、霧（Fog）設定を提供し、3Dシーンの基本的な見た目を制御する。

**業務上の目的・背景**：3Dシーンの編集において、オブジェクトの階層構造を把握し、シーン全体の環境設定（背景色、環境マップ、フォグ効果）を一元管理することは不可欠である。本パネルにより、ユーザーはシーンの構造を視覚的に確認しながら、グローバルな視覚効果を調整できる。

**画面へのアクセス方法**：Sidebarの「Scene」タブをクリックしてアクセス。エディタ起動時はデフォルトで表示される。

**主要な操作・処理内容**：
1. Outlinerでのオブジェクト選択・展開・折りたたみ
2. Outlinerでのドラッグ&ドロップによる親子関係変更
3. 背景タイプ（Default/Color/Texture/Equirectangular）の選択と設定
4. 環境タイプ（Default/Equirectangular/None）の選択と設定
5. 霧タイプ（None/Linear/Exponential）の選択とパラメータ設定

**画面遷移**：Outlinerでオブジェクトを選択すると、Sidebar - Object/Geometry/Material/Scriptパネルの内容が更新される。ダブルクリックでViewportがオブジェクトにフォーカスする。

**権限による表示制御**：権限による制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | Scene | 主機能 | シーングラフの階層構造表示と管理 |
| 25 | Fog | 補助機能 | リニアフォグ効果の設定 |
| 26 | FogExp2 | 補助機能 | 指数フォグ効果の設定 |
| 130 | Color | 補助機能 | 背景色の設定と管理 |
| 88 | Texture | 補助機能 | 背景テクスチャの設定 |

## 画面種別

設定パネル / ツリービュー

## URL/ルーティング

- DOM ID: `#outliner`（Outliner部分）
- URLルーティングなし（エディタ内コンポーネント）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 説明 |
|--------|----------|----------|------|
| 背景タイプ | 入力 | String | Default/Color/Texture/Equirectangular |
| 背景色 | 入力 | Hex Color | 背景色（#000000形式） |
| 背景テクスチャ | 入力 | Texture | テクスチャ画像 |
| 背景Equirectangular | 入力 | Texture | HDR環境マップ |
| 背景ぼかし | 入力 | Number | 0-1の範囲 |
| 背景強度 | 入力 | Number | 0-Infinityの範囲 |
| 背景回転 | 入力 | Number | -180〜180度 |
| 背景色空間 | 入力 | String | NoColorSpace/LinearSRGB/SRGB |
| 環境タイプ | 入力 | String | Default/Equirectangular/None |
| 環境Equirectangular | 入力 | Texture | 環境マップテクスチャ |
| 霧タイプ | 入力 | String | None/Fog/FogExp2 |
| 霧色 | 入力 | Hex Color | 霧の色 |
| 霧Near | 入力 | Number | 線形フォグの開始距離 |
| 霧Far | 入力 | Number | 線形フォグの終了距離 |
| 霧Density | 入力 | Number | 指数フォグの密度 |

## 表示項目

| 要素 | 表示内容 | 説明 |
|------|----------|------|
| Outliner | シーン階層ツリー | Camera、Scene、全オブジェクトの階層表示 |
| Background | 背景設定UI | タイプ選択、色/テクスチャ指定 |
| Environment | 環境設定UI | タイプ選択、環境マップ指定 |
| Fog | 霧設定UI | タイプ選択、パラメータ設定 |

## イベント仕様

### 1-Outliner オブジェクト選択

Outlinerでのオブジェクト選択処理。

1. Outliner項目をクリック（行134-142）
2. `outliner.getValue()`で選択されたオブジェクトIDを取得
3. `editor.selectById(parseInt(outliner.getValue()))`を呼び出し
4. `signals.objectSelected`が発火し、他のパネルが更新される

### 2-Outliner ダブルクリック（フォーカス）

Outlinerでのオブジェクトフォーカス処理。

1. Outliner項目をダブルクリック（行143-147）
2. `editor.focusById(parseInt(outliner.getValue()))`を呼び出し
3. `signals.objectFocused`が発火
4. Viewportがオブジェクトにカメラをフォーカス

### 3-Outliner ノード展開/折りたたみ

ツリーノードの展開/折りたたみ処理。

1. opener（▶/▼アイコン）をクリック（行41-46）
2. `nodeStates.set(object, !nodeStates.get(object))`で状態をトグル
3. `refreshUI()`で表示を更新

### 4-背景設定変更

背景の種類や値を変更した際の処理。

1. backgroundType、backgroundColor等のUI操作（行164-169, 174等）
2. `onBackgroundChanged()`が呼び出される（行218-230）
3. `signals.sceneBackgroundChanged.dispatch()`で変更を通知
4. Viewportで背景が更新される

### 5-環境設定変更

環境（環境マップ）を変更した際の処理。

1. environmentType、environmentEquirectangularTextureのUI操作（行267-272, 277等）
2. `onEnvironmentChanged()`が呼び出される（行283-289）
3. `signals.sceneEnvironmentChanged.dispatch()`で変更を通知
4. ViewportでPBRマテリアルの反射が更新される

### 6-霧設定変更

霧の種類やパラメータを変更した際の処理。

1. fogType、fogColor、fogNear、fogFar、fogDensityのUI操作（行328-340, 354-371）
2. `onFogChanged()`または`onFogSettingsChanged()`が呼び出される（行303-325）
3. `signals.sceneFogChanged`または`signals.sceneFogSettingsChanged`を発火
4. Viewportで霧効果が更新される

## データベース更新仕様

### 操作別データベース影響一覧

Sidebar - Scene単体でのデータベース操作はない。設定変更はシグナル経由でEditor状態に反映され、自動保存機能によりIndexedDBに永続化される。

## メッセージ仕様

メッセージ表示はない。

## 例外処理

| 状況 | 処理 |
|------|------|
| テクスチャ読み込み失敗 | UITexture内部でエラーハンドリング |

## 備考

- Outlinerはドラッグ&ドロップによる親子関係変更に対応（draggable属性）
- 背景のEquirectangularモードでは、ぼかし（Blurriness）、強度（Intensity）、回転（Rotation）の追加パラメータが利用可能
- 環境の「Default」モードでは、背景を自動的に環境マップとして使用（useBackgroundAsEnvironment）
- ノードの展開状態はWeakMapで管理され、オブジェクトごとに保持される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Sceneパネルで管理するデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Sidebar.Scene.js | `editor/js/Sidebar.Scene.js` | 行17のnodeStates（WeakMap）、行132のoutliner |
| 1-2 | Editor.js | `editor/js/Editor.js` | editor.scene、editor.camera、editor.backgroundType、editor.environmentType |

**読解のコツ**: WeakMapを使用したノード状態管理パターンを理解すると、ツリー表示の仕組みが把握しやすい。

#### Step 2: エントリーポイントを理解する

SidebarSceneの初期化を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Sidebar.js | `editor/js/Sidebar.js` | SidebarSceneの生成と追加 |
| 2-2 | Sidebar.Scene.js | `editor/js/Sidebar.Scene.js` | 行6のSidebarScene関数開始 |

**主要処理フロー**:
1. **行11-13**: UIPanel作成
2. **行17**: nodeStates（WeakMap）初期化
3. **行132-149**: Outliner初期化とイベント設定
4. **行153-216**: Background設定UI構築
5. **行257-299**: Environment設定UI構築
6. **行301-371**: Fog設定UI構築
7. **行375-485**: refreshUI関数定義
8. **行498-587**: シグナルハンドラ登録

#### Step 3: Outliner のツリー構築を理解する

ツリー表示のロジックを追跡。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Sidebar.Scene.js | `editor/js/Sidebar.Scene.js` | 行19-54のbuildOption関数 |
| 3-2 | Sidebar.Scene.js | `editor/js/Sidebar.Scene.js` | 行375-417のrefreshUI関数のaddObjects部分 |

**主要処理フロー**:
- **行19-54**: buildOption - 各オブジェクト用のDOM要素を生成
- **行100-117**: buildHTML - オブジェクト情報のHTML文字列生成
- **行385-409**: addObjects - 再帰的にツリーを構築

#### Step 4: シグナル連携を理解する

シグナルによるUI更新の流れを追跡。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Sidebar.Scene.js | `editor/js/Sidebar.Scene.js` | 行502-504のシグナルハンドラ |
| 4-2 | Viewport.js | `editor/js/Viewport.js` | sceneBackgroundChanged、sceneEnvironmentChanged、sceneFogChangedのハンドラ |

### プログラム呼び出し階層図

```
Sidebar.Scene.js
    │
    ├─ UIPanel (container)
    │
    ├─ UIOutliner (outliner)
    │      └─ buildOption()
    │             └─ buildHTML()
    │
    ├─ Background Settings
    │      ├─ UISelect (backgroundType)
    │      ├─ UIColor (backgroundColor)
    │      ├─ UITexture (backgroundTexture)
    │      ├─ UITexture (backgroundEquirectangularTexture)
    │      ├─ UISelect (backgroundColorSpace)
    │      ├─ UINumber (backgroundBlurriness)
    │      ├─ UINumber (backgroundIntensity)
    │      └─ UINumber (backgroundRotation)
    │
    ├─ Environment Settings
    │      ├─ UISelect (environmentType)
    │      └─ UITexture (environmentEquirectangularTexture)
    │
    └─ Fog Settings
           ├─ UISelect (fogType)
           ├─ UIColor (fogColor)
           ├─ UINumber (fogNear)
           ├─ UINumber (fogFar)
           └─ UINumber (fogDensity)
```

### データフロー図

```
[入力]               [処理]                    [出力]

Outliner選択 ──────▶ editor.selectById() ────▶ signals.objectSelected
                                                  │
                                                  ▼
                                            Sidebar更新

背景設定変更 ──────▶ onBackgroundChanged() ──▶ signals.sceneBackgroundChanged
                                                  │
                                                  ▼
                                            Viewport.js
                                                  │
                                                  ▼
                                            scene.background更新

環境設定変更 ──────▶ onEnvironmentChanged() ─▶ signals.sceneEnvironmentChanged
                                                  │
                                                  ▼
                                            scene.environment更新

霧設定変更 ────────▶ onFogChanged() ─────────▶ signals.sceneFogChanged
                                                  │
                                                  ▼
                                            scene.fog更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Sidebar.Scene.js | `editor/js/Sidebar.Scene.js` | ソース | Sceneパネルメインコンポーネント |
| Sidebar.js | `editor/js/Sidebar.js` | ソース | Sidebar統合コンポーネント |
| ui.js | `editor/js/libs/ui.js` | ライブラリ | 基本UIコンポーネント |
| ui.three.js | `editor/js/libs/ui.three.js` | ライブラリ | three.js用拡張UIコンポーネント |
| Editor.js | `editor/js/Editor.js` | ソース | エディタ中核クラス |
| Viewport.js | `editor/js/Viewport.js` | ソース | 背景・環境・霧の適用処理 |
