# 画面設計書 31-その他サンプル

## 概要

本ドキュメントは、three.jsのExamplesセクションに含まれる「その他サンプル（Misc Examples）」画面群の設計書である。カメラコントロール、エクスポーター、アニメーション、レイキャスター等のユーティリティ系サンプルを提供する。

### 本画面の処理概要

この画面群は、three.jsの補助機能やユーティリティ機能を実演するための17種類のサンプルを提供する。各サンプルは独立したHTMLファイルとして実装されており、開発者が特定の機能を学習・参照する際に活用される。

**業務上の目的・背景**：three.jsを使用した開発において、カメラ操作やファイルエクスポート、アニメーション制御などは頻繁に必要となる機能である。これらの機能の実装方法を具体的なコード例として提供することで、開発者の学習効率を向上させ、実装時間を短縮することを目的としている。特にOrbitControls、TransformControls、各種エクスポーターは実務での使用頻度が高い。

**画面へのアクセス方法**：Examples一覧画面（examples/index.html）から「Misc」カテゴリを選択するか、URLハッシュフラグメントに直接サンプル名を指定してアクセスする。各サンプルはiframe内に表示される。

**主要な操作・処理内容**：
1. OrbitControls - マウスドラッグでカメラの軌道制御（回転・ズーム・パン）
2. TransformControls - オブジェクトの移動・回転・スケール操作
3. DragControls - オブジェクトのドラッグ＆ドロップ操作
4. FlyControls - フライスルー形式のカメラ移動
5. ArcballControls - アークボール方式のカメラ回転
6. MapControls - マップ閲覧用のカメラ制御
7. PointerLockControls - FPS形式のポインターロック制御
8. TrackballControls - トラックボール方式のカメラ制御
9. GLTFExporter - シーンをGLTF形式でエクスポート
10. OBJExporter - シーンをOBJ形式でエクスポート
11. STLExporter - シーンをSTL形式でエクスポート
12. PLYExporter - シーンをPLY形式でエクスポート
13. USDZExporter - シーンをUSDZ形式でエクスポート（AR用）
14. DracoExporter - Draco圧縮形式でエクスポート
15. KTX2Exporter - KTX2テクスチャ形式でエクスポート
16. EXRExporter - HDR画像をEXR形式でエクスポート
17. AnimationKeys/Groups - キーフレームアニメーションの制御

**画面遷移**：Examples一覧画面からアクセスされ、各サンプルページへの遷移が可能。サンプルからはGitHubソースコードへの外部リンクがある。

**権限による表示制御**：特になし。全てのサンプルは公開されており、認証不要でアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 169 | Controls | 主機能 | 各種カメラコントロールの実装（OrbitControls、TransformControls等） |
| 13 | WebGLRenderer | 主機能 | 3Dシーンのレンダリング処理 |
| 1 | Object3D | 補助機能 | シーン内オブジェクトの管理 |
| 75 | Mesh | 補助機能 | メッシュオブジェクトの表示 |
| 19 | PerspectiveCamera | 補助機能 | カメラの透視投影 |
| 4 | Raycaster | 補助機能 | マウスピッキング処理 |

## 画面種別

サンプル表示画面（インタラクティブデモ）

## URL/ルーティング

- `examples/misc_controls_orbit.html` - OrbitControls
- `examples/misc_controls_transform.html` - TransformControls
- `examples/misc_controls_drag.html` - DragControls
- `examples/misc_controls_fly.html` - FlyControls
- `examples/misc_controls_arcball.html` - ArcballControls
- `examples/misc_controls_map.html` - MapControls
- `examples/misc_controls_pointerlock.html` - PointerLockControls
- `examples/misc_controls_trackball.html` - TrackballControls
- `examples/misc_exporter_gltf.html` - GLTFExporter
- `examples/misc_exporter_obj.html` - OBJExporter
- `examples/misc_exporter_stl.html` - STLExporter
- `examples/misc_exporter_ply.html` - PLYExporter
- `examples/misc_exporter_usdz.html` - USDZExporter
- `examples/misc_exporter_draco.html` - DracoExporter
- `examples/misc_exporter_ktx2.html` - KTX2Exporter
- `examples/misc_exporter_exr.html` - EXRExporter
- `examples/misc_animation_keys.html` - AnimationKeys
- `examples/misc_animation_groups.html` - AnimationGroups
- `examples/misc_boxselection.html` - BoxSelection
- `examples/misc_raycaster_helper.html` - RaycasterHelper
- `examples/misc_uv_tests.html` - UVテスト
- `examples/misc_exporter_gcode.html` - GCodeExporter

## 入出力項目

### OrbitControlsサンプル（misc_controls_orbit.html）

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| マウス左ドラッグ | 入力 | イベント | カメラの回転操作 |
| マウス右ドラッグ | 入力 | イベント | カメラのパン操作 |
| マウスホイール | 入力 | イベント | カメラのズーム操作 |
| レンダリング結果 | 出力 | Canvas | 3Dシーンの描画 |

### エクスポーターサンプル

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| エクスポートボタン | 入力 | イベント | エクスポート処理の開始 |
| 3Dシーンデータ | 入力 | Object | エクスポート対象のシーン |
| ファイルデータ | 出力 | Blob | エクスポートされたファイル |

## 表示項目

| 表示項目 | 説明 |
|----------|------|
| 3Dシーン | WebGLでレンダリングされた3Dコンテンツ |
| 情報テキスト | 操作方法の説明文 |
| GUIパネル | パラメータ調整用のlil-gui |
| Statsパネル | FPS等のパフォーマンス情報（一部サンプル） |

## イベント仕様

### 1-カメラコントロール操作

**OrbitControls**
- マウス左ボタンドラッグ: カメラをターゲット周りに回転
- マウス右ボタンドラッグ: カメラをパン移動
- マウスホイール: ズームイン/アウト
- キーボード矢印キー: パン移動（オプション）

**TransformControls**
- オブジェクト選択後、ギズモをドラッグして移動・回転・スケール
- W/E/Rキーで移動/回転/スケールモード切り替え

### 2-エクスポート操作

エクスポートボタンをクリックすると以下の処理が実行される：
1. シーン内のオブジェクトを走査
2. ジオメトリ・マテリアル・テクスチャを収集
3. 指定フォーマットに変換
4. Blobとしてダウンロードリンクを生成
5. 自動ダウンロード開始

## データベース更新仕様

該当なし（クライアントサイドのみで動作）

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| 情報 | "MOUSE to look around" | ページロード時（PointerLockControls） |
| 情報 | "WASD to move" | ページロード時（FPSスタイルコントロール） |
| エラー | "Export failed" | エクスポート処理失敗時 |
| 成功 | "Download started" | エクスポート成功時 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| WebGL非対応ブラウザ | エラーメッセージ表示、フォールバックなし |
| テクスチャ読み込み失敗 | コンソールエラー出力、デフォルトマテリアル使用 |
| エクスポート失敗 | ユーザーへのエラー通知 |
| ポインターロック拒否 | 操作方法の案内表示 |

## 備考

- 各サンプルは独立したHTMLファイルとして実装されており、ES Modulesを使用
- Import Mapを使用してthree.jsモジュールをインポート
- lil-guiライブラリをGUIパネルに使用
- 一部サンプルはStats.jsでパフォーマンス計測を実施

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コントロール系クラスの基本構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Controls.js | `examples/jsm/controls/Controls.js` | コントロール基底クラス、EventDispatcherを継承 |
| 1-2 | OrbitControls.js | `examples/jsm/controls/OrbitControls.js` | 軌道制御の実装、spherical座標系の使用 |

**読解のコツ**: OrbitControlsはspherical座標（球面座標）を使用してカメラ位置を計算する。phi/thetaの角度とradiusでカメラ位置を決定。

#### Step 2: エントリーポイントを理解する

処理の起点となるHTMLファイルとその初期化処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | misc_controls_orbit.html | `examples/misc_controls_orbit.html` | サンプルのエントリーポイント、初期化フロー |

**主要処理フロー**:
1. **36-39行目**: import文でthree.jsとOrbitControlsをインポート
2. **45-58行目**: init()関数でシーン、レンダラー、カメラを初期化
3. **62-75行目**: OrbitControlsのインスタンス生成とパラメータ設定
4. **126-138行目**: animate()関数でrequestAnimationLoopとレンダリング

#### Step 3: コントロール層を理解する

各コントロールの実装詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OrbitControls.js | `examples/jsm/controls/OrbitControls.js` | マウスイベント処理、カメラ更新ロジック |
| 3-2 | TransformControls.js | `examples/jsm/controls/TransformControls.js` | ギズモの描画とドラッグ処理 |

**主要処理フロー**:
- **update()**: spherical座標からカメラ位置を計算、damping適用
- **onMouseDown/Move/Up**: マウスイベントを処理、state管理
- **rotateLeft/Up**: 回転角度の計算

### プログラム呼び出し階層図

```
misc_controls_orbit.html
    │
    ├─ import { OrbitControls }
    │      └─ extends Controls
    │             └─ extends EventDispatcher
    │
    ├─ new THREE.Scene()
    │
    ├─ new THREE.WebGLRenderer()
    │
    ├─ new THREE.PerspectiveCamera()
    │
    ├─ new OrbitControls(camera, renderer.domElement)
    │      ├─ addEventListener('pointerdown', onPointerDown)
    │      ├─ addEventListener('pointermove', onPointerMove)
    │      └─ addEventListener('wheel', onMouseWheel)
    │
    └─ animate()
           ├─ controls.update()
           │      ├─ applyDamping()
           │      └─ updateCamera()
           └─ renderer.render(scene, camera)
```

### データフロー図

```
[入力]                     [処理]                         [出力]

マウスイベント ─────▶ OrbitControls.onPointerMove() ─────▶ カメラ位置更新
                             │
                             ├─ spherical.theta/phi計算
                             │
                             └─ camera.position.set()

キーボードイベント ──▶ OrbitControls.handleKeyDown() ──▶ パン移動

ホイールイベント ────▶ OrbitControls.onMouseWheel() ────▶ ズーム更新
                             │
                             └─ spherical.radius計算
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| misc_controls_orbit.html | `examples/misc_controls_orbit.html` | ソース | OrbitControlsサンプルのエントリーポイント |
| misc_controls_transform.html | `examples/misc_controls_transform.html` | ソース | TransformControlsサンプル |
| misc_exporter_gltf.html | `examples/misc_exporter_gltf.html` | ソース | GLTFエクスポーターサンプル |
| OrbitControls.js | `examples/jsm/controls/OrbitControls.js` | ソース | 軌道制御の実装 |
| TransformControls.js | `examples/jsm/controls/TransformControls.js` | ソース | 変形制御の実装 |
| DragControls.js | `examples/jsm/controls/DragControls.js` | ソース | ドラッグ制御の実装 |
| GLTFExporter.js | `examples/jsm/exporters/GLTFExporter.js` | ソース | GLTFエクスポート実装 |
| main.css | `examples/main.css` | スタイル | サンプル共通スタイル |
| lil-gui.module.min.js | `examples/jsm/libs/lil-gui.module.min.js` | ライブラリ | GUIパネル |
