# 画面設計書 33-テストサンプル

## 概要

本ドキュメントは、three.jsのExamplesセクションに含まれる「テストサンプル（Tests Examples）」画面群の設計書である。レンダリングエンジンのエネルギー保存性検証（White Furnace Test）やUVマッピングテスト等、three.jsの内部品質検証用サンプルを提供する。

### 本画面の処理概要

この画面群は、three.jsのレンダリング品質を視覚的に検証するためのテストサンプルを提供する。開発者やQAエンジニアがマテリアルの物理的正確性や UV マッピングの正確性を確認するために使用される。

**業務上の目的・背景**：PBR（Physically Based Rendering）マテリアルの実装において、エネルギー保存則の遵守は視覚的リアリズムの基盤となる。White Furnace Testは、マテリアルが白色環境下で理論的に正しい出力（入射光と同等）を返すかを検証し、レンダリングエンジンの物理的正確性を保証する。これはGoogle Filamentプロジェクトで定義された標準テスト手法である。

**画面へのアクセス方法**：Examples一覧画面（examples/index.html）から「Tests」または「WebGL」カテゴリ内の該当項目を選択するか、直接URLにアクセス。

**主要な操作・処理内容**：
1. White Furnace Test - roughness/metalnessの組み合わせで11x11のマテリアル球を表示
2. マウスオーバーで球の色を純白に変更（視認性向上用のティント解除）
3. UV Test - 各ジオメトリのUV座標マッピング検証

**画面遷移**：Examples一覧画面からアクセスされ、単一ページで完結する。

**権限による表示制御**：特になし。公開テストサンプルとして認証不要でアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 53 | MeshPhysicalMaterial | 主機能 | PBRマテリアルのテスト対象 |
| 13 | WebGLRenderer | 主機能 | レンダリング処理 |
| 168 | PMREMGenerator | 主機能 | 環境マップのフィルタリング |
| 28 | SphereGeometry | 補助機能 | テスト用球体ジオメトリ |
| 19 | PerspectiveCamera | 補助機能 | ビューカメラ |

## 画面種別

テスト検証画面（視覚的品質テスト）

## URL/ルーティング

- `examples/webgl_furnace_test.html` - White Furnace Test
- `examples/misc_uv_tests.html` - UVマッピングテスト

## 入出力項目

### White Furnace Test

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| マウスオーバー | 入力 | MouseEvent | 球の色をティントなし（純白）に変更 |
| マウスアウト | 入力 | MouseEvent | 球の色をティント付き（視認性用）に戻す |
| レンダリング結果 | 出力 | Canvas | 11x11のマテリアル球グリッド |

## 表示項目

| 表示項目 | 説明 |
|----------|------|
| 11x11 球体グリッド | roughness（横）とmetalness（縦）の組み合わせ |
| 情報テキスト | 軸の説明（"Roughness increases left to right", "Metalness increases top to bottom"） |
| 背景色 | グレー（#cccccc、COLOR定数） |

## イベント仕様

### 1-マウスオーバー（純白表示）

**トリガー**: document.body への mouseover
**処理内容**:
1. シーン内の全メッシュを走査
2. マテリアルカラーを0xffffffに変更
3. 再レンダリング実行

### 2-マウスアウト（ティント表示）

**トリガー**: document.body への mouseout
**処理内容**:
1. シーン内の全メッシュを走査
2. マテリアルカラーを0xccccff（薄い青紫）に変更
3. 再レンダリング実行

### 3-ウィンドウリサイズ

**トリガー**: window resize イベント
**処理内容**:
1. カメラアスペクト比更新
2. レンダラーサイズ更新
3. 再レンダリング実行

## データベース更新仕様

該当なし（クライアントサイドのみで動作）

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| 情報 | "White Furnace energy conservation test" | ページ上部に常時表示 |
| 情報 | "Roughness increases left to right" | ページ上部に常時表示 |
| 情報 | "Metalness increases top to bottom" | ページ上部に常時表示 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| WebGL非対応ブラウザ | エラーメッセージ表示 |
| PMREMGenerator失敗 | 環境マップなしでレンダリング継続 |

## 備考

- White Furnace Testの理論的背景：完全拡散白色環境下では、理想的なマテリアルは入射光と同等のエネルギーを反射する（エネルギー保存則）
- Google Filamentドキュメントで定義されたテスト手法を参照
- マウスオーバー時の純白表示は、エネルギー保存性の厳密な視覚確認用
- ティント表示（薄い青紫）は、個々の球を視覚的に識別しやすくするため
- envMapIntensity = 1 で環境マップの寄与を100%に設定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、PBRマテリアルの物理特性パラメータを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MeshPhysicalMaterial.js | `src/materials/MeshPhysicalMaterial.js` | roughness, metalness パラメータの定義 |

**読解のコツ**: roughness（粗さ）は0で鏡面、1で完全拡散。metalness（金属性）は0で非金属、1で金属。White Furnace Testでは全組み合わせを検証。

#### Step 2: エントリーポイントを理解する

処理の起点となるHTMLファイルとその初期化処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | webgl_furnace_test.html | `examples/webgl_furnace_test.html` | テストのエントリーポイント |

**主要処理フロー**:
1. **37-84行目**: init()関数 - レンダラー、シーン、カメラ初期化
2. **52-74行目**: マウスイベントリスナー設定（色切り替え）
3. **86-113行目**: createObjects() - 11x11の球体グリッド生成
4. **115-126行目**: createEnvironment() - 白色環境マップ生成
5. **148-152行目**: Promise chainによる初期化フロー

#### Step 3: 環境マップ生成を理解する

PMREMGeneratorによる白色環境マップの生成を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | webgl_furnace_test.html（続き） | `examples/webgl_furnace_test.html` | createEnvironment関数 |

**主要処理フロー**:
- **115-117行目**: 白色背景のシーン作成
- **120-122行目**: PMREMGenerator.fromScene()で環境マップ生成
- **124行目**: シーン背景に同じ色を設定

### プログラム呼び出し階層図

```
webgl_furnace_test.html
    │
    ├─ init()
    │      ├─ new THREE.WebGLRenderer()
    │      ├─ new THREE.Scene()
    │      ├─ new THREE.PerspectiveCamera()
    │      └─ addEventListener('mouseover/mouseout')
    │
    ├─ createEnvironment()
    │      ├─ new THREE.Scene() (envScene)
    │      ├─ envScene.background = new THREE.Color(0xcccccc)
    │      ├─ new THREE.PMREMGenerator(renderer)
    │      └─ pmremGenerator.fromScene(envScene)
    │             └─ radianceMap生成
    │
    ├─ createObjects()
    │      └─ for (x: 0-10, y: 0-10)
    │             ├─ new THREE.SphereGeometry(0.4, 32, 16)
    │             ├─ new THREE.MeshPhysicalMaterial({
    │             │      roughness: x/10,
    │             │      metalness: y/10,
    │             │      envMap: radianceMap
    │             │   })
    │             └─ scene.add(mesh)
    │
    └─ render()
           └─ renderer.render(scene, camera)
```

### データフロー図

```
[入力]                     [処理]                         [出力]

初期化 ─────────────▶ PMREMGenerator.fromScene() ──────▶ radianceMap
                             │
                             └─ 白色シーンからIBL用環境マップ生成

roughness (0-1) ─────▶ MeshPhysicalMaterial ──────────▶ 球体メッシュ
metalness (0-1) ──────┘                                    │
                                                           │
radianceMap ─────────▶ material.envMap ──────────────────┘

マウスイベント ──────▶ material.color変更 ─────────────▶ 再レンダリング
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| webgl_furnace_test.html | `examples/webgl_furnace_test.html` | ソース | White Furnace Testのメイン |
| misc_uv_tests.html | `examples/misc_uv_tests.html` | ソース | UVマッピングテスト |
| MeshPhysicalMaterial.js | `src/materials/MeshPhysicalMaterial.js` | ソース | PBRマテリアル実装 |
| PMREMGenerator.js | `src/extras/PMREMGenerator.js` | ソース | 環境マップフィルタリング |
| main.css | `examples/main.css` | スタイル | サンプル共通スタイル |
