# 画面設計書 34-ドキュメントトップ

## 概要

本ドキュメントは、three.jsのAPIドキュメントのトップページ（docs/index.html）の設計書である。全クラス・モジュールの検索・閲覧機能を提供し、開発者がAPIリファレンスにアクセスするための主要なエントリーポイントとなる。

### 本画面の処理概要

このページは、three.jsの全APIドキュメントをカテゴリ別に整理して表示する。左側のナビゲーションパネルでクラスやモジュールを階層的に閲覧でき、選択した項目の詳細ドキュメントがiframe内に表示される。検索機能により、目的のAPIを素早く見つけることができる。

**業務上の目的・背景**：three.jsは数百のクラスとモジュールを持つ大規模ライブラリであり、開発者が必要なAPIを効率的に見つけられるドキュメント構成が不可欠である。本ページは、Animation、Audio、Cameras、Core、Geometries、Materials、Math、Nodes等のカテゴリに整理されたナビゲーションを提供し、検索機能と組み合わせてAPI発見の効率を最大化している。

**画面へのアクセス方法**：three.jsプロジェクトのドキュメントディレクトリ（docs/）に直接アクセスするか、公式サイト（threejs.org/docs）経由でアクセス。

**主要な操作・処理内容**：
1. カテゴリ別のナビゲーションツリー表示
2. 検索フィールドでのリアルタイムフィルタリング
3. 選択したAPIドキュメントのiframe内表示
4. URLハッシュによるドキュメント間の直接リンク
5. ブラウザ履歴を使用したナビゲーション（戻る/進む対応）

**画面遷移**：manualページへのリンクあり。各ドキュメントページへはiframe内で遷移。インタラクティブドキュメント（Geometry Browser、Material Browser、Bones Browser）への遷移も可能。

**権限による表示制御**：特になし。公開ドキュメントとして認証不要でアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | EventDispatcher | 主機能 | ドキュメント検索・ナビゲーションイベント管理 |

## 画面種別

ドキュメント閲覧画面（APIリファレンス）

## URL/ルーティング

- ベースURL: `docs/index.html`
- 個別ドキュメント: `docs/index.html#api/en/{Category}/{ClassName}`
- 例: `docs/index.html#api/en/core/Object3D`

## 入出力項目

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| 検索クエリ | 入力 | String | クラス/モジュール名での検索 |
| カテゴリ選択 | 入力 | Click | ナビゲーションツリーでの選択 |
| URLハッシュ | 入力 | String | ドキュメントへの直接リンク |
| ナビゲーションツリー | 出力 | DOM | カテゴリ別のAPIリスト |
| ドキュメントコンテンツ | 出力 | HTML (iframe) | 選択したAPIの詳細説明 |

## 表示項目

| 表示項目 | 説明 |
|----------|------|
| ヘッダー | three.jsロゴ、docs/manual切り替え |
| 検索フィールド | リアルタイム検索入力 |
| ナビゲーションパネル | カテゴリ別APIリスト |
| コンテンツエリア（iframe） | 選択したドキュメントの表示 |

### ナビゲーションカテゴリ

- **Animation**: AnimationAction, AnimationClip, AnimationMixer等
- **Audio**: Audio, AudioAnalyser, AudioListener, PositionalAudio
- **Cameras**: Camera, PerspectiveCamera, OrthographicCamera等
- **Core**: BufferGeometry, Object3D, Raycaster, Timer等
- **Extras**: Curve, Path, Shape, PMREMGenerator等
- **Geometries**: BoxGeometry, SphereGeometry等（21種類）
- **Helpers**: ArrowHelper, BoxHelper, GridHelper等
- **Lights**: AmbientLight, DirectionalLight, PointLight等
- **Loaders**: FileLoader, GLTFLoader, TextureLoader等
- **Materials**: MeshBasicMaterial, MeshStandardMaterial等
- **Math**: Vector2, Vector3, Matrix4, Quaternion等
- **Nodes**: NodeMaterial関連ノードクラス
- **Objects**: Mesh, Group, SkinnedMesh等
- **Renderers**: WebGLRenderer, WebGPURenderer等
- **Scenes**: Scene, Fog, FogExp2
- **Textures**: Texture, DataTexture, CubeTexture等

## イベント仕様

### 1-検索フィルタリング

**トリガー**: 検索フィールドへの入力
**処理内容**:
1. 入力値で正規表現を生成
2. 全ナビゲーション項目をマッチングテスト
3. マッチしない項目を非表示（hidden class追加）
4. カテゴリ内全項目が非表示ならカテゴリも非表示
5. マッチ部分をボールド表示

### 2-ドキュメント選択

**トリガー**: ナビゲーション項目のクリック
**処理内容**:
1. クリックイベントをキャプチャ
2. URLハッシュを更新
3. iframeのsrcを対応するHTMLファイルに設定
4. 選択状態（selected class）を更新
5. ブラウザ履歴にプッシュ

### 3-ブラウザナビゲーション

**トリガー**: ブラウザの戻る/進むボタン
**処理内容**:
1. popstateイベントをリッスン
2. URLハッシュからドキュメントパスを取得
3. ナビゲーションの選択状態を更新
4. iframeコンテンツを更新

### 4-ハンバーガーメニュー（モバイル）

**トリガー**: expandButtonクリック
**処理内容**:
1. panelにopen classをトグル
2. ナビゲーションパネルの表示/非表示切り替え

## データベース更新仕様

該当なし（静的サイト）

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| 情報 | コンソールにASCIIアートロゴ | ページロード時 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| 存在しないドキュメントへのアクセス | 404ページ表示（iframe内） |
| 検索結果なし | 全項目非表示、空の状態 |

## 備考

- 静的HTMLベースのドキュメントサイト
- iframeを使用してメインフレームとドキュメントコンテンツを分離
- URLハッシュベースのルーティングでSEOと直接リンクに対応
- コンソールにthree.jsのASCIIアートロゴを表示（イースターエッグ）
- window.THREEにthree.jsモジュールを公開（コンソールでの実験用）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ナビゲーション構造を定義するデータを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.html | `docs/index.html` | HTMLに埋め込まれたナビゲーション構造 |

**読解のコツ**: ナビゲーションは静的HTMLとして定義されており、h2（カテゴリ大分類）、h3（サブカテゴリ）、ul/li/a（リンク）の階層構造。

#### Step 2: エントリーポイントを理解する

JavaScriptによる動的処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | docs/index.html（script部分） | `docs/index.html` | DOMセレクタ取得、イベントリスナー設定 |

**主要処理フロー**:
1. DOM要素の取得（panel, content, filterInput等）
2. expandButton.onclick - モバイルメニュー切り替え
3. filterInput.oninput - 検索フィルタリング
4. window.onpopstate - ブラウザナビゲーション対応

#### Step 3: フィルタリングロジックを理解する

検索機能の実装詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | docs/index.html（updateFilter関数相当） | `docs/index.html` | 検索ロジック |

**主要処理フロー**:
- 入力値から正規表現を生成
- querySelectorAll('a')で全リンクを取得
- textContentでマッチング
- parentElement.classList.add/remove('hidden')で表示制御

### プログラム呼び出し階層図

```
docs/index.html
    │
    ├─ DOMContentLoaded / script実行
    │      │
    │      ├─ document.querySelector() で要素取得
    │      │      ├─ #panel
    │      │      ├─ #content
    │      │      ├─ #expandButton
    │      │      └─ #filterInput
    │      │
    │      ├─ expandButton.onclick
    │      │      └─ panel.classList.toggle('open')
    │      │
    │      ├─ filterInput.oninput
    │      │      ├─ RegExp(input.value, 'gi')
    │      │      └─ 全リンク要素をfilter
    │      │
    │      └─ window.onpopstate
    │             └─ iframe.src更新
    │
    └─ iframe (name="viewer")
           └─ 各ドキュメントHTML表示
```

### データフロー図

```
[入力]                     [処理]                         [出力]

検索クエリ ──────────▶ RegExp.test(linkText) ──────────▶ 表示/非表示
                             │
                             └─ classList.add/remove('hidden')

URLハッシュ ─────────▶ parseHash() ─────────────────▶ iframe.src
      #api/en/core/Object3D
                             │
                             └─ 'api/en/core/Object3D.html'

クリックイベント ────▶ history.pushState() ──────────▶ URLハッシュ更新
                             │
                             └─ location.hash = newHash
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `docs/index.html` | ソース | ドキュメントトップページ |
| main.css | `files/main.css` | スタイル | 共通スタイル |
| three.module.js | `build/three.module.js` | ライブラリ | コンソール用THREE公開 |
| api/en/**/*.html | `docs/api/en/**/*.html` | ドキュメント | 各クラスのAPIドキュメント |
| scenes/geometry-browser.html | `docs/scenes/geometry-browser.html` | インタラクティブ | ジオメトリプレビュー |
| scenes/material-browser.html | `docs/scenes/material-browser.html` | インタラクティブ | マテリアルプレビュー |
| scenes/bones-browser.html | `docs/scenes/bones-browser.html` | インタラクティブ | スケルトンプレビュー |
