# 画面設計書 35-Geometry Browser

## 概要

本ドキュメントは、three.jsのドキュメントに含まれる「Geometry Browser」画面（docs/scenes/geometry-browser.html）の設計書である。three.jsで利用可能な各種ジオメトリを3Dプレビューで確認でき、パラメータをリアルタイムに調整してジオメトリの形状変化を視覚的に理解できるインタラクティブツールを提供する。

### 本画面の処理概要

このページは、three.jsの標準ジオメトリクラス（BoxGeometry, SphereGeometry, CylinderGeometry等）を3Dで表示し、lil-guiを使用してパラメータをリアルタイムに調整できるインタラクティブブラウザである。開発者はジオメトリのコンストラクタパラメータが形状にどう影響するかを視覚的に学習できる。

**業務上の目的・背景**：three.jsには20種類以上のビルトインジオメトリクラスが存在し、各クラスは固有のコンストラクタパラメータを持つ。これらのパラメータがジオメトリ形状に与える影響を理解するには、実際に値を変更して結果を確認するのが最も効果的である。本ツールは、APIドキュメントの補助として、パラメータの意味と効果を直感的に理解させることを目的としている。

**画面へのアクセス方法**：ドキュメントトップページ（docs/index.html）の各ジオメトリクラスのドキュメントページ内リンクから、またはURLハッシュで直接ジオメトリタイプを指定してアクセス。例: `geometry-browser.html#BoxGeometry`

**主要な操作・処理内容**：
1. ジオメトリタイプの選択（URLハッシュまたはデフォルト）
2. lil-guiパネルでのパラメータリアルタイム調整
3. OrbitControlsによるカメラ回転操作（ズームは無効）
4. ジオメトリのアニメーション回転表示
5. ワイヤーフレームとソリッドメッシュの同時表示

**画面遷移**：ドキュメントページのiframe内で表示。「Open in New Window」リンクで新しいウィンドウで開くことも可能。

**権限による表示制御**：特になし。公開ドキュメントとして認証不要でアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 27 | BoxGeometry | 主機能 | 直方体ジオメトリのプレビュー |
| 28 | SphereGeometry | 主機能 | 球体ジオメトリのプレビュー |
| 30 | CylinderGeometry | 主機能 | 円柱ジオメトリのプレビュー |
| 32 | TorusGeometry | 主機能 | トーラスジオメトリのプレビュー |
| 13 | WebGLRenderer | 補助機能 | 3Dレンダリング |
| 19 | PerspectiveCamera | 補助機能 | ビューカメラ |

## 画面種別

インタラクティブプレビュー画面（3Dジオメトリエディタ）

## URL/ルーティング

- ベースURL: `docs/scenes/geometry-browser.html`
- ジオメトリ指定: `geometry-browser.html#{GeometryType}`
- 例: `geometry-browser.html#BoxGeometry`, `geometry-browser.html#SphereGeometry`

### 対応ジオメトリタイプ
- BoxGeometry
- CapsuleGeometry
- CircleGeometry
- ConeGeometry
- CylinderGeometry
- DodecahedronGeometry
- ExtrudeGeometry
- IcosahedronGeometry
- LatheGeometry
- OctahedronGeometry
- PlaneGeometry
- RingGeometry
- ShapeGeometry
- SphereGeometry
- TetrahedronGeometry
- TorusGeometry
- TorusKnotGeometry
- TubeGeometry

## 入出力項目

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| ジオメトリタイプ（URLハッシュ） | 入力 | String | 表示するジオメトリの種類 |
| パラメータ値（GUI） | 入力 | Number | 各ジオメトリのコンストラクタパラメータ |
| マウスドラッグ | 入力 | MouseEvent | OrbitControlsによるカメラ回転 |
| 3Dプレビュー | 出力 | Canvas | ジオメトリの3D表示 |

### ジオメトリ別パラメータ例

**BoxGeometry**
| パラメータ | 型 | 範囲 | 説明 |
|-----------|------|------|------|
| width | Number | 1-30 | 幅 |
| height | Number | 1-30 | 高さ |
| depth | Number | 1-30 | 奥行き |
| widthSegments | Integer | 1-10 | 幅方向の分割数 |
| heightSegments | Integer | 1-10 | 高さ方向の分割数 |
| depthSegments | Integer | 1-10 | 奥行き方向の分割数 |

**SphereGeometry**
| パラメータ | 型 | 範囲 | 説明 |
|-----------|------|------|------|
| radius | Number | 1-30 | 半径 |
| widthSegments | Integer | 3-64 | 水平方向の分割数 |
| heightSegments | Integer | 2-32 | 垂直方向の分割数 |
| phiStart | Number | 0-2π | 水平開始角度 |
| phiLength | Number | 0-2π | 水平角度範囲 |
| thetaStart | Number | 0-2π | 垂直開始角度 |
| thetaLength | Number | 0-2π | 垂直角度範囲 |

## 表示項目

| 表示項目 | 説明 |
|----------|------|
| 3Dジオメトリ（ソリッド） | MeshPhongMaterialで描画されたメッシュ |
| ワイヤーフレーム | WireframeGeometryで描画されたエッジ |
| GUIパネル | lil-guiによるパラメータ調整UI |
| 「Open in New Window」リンク | 新しいウィンドウで開くリンク |

## イベント仕様

### 1-パラメータ変更

**トリガー**: lil-guiコントローラーの値変更
**処理内容**:
1. onChange コールバックが発火
2. generateGeometry() 関数を呼び出し
3. 新しいパラメータでジオメトリを再生成
4. updateGroupGeometry() でメッシュを更新
5. 古いジオメトリを dispose() で破棄

### 2-ジオメトリタイプ選択

**トリガー**: ページロード時のURLハッシュ解析
**処理内容**:
1. window.location.hash.substring(1) でジオメトリ名取得
2. guis[selectedGeometry] 関数を実行
3. 対応するGUIパネルを生成
4. 初期ジオメトリを生成・表示

### 3-カメラ回転

**トリガー**: マウスドラッグ
**処理内容**:
1. OrbitControls がマウスイベントをキャプチャ
2. カメラ位置をターゲット周りに回転
3. ズームは enableZoom = false で無効化

### 4-アニメーションループ

**トリガー**: requestAnimationFrame
**処理内容**:
1. group.rotation.x += 0.005
2. group.rotation.y += 0.005
3. renderer.render(scene, camera)

## データベース更新仕様

該当なし（クライアントサイドのみで動作）

## メッセージ仕様

特になし。

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| 不明なジオメトリタイプ | デフォルト（TorusGeometry）を表示 |
| WebGL非対応ブラウザ | エラーメッセージ表示 |

## 備考

- 各ジオメトリの初期パラメータは視覚的に分かりやすい値に設定
- WireframeGeometry とソリッドメッシュを Group でまとめて管理
- MeshPhongMaterial に flatShading: true を設定してセグメントを可視化
- DoubleSide を使用して両面レンダリング
- 3つの DirectionalLight で全方向から照明

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

guis オブジェクトの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | geometry-browser.html | `docs/scenes/geometry-browser.html` | guis オブジェクトの定義（129-718行目） |

**読解のコツ**: guis は各ジオメトリタイプをキーとし、そのジオメトリのGUI生成関数を値とするオブジェクト。各関数は data オブジェクトでパラメータを保持し、generateGeometry 関数でジオメトリを生成する。

#### Step 2: エントリーポイントを理解する

ページ初期化フローを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | geometry-browser.html | `docs/scenes/geometry-browser.html` | 初期化処理（720-806行目） |

**主要処理フロー**:
1. **720-730行目**: chooseFromHash() 関数定義 - ハッシュからジオメトリ選択
2. **734-740行目**: newWindow リンクのハッシュ設定
3. **742行目**: GUI インスタンス生成
4. **744-753行目**: シーン、カメラ、レンダラー初期化
5. **755-756行目**: OrbitControls 設定（ズーム無効）
6. **758-769行目**: 3つのDirectionalLight追加
7. **771-784行目**: Group 作成、初期ジオメトリ設定
8. **786-795行目**: render() 関数定義（アニメーションループ）

#### Step 3: ジオメトリ更新処理を理解する

パラメータ変更時のジオメトリ更新処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | geometry-browser.html | `docs/scenes/geometry-browser.html` | updateGroupGeometry関数（103-113行目） |

**主要処理フロー**:
- **105-106行目**: 古いジオメトリを dispose()
- **108行目**: WireframeGeometry を新しいジオメトリで生成
- **109行目**: メッシュのジオメトリを更新

### プログラム呼び出し階層図

```
geometry-browser.html
    │
    ├─ 初期化
    │      ├─ new GUI()
    │      ├─ new Scene()
    │      ├─ new PerspectiveCamera()
    │      ├─ new WebGLRenderer()
    │      ├─ new OrbitControls() (enableZoom = false)
    │      └─ DirectionalLight x 3
    │
    ├─ chooseFromHash(group)
    │      └─ guis[selectedGeometry](mesh)
    │             ├─ data オブジェクト定義
    │             ├─ generateGeometry() 定義
    │             ├─ gui.addFolder()
    │             │      └─ folder.add().onChange(generateGeometry)
    │             └─ generateGeometry() 初回呼び出し
    │
    └─ render() (requestAnimationFrame)
           ├─ group.rotation.x/y += 0.005
           └─ renderer.render(scene, camera)
```

### データフロー図

```
[入力]                     [処理]                         [出力]

URLハッシュ ─────────▶ chooseFromHash() ──────────────▶ guis[type]実行
 #BoxGeometry                    │
                                 └─ GUIパネル生成

GUIパラメータ変更 ──▶ generateGeometry() ─────────────▶ 新ジオメトリ
                             │
                             ├─ new BoxGeometry(data.width, ...)
                             └─ updateGroupGeometry(mesh, geometry)
                                      │
                                      ├─ dispose() 古いジオメトリ
                                      └─ 新ジオメトリを設定

マウスドラッグ ─────▶ OrbitControls.update() ─────────▶ カメラ回転
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| geometry-browser.html | `docs/scenes/geometry-browser.html` | ソース | Geometry Browserのメイン |
| three.module.js | `build/three.module.js` | ライブラリ | three.jsコア |
| lil-gui.module.min.js | `examples/jsm/libs/lil-gui.module.min.js` | ライブラリ | GUIパネル |
| OrbitControls.js | `examples/jsm/controls/OrbitControls.js` | ライブラリ | カメラ制御 |
| main.css | `files/main.css` | スタイル | 共通スタイル |
