# 画面設計書 36-Material Browser

## 概要

本ドキュメントは、three.jsのドキュメントに含まれる「Material Browser」画面（docs/scenes/material-browser.html）の設計書である。three.jsで利用可能な各種マテリアルを3Dプレビューで確認でき、色・テクスチャ・その他パラメータをリアルタイムに調整してマテリアルの見た目を視覚的に理解できるインタラクティブツールを提供する。

### 本画面の処理概要

このページは、three.jsの標準マテリアルクラス（MeshBasicMaterial, MeshStandardMaterial, MeshPhysicalMaterial等）を3Dで表示し、lil-guiを使用してパラメータをリアルタイムに調整できるインタラクティブブラウザである。開発者はマテリアルのプロパティが外観にどう影響するかを視覚的に学習できる。

**業務上の目的・背景**：three.jsには10種類以上のマテリアルクラスが存在し、各クラスは固有のプロパティ（color, roughness, metalness, envMap等）を持つ。特にPBRマテリアル（MeshStandardMaterial, MeshPhysicalMaterial）は多数のパラメータを持ち、それらの相互作用を理解するには実験が不可欠である。本ツールは、マテリアルの視覚的理解を促進し、開発効率を向上させることを目的としている。

**画面へのアクセス方法**：ドキュメントトップページ（docs/index.html）の各マテリアルクラスのドキュメントページ内リンクから、またはURLハッシュで直接マテリアルタイプを指定してアクセス。例: `material-browser.html#MeshPhysicalMaterial`

**主要な操作・処理内容**：
1. マテリアルタイプの選択（URLハッシュまたはデフォルト）
2. lil-guiパネルでの色・テクスチャ・パラメータのリアルタイム調整
3. シーン設定（霧、環境光）の調整
4. TorusKnotGeometryでのマテリアル表示
5. アニメーション回転による全方向からの確認

**画面遷移**：ドキュメントページのiframe内で表示。「Open in New Window」リンクで新しいウィンドウで開くことも可能。

**権限による表示制御**：特になし。公開ドキュメントとして認証不要でアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | MeshBasicMaterial | 主機能 | 基本マテリアルのプレビュー |
| 52 | MeshStandardMaterial | 主機能 | PBRマテリアルのプレビュー |
| 53 | MeshPhysicalMaterial | 主機能 | 物理マテリアルのプレビュー |
| 13 | WebGLRenderer | 補助機能 | 3Dレンダリング |
| 168 | PMREMGenerator | 補助機能 | 環境マップの前処理 |

## 画面種別

インタラクティブプレビュー画面（3Dマテリアルエディタ）

## URL/ルーティング

- ベースURL: `docs/scenes/material-browser.html`
- マテリアル指定: `material-browser.html#{MaterialType}`
- 例: `material-browser.html#MeshBasicMaterial`, `material-browser.html#MeshPhysicalMaterial`

### 対応マテリアルタイプ
- MeshBasicMaterial
- MeshLambertMaterial
- MeshMatcapMaterial
- MeshPhongMaterial
- MeshToonMaterial
- MeshStandardMaterial
- MeshPhysicalMaterial
- MeshDepthMaterial
- MeshNormalMaterial
- LineBasicMaterial

## 入出力項目

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| マテリアルタイプ（URLハッシュ） | 入力 | String | 表示するマテリアルの種類 |
| 色（color, emissive等） | 入力 | Hex | カラーピッカーで選択 |
| 数値パラメータ | 入力 | Number | スライダーで調整（roughness, metalness等） |
| テクスチャ選択 | 入力 | String | ドロップダウンで選択 |
| 3Dプレビュー | 出力 | Canvas | マテリアルの3D表示 |

### マテリアル別パラメータ例

**MeshBasicMaterial**
| パラメータ | 型 | 説明 |
|-----------|------|------|
| color | Color | 基本色 |
| wireframe | Boolean | ワイヤーフレーム表示 |
| vertexColors | Boolean | 頂点カラー使用 |
| fog | Boolean | 霧の影響を受けるか |
| envMap | Texture | 環境マップ |
| map | Texture | 拡散マップ |
| alphaMap | Texture | アルファマップ |

**MeshPhysicalMaterial**
| パラメータ | 型 | 説明 |
|-----------|------|------|
| color | Color | 基本色 |
| emissive | Color | 発光色 |
| roughness | Number (0-1) | 表面の粗さ |
| metalness | Number (0-1) | 金属性 |
| ior | Number (1-2.333) | 屈折率 |
| reflectivity | Number (0-1) | 反射率 |
| iridescence | Number (0-1) | 虹色効果 |
| sheen | Number (0-1) | シーン効果 |
| clearcoat | Number (0-1) | クリアコート |
| specularIntensity | Number (0-1) | スペキュラ強度 |

## 表示項目

| 表示項目 | 説明 |
|----------|------|
| 3Dオブジェクト | TorusKnotGeometryでマテリアルを表示 |
| Sceneパネル | 背景色・環境光・霧の設定 |
| THREE.Materialパネル | 共通マテリアルプロパティ |
| マテリアル固有パネル | 選択したマテリアル固有のプロパティ |
| 「Open in New Window」リンク | 新しいウィンドウで開くリンク |

## イベント仕様

### 1-色変更

**トリガー**: lil-guiカラーピッカーの値変更
**処理内容**:
1. handleColorChange() コールバックが発火
2. color.setHex(value) で色を更新
3. 自動的に再レンダリング

### 2-テクスチャ変更

**トリガー**: lil-guiドロップダウンの選択変更
**処理内容**:
1. updateTexture() コールバックが発火
2. material[materialKey] = textures[key] でテクスチャ設定
3. material.needsUpdate = true

### 3-数値パラメータ変更

**トリガー**: lil-guiスライダーの値変更
**処理内容**:
1. 直接プロパティにバインド
2. 一部はneedsUpdate() コールバック経由でジオメトリ属性も更新

### 4-霧の切り替え

**トリガー**: scene.fog チェックボックス
**処理内容**:
1. scene.fog = fog または null を設定
2. material.needsUpdate = true（霧対応フラグの再コンパイル）

### 5-マテリアルタイプ選択

**トリガー**: ページロード時のURLハッシュ解析
**処理内容**:
1. window.location.hash.substring(1) でマテリアル名取得
2. chooseFromHash() で対応するマテリアルとGUIを生成
3. 一部マテリアルはライト設定を変更（MatcapはライトOFF等）

## データベース更新仕様

該当なし（クライアントサイドのみで動作）

## メッセージ仕様

特になし。

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| 不明なマテリアルタイプ | デフォルト（MeshBasicMaterial）を表示 |
| テクスチャ読み込み失敗 | コンソールエラー、nullテクスチャで継続 |

## 備考

- テクスチャはプリロードされてオブジェクトに格納（envMaps, diffuseMaps, roughnessMaps等）
- RoomEnvironment を使用してPBR用のIBL環境を生成
- PMREMGenerator でリアルタイム環境マップフィルタリング
- 頂点カラーはgenerateVertexColors()で動的生成
- MeshMatcapMaterial, MeshToonMaterial はライト設定を自動調整

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テクスチャとマテリアル設定の初期化を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | material-browser.html | `docs/scenes/material-browser.html` | テクスチャプリロード（120-213行目） |

**読解のコツ**: envMaps, diffuseMaps, roughnessMaps, matcaps, alphaMaps, gradientMaps がそれぞれのテクスチャ種類を格納。GUIのドロップダウン選択肢もこれらのキーから生成。

#### Step 2: エントリーポイントを理解する

ページ初期化フローを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | material-browser.html | `docs/scenes/material-browser.html` | 初期化処理（733-815行目） |

**主要処理フロー**:
1. **743行目**: GUI インスタンス生成
2. **745-748行目**: WebGLRenderer 初期化
3. **750-754行目**: PMREMGenerator と RoomEnvironment で環境設定
4. **756-757行目**: カメラ初期化
5. **759-772行目**: 環境光、DirectionalLight x 3 の設定
6. **774行目**: guiScene() でシーン設定GUI追加
7. **776-781行目**: TorusKnotGeometry と頂点カラー生成
8. **781行目**: chooseFromHash() でマテリアル選択

#### Step 3: マテリアル固有GUI生成を理解する

各マテリアルタイプのGUI生成関数を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | material-browser.html | `docs/scenes/material-browser.html` | chooseFromHash関数（598-731行目） |

**主要処理フロー**:
- switch文でマテリアルタイプを分岐
- 各caseで new THREE.{MaterialType} を生成
- guiMaterial() で共通プロパティ設定
- gui{MaterialType}() で固有プロパティ設定
- 一部マテリアルはlight.visible = false でライト調整

### プログラム呼び出し階層図

```
material-browser.html
    │
    ├─ テクスチャプリロード
    │      ├─ envMaps（reflection, refraction）
    │      ├─ diffuseMaps（bricks）
    │      ├─ roughnessMaps
    │      ├─ matcaps
    │      ├─ alphaMaps
    │      └─ gradientMaps
    │
    ├─ 初期化
    │      ├─ new GUI()
    │      ├─ new WebGLRenderer()
    │      ├─ new PMREMGenerator()
    │      │      └─ fromScene(new RoomEnvironment())
    │      ├─ new PerspectiveCamera()
    │      ├─ AmbientLight + DirectionalLight x 3
    │      └─ guiScene() - シーン設定GUI
    │
    ├─ chooseFromHash(gui, mesh, geometry)
    │      ├─ switch(selectedMaterial)
    │      │      ├─ 'MeshBasicMaterial' →
    │      │      │      ├─ new THREE.MeshBasicMaterial()
    │      │      │      ├─ guiMaterial()
    │      │      │      └─ guiMeshBasicMaterial()
    │      │      ├─ 'MeshStandardMaterial' →
    │      │      │      ├─ new THREE.MeshStandardMaterial()
    │      │      │      ├─ guiMaterial()
    │      │      │      └─ guiMeshStandardMaterial()
    │      │      └─ ... 他マテリアル
    │      └─ return material
    │
    └─ render() (requestAnimationFrame)
           ├─ mesh.rotation.x/y += 0.005
           ├─ 霧変更チェック → material.needsUpdate
           └─ renderer.render(scene, camera)
```

### データフロー図

```
[入力]                     [処理]                         [出力]

URLハッシュ ─────────▶ chooseFromHash() ──────────────▶ マテリアル生成
 #MeshPhysicalMaterial           │
                                 └─ GUIパネル生成

カラーピッカー ──────▶ handleColorChange(color) ──────▶ color.setHex()
                             │
                             └─ material.color更新

テクスチャ選択 ──────▶ updateTexture(material, key) ─▶ material[key]更新
                             │
                             └─ material.needsUpdate = true

スライダー ──────────▶ 直接プロパティバインド ─────────▶ roughness/metalness等
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| material-browser.html | `docs/scenes/material-browser.html` | ソース | Material Browserのメイン |
| three.module.js | `build/three.module.js` | ライブラリ | three.jsコア |
| lil-gui.module.min.js | `examples/jsm/libs/lil-gui.module.min.js` | ライブラリ | GUIパネル |
| RoomEnvironment.js | `examples/jsm/environments/RoomEnvironment.js` | ライブラリ | IBL環境生成 |
| brick_diffuse.jpg | `examples/textures/brick_diffuse.jpg` | テクスチャ | 拡散マップ例 |
| brick_roughness.jpg | `examples/textures/brick_roughness.jpg` | テクスチャ | 粗さマップ例 |
| matcap-porcelain-white.jpg | `examples/textures/matcaps/matcap-porcelain-white.jpg` | テクスチャ | Matcap例 |
| SwedishRoyalCastle/*.jpg | `examples/textures/cube/SwedishRoyalCastle/` | テクスチャ | キューブマップ |
| main.css | `files/main.css` | スタイル | 共通スタイル |
