# 画面設計書 38-マニュアルトップ

## 概要

本ドキュメントは、three.jsの学習用マニュアルのトップページ（manual/index.html）の設計書である。three.jsの基礎から応用までのチュートリアルとガイドを提供し、多言語対応（英語、フランス語、ロシア語、韓国語、中国語、日本語）のコンテンツを閲覧できる。

### 本画面の処理概要

このページは、three.jsの学習用マニュアルコンテンツをカテゴリ別に整理して表示する。左側のナビゲーションパネルでチャプターを階層的に閲覧でき、選択した項目の詳細コンテンツがiframe内に表示される。言語セレクターにより、対応言語のコンテンツに自動切り替えできる。

**業務上の目的・背景**：three.jsは機能が豊富で学習曲線が急であるため、段階的に学習できるマニュアルが不可欠である。本マニュアルは、Fundamentals（基礎）、Techniques（テクニック）、Solutions（ソリューション）、Tips（ヒント）等のカテゴリに整理されたチュートリアルを提供し、初心者から上級者までの学習をサポートする。多言語対応により、世界中の開発者がアクセス可能である。

**画面へのアクセス方法**：three.jsプロジェクトのマニュアルディレクトリ（manual/）に直接アクセスするか、公式サイト（threejs.org/manual）経由でアクセス。ドキュメントトップページ（docs/index.html）からのリンクもある。

**主要な操作・処理内容**：
1. 言語セレクターによる表示言語の切り替え
2. カテゴリ別のナビゲーションツリー表示
3. 検索フィールドでのリアルタイムフィルタリング
4. 選択したマニュアルページのiframe内表示
5. URLハッシュによるページ間の直接リンク
6. ブラウザ履歴を使用したナビゲーション

**画面遷移**：docsページへのリンクあり。各マニュアルページへはiframe内で遷移。

**権限による表示制御**：特になし。公開マニュアルとして認証不要でアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | EventDispatcher | 主機能 | マニュアルナビゲーションイベント管理 |

## 画面種別

マニュアル閲覧画面（学習用ドキュメント）

## URL/ルーティング

- ベースURL: `manual/index.html`
- 言語別ページ: `manual/index.html#{lang}/{chapter}/{page}`
- 例: `manual/index.html#en/fundamentals/fundamentals`
- 日本語例: `manual/index.html#ja/fundamentals/fundamentals`

### 対応言語
- en（英語）
- fr（フランス語）
- ru（ロシア語）
- ko（韓国語）
- zh（中国語）
- ja（日本語）

## 入出力項目

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| 言語選択 | 入力 | String | ドロップダウンで言語切り替え |
| 検索クエリ | 入力 | String | ページ名での検索 |
| チャプター選択 | 入力 | Click | ナビゲーションツリーでの選択 |
| URLハッシュ | 入力 | String | ページへの直接リンク |
| ナビゲーションツリー | 出力 | DOM | カテゴリ別のページリスト |
| マニュアルコンテンツ | 出力 | HTML (iframe) | 選択したページの表示 |

## 表示項目

| 表示項目 | 説明 |
|----------|------|
| ヘッダー | three.jsロゴ、docs/manual切り替え |
| 言語セレクター | ドロップダウンで言語選択 |
| 検索フィールド | リアルタイム検索入力 |
| ナビゲーションパネル | カテゴリ別ページリスト |
| コンテンツエリア（iframe） | 選択したマニュアルページの表示 |

### マニュアルカテゴリ（英語版の例）

- **Fundamentals**: 基礎概念（シーン、カメラ、レンダラー等）
- **Techniques**: 応用テクニック（シャドウ、テクスチャ、ポストプロセシング等）
- **Solutions**: 実践的ソリューション（パフォーマンス最適化、デバッグ等）
- **Tips**: ヒントとトリック

## イベント仕様

### 1-言語切り替え

**トリガー**: 言語セレクター変更
**処理内容**:
1. setLanguage(value) 関数呼び出し
2. createNavigation(list, language) でナビゲーション再構築
3. updateFilter() でフィルタ状態を維持
4. autoChangeUrlLanguage(language) でURLを更新

### 2-検索フィルタリング

**トリガー**: 検索フィールドへの入力
**処理内容**:
1. 入力値で正規表現を生成
2. pageProperties 内の全ページ名をマッチング
3. マッチしない項目を非表示（hidden class追加）
4. カテゴリ内全項目が非表示ならカテゴリも非表示
5. マッチ部分をボールド（`<b>`タグ）で表示
6. URLに検索クエリをパラメータとして追加

### 3-ページ選択

**トリガー**: ナビゲーション項目のクリック
**処理内容**:
1. createLink() 内でクリックイベントをキャプチャ
2. window.location.hash を更新
3. updateNavigation() で選択状態を更新
4. panel.classList.remove('open') でモバイルメニューを閉じる

### 4-ブラウザナビゲーション

**トリガー**: ブラウザの戻る/進むボタン
**処理内容**:
1. window.onpopstate イベントをリッスン
2. updateNavigation() でナビゲーション選択状態を更新
3. createNewIframe() でiframeコンテンツを更新

### 5-URL言語自動変更

**トリガー**: 言語セレクター変更
**処理内容**:
1. 現在のURLハッシュから言語部分を抽出
2. 新しい言語コードで置換
3. location.href を更新

## データベース更新仕様

該当なし（静的サイト）

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| 情報 | コンソールにASCIIアートロゴ | ページロード時 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| 存在しないページへのアクセス | 404ページ表示（iframe内） |
| 未翻訳ページへのアクセス | 英語版にフォールバック（または404） |
| 検索結果なし | 全項目非表示 |

## 備考

- ナビゲーション構造は list.json から動的に読み込み
- 言語別にコンテンツが分離（en/, fr/, ja/等のディレクトリ）
- コンソールにthree.jsのASCIIアートロゴを表示（イースターエッグ）
- window.THREEにthree.jsモジュールを公開（コンソールでの実験用）
- RTL言語（アラビア語）に対応（navigation.style.direction = 'rtl'）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ナビゲーション構造を定義するJSONデータを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | list.json | `manual/list.json` | 言語別のカテゴリ・ページ構造 |

**読解のコツ**: list.jsonは `{ "en": { "Category": { "PageName": "path" } }, "ja": {...} }` 形式。各言語で異なるカテゴリ・ページセットを持つ可能性あり。

#### Step 2: エントリーポイントを理解する

ページ初期化とイベント処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | manual/index.html | `manual/index.html` | init()関数とイベントリスナー設定 |

**主要処理フロー**:
1. **71-73行目**: list.jsonをfetchで読み込み
2. **75-87行目**: URLハッシュから言語を抽出
3. **89-95行目**: 言語セレクターのイベント設定
4. **97-105行目**: setLanguage()関数でナビゲーション再構築
5. **109-121行目**: expandButton（ハンバーガーメニュー）のイベント
6. **126-154行目**: filterInputのフォーカス・入力イベント
7. **156-163行目**: window.onpopstateでブラウザナビゲーション対応
8. **167-168行目**: 初期ナビゲーション作成とiframe設定

#### Step 3: ナビゲーション生成を理解する

createNavigation関数とリンク生成を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | manual/index.html | `manual/index.html` | createNavigation関数（209-297行目） |

**主要処理フロー**:
- **219-226行目**: RTL言語対応
- **228-294行目**: カテゴリとページのDOM生成
- **279-283行目**: pagePropertiesにページ情報を格納
- **287行目**: titlesにURLとページ名のマッピング格納
- **292行目**: categoryElementsに参照を格納

### プログラム呼び出し階層図

```
manual/index.html
    │
    ├─ init()
    │      │
    │      ├─ fetch('list.json')
    │      │      └─ 言語別ナビゲーション構造取得
    │      │
    │      ├─ languageSelect.addEventListener('change')
    │      │      └─ setLanguage()
    │      │             ├─ createNavigation(list, language)
    │      │             ├─ updateFilter()
    │      │             └─ autoChangeUrlLanguage()
    │      │
    │      ├─ expandButton.onclick
    │      │      └─ panel.classList.toggle('open')
    │      │
    │      ├─ filterInput.oninput
    │      │      └─ updateFilter()
    │      │
    │      ├─ window.onpopstate
    │      │      ├─ updateNavigation()
    │      │      └─ createNewIframe()
    │      │
    │      └─ createNavigation() + createNewIframe()
    │
    └─ createLink(pageName, pageURL)
           └─ link.addEventListener('click')
                  ├─ window.location.hash = pageURL
                  └─ updateNavigation()
```

### データフロー図

```
[入力]                     [処理]                         [出力]

list.json ───────────▶ fetch() ─────────────────────▶ navigation構造
                             │
                             └─ list[language]取得

言語セレクター ──────▶ setLanguage() ──────────────────▶ ナビゲーション再構築
                             │
                             ├─ createNavigation()
                             └─ autoChangeUrlLanguage()
                                      │
                                      └─ location.href更新

検索クエリ ──────────▶ updateFilter() ────────────────▶ 表示/非表示
                             │
                             ├─ RegExp.test()
                             └─ innerHTML更新（ボールド）

URLハッシュ ─────────▶ createNewIframe() ─────────────▶ iframe.src
      #ja/fundamentals/fundamentals
                             │
                             └─ 'ja/fundamentals/fundamentals.html'
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `manual/index.html` | ソース | マニュアルトップページ |
| list.json | `manual/list.json` | データ | ナビゲーション構造定義 |
| main.css | `files/main.css` | スタイル | 共通スタイル |
| three.module.js | `build/three.module.js` | ライブラリ | コンソール用THREE公開 |
| en/**/*.html | `manual/en/**/*.html` | コンテンツ | 英語マニュアルページ |
| ja/**/*.html | `manual/ja/**/*.html` | コンテンツ | 日本語マニュアルページ |
| fr/**/*.html | `manual/fr/**/*.html` | コンテンツ | フランス語マニュアルページ |
| ru/**/*.html | `manual/ru/**/*.html` | コンテンツ | ロシア語マニュアルページ |
| ko/**/*.html | `manual/ko/**/*.html` | コンテンツ | 韓国語マニュアルページ |
| zh/**/*.html | `manual/zh/**/*.html` | コンテンツ | 中国語マニュアルページ |
