# 画面設計書 4-Sidebar - Object

## 概要

three.js EditorのSidebar - Objectパネルの設計書。本ドキュメントでは、選択オブジェクトのプロパティ（位置、回転、スケール、表示/非表示など）を編集する機能について詳細に記述する。

### 本画面の処理概要

Sidebar - Objectパネルは、現在選択されているオブジェクトの基本プロパティを表示・編集するための画面である。Object3Dの共通プロパティ（変形、表示設定など）に加えて、オブジェクトタイプに応じた専用プロパティ（カメラのFOV、ライトの強度・色など）も動的に表示する。

**業務上の目的・背景**：3Dオブジェクトの編集において、位置・回転・スケールなどの基本変形パラメータを数値で正確に指定することは、視覚的な操作と併せて不可欠である。本パネルにより、ユーザーはTransformControlsによるドラッグ操作だけでなく、数値入力による精密な調整が可能となる。

**画面へのアクセス方法**：Viewportまたは OutlinerでScene/Camera以外のオブジェクトを選択すると自動的に表示される。オブジェクト未選択時は非表示。

**主要な操作・処理内容**：
1. 位置（Position）のX/Y/Z座標編集
2. 回転（Rotation）のX/Y/Z角度編集（度単位）
3. スケール（Scale）のX/Y/Z値編集
4. UUID、名前の表示・編集
5. カメラ固有プロパティ（FOV、Near、Far等）の編集
6. ライト固有プロパティ（Color、Intensity、Distance等）の編集
7. シャドウ設定（Cast/Receive、Bias等）の編集
8. 表示/非表示、フラスタムカリング、レンダリング順序の編集
9. UserDataのJSON編集
10. オブジェクトのJSONエクスポート
11. アニメーション管理

**画面遷移**：選択オブジェクトの変更により内容が更新される。オブジェクト解除時はパネルが非表示になる。

**権限による表示制御**：権限による制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Object3D | 主機能 | 選択オブジェクトの位置・回転・スケール編集 |
| 123 | Vector2 | 補助機能 | 2D座標値の編集 |
| 124 | Vector3 | 補助機能 | 3D位置・スケール値の編集 |
| 128 | Quaternion | 補助機能 | 回転値の内部管理 |
| 129 | Euler | 補助機能 | オイラー角での回転表示・編集 |
| 110 | AnimationMixer | 補助機能 | オブジェクトアニメーションの管理 |

## 画面種別

プロパティエディタ / 詳細パネル

## URL/ルーティング

URLルーティングなし（エディタ内コンポーネント）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 説明 |
|--------|----------|----------|------|
| Type | 出力 | String | オブジェクトタイプ |
| UUID | 入出力 | String | 一意識別子 |
| Name | 入力 | String | オブジェクト名 |
| Position X/Y/Z | 入力 | Number | 位置座標（精度3桁） |
| Rotation X/Y/Z | 入力 | Number | 回転角度（度単位） |
| Scale X/Y/Z | 入力 | Number | スケール値（精度3桁） |
| FOV | 入力 | Number | カメラ視野角 |
| Left/Right/Top/Bottom | 入力 | Number | 正射影カメラ境界 |
| Near/Far | 入力 | Number | カメラクリッピング距離 |
| Intensity | 入力 | Number | ライト強度 |
| Color | 入力 | Hex Color | ライト/マテリアル色 |
| Ground Color | 入力 | Hex Color | HemisphereLight地面色 |
| Distance | 入力 | Number | PointLight/SpotLight減衰距離 |
| Angle | 入力 | Number | SpotLight照射角 |
| Penumbra | 入力 | Number | SpotLight半影 |
| Decay | 入力 | Number | ライト減衰係数 |
| Cast Shadow | 入力 | Boolean | シャドウ投影 |
| Receive Shadow | 入力 | Boolean | シャドウ受け |
| Shadow Intensity/Bias/NormalBias/Radius | 入力 | Number | シャドウ詳細設定 |
| Visible | 入力 | Boolean | 表示/非表示 |
| Frustum Culled | 入力 | Boolean | フラスタムカリング |
| Render Order | 入力 | Integer | レンダリング順序 |
| User Data | 入力 | JSON | カスタムデータ |

## 表示項目

| 要素 | 表示内容 | 説明 |
|------|----------|------|
| Type | オブジェクトタイプ | Mesh、Light、Camera等 |
| UUID | UUID + 再生成ボタン | 一意識別子の表示と更新 |
| Name | 名前入力フィールド | オブジェクト名 |
| Position | X/Y/Z数値入力 | 位置座標 |
| Rotation | X/Y/Z数値入力（度） | 回転角度 |
| Scale | X/Y/Z数値入力 | スケール値 |
| カメラ設定 | FOV/Near/Far等 | カメラ選択時のみ表示 |
| ライト設定 | Color/Intensity等 | ライト選択時のみ表示 |
| Shadow | Cast/Receive等 | シャドウ対応オブジェクト選択時 |
| Visible | チェックボックス | 表示制御 |
| User Data | テキストエリア | JSONデータ |
| Export | ボタン | JSONエクスポート |
| Animation | アニメーション管理UI | アニメーション付きオブジェクト選択時 |

## イベント仕様

### 1-プロパティ値変更

数値入力やチェックボックスの変更処理。

1. UI要素のonChangeイベント発火（行115-117, 127-129, 139-141等）
2. `update()`関数が呼び出される（行436-638）
3. 現在値と新しい値を比較（閾値0.01）
4. 変更があればSetPositionCommand/SetRotationCommand/SetScaleCommand/SetValueCommand等を実行
5. `editor.execute()`でHistoryに登録
6. シグナル経由でViewportが更新

### 2-UUID再生成

UUIDの再生成ボタン押下処理。

1. 「New」ボタンをクリック（行84-90）
2. `THREE.MathUtils.generateUUID()`で新UUIDを生成
3. `SetUuidCommand`を実行

### 3-名前変更

オブジェクト名の変更処理。

1. 名前入力フィールドを編集（行100-105）
2. `SetValueCommand`で`name`プロパティを更新
3. Outlinerの表示が更新される

### 4-UserData編集

カスタムデータのJSON編集処理。

1. テキストエリアを編集（行379-396）
2. `onKeyUp`でJSON構文を検証し、成功/失敗のCSSクラスを適用
3. `onChange`でJSON.parseを実行
4. パース成功時に`SetValueCommand`で`userData`を更新

### 5-JSONエクスポート

オブジェクトのJSONエクスポート処理。

1. 「Export」ボタンをクリック（行405-428）
2. `object.toJSON()`でオブジェクトをシリアライズ
3. JSON.stringifyで整形
4. `editor.utils.save()`でダウンロード

### 6-オブジェクト選択変更時の表示更新

選択オブジェクト変更時のUI更新処理。

1. `signals.objectSelected`を受信（行716-731）
2. `updateRows(object)`でオブジェクトタイプに応じた行の表示/非表示を設定（行640-696）
3. `updateUI(object)`で各フィールドに現在値を設定（行749-892）

## データベース更新仕様

### 操作別データベース影響一覧

Sidebar - Object単体でのデータベース操作はない。プロパティ変更はCommandパターンでHistoryに記録され、自動保存機能によりIndexedDBに永続化される。

## メッセージ仕様

メッセージ表示はない。UserDataのJSON構文エラーはCSSクラスによる視覚フィードバックで表示。

## 例外処理

| 状況 | 処理 |
|------|------|
| UserData JSONパースエラー | console.warnでログ出力、変更を適用しない |
| JSONエクスポート失敗 | JSON.stringifyのフォールバック処理 |

## 備考

- 回転値はラジアンで内部管理され、UI上では度単位で表示・入力される
- 変更閾値0.01により、微小な変更は無視される（ノイズ防止）
- ライトオブジェクト選択時は回転行・スケール行が非表示になる
- AmbientLight・HemisphereLight選択時はシャドウ行が非表示になる
- SidebarObjectAnimationコンポーネントがアニメーション管理機能を提供

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

編集対象となるObject3Dのプロパティ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Sidebar.Object.js | `editor/js/Sidebar.Object.js` | 各UIフィールドの定義（行72-401） |
| 1-2 | three.js | `src/core/Object3D.js` | Object3Dの基本プロパティ |

**読解のコツ**: THREE.jsのObject3D、Camera、Lightの継承関係を理解すると、動的な行表示の仕組みが把握しやすい。

#### Step 2: エントリーポイントを理解する

SidebarObjectの初期化を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Sidebar.js | `editor/js/Sidebar.js` | SidebarObjectの生成と追加 |
| 2-2 | Sidebar.Object.js | `editor/js/Sidebar.Object.js` | 行16のSidebarObject関数開始 |

**主要処理フロー**:
1. **行22-25**: UIPanel作成、初期非表示設定
2. **行72-401**: 各プロパティ行のUI構築
3. **行432**: SidebarObjectAnimationの追加
4. **行436-638**: update関数定義（値変更処理）
5. **行640-696**: updateRows関数定義（行表示制御）
6. **行716-747**: シグナルハンドラ登録
7. **行749-892**: updateUI関数定義（値表示更新）

#### Step 3: 値変更処理を理解する

update関数内の処理フローを追跡。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Sidebar.Object.js | `editor/js/Sidebar.Object.js` | 行436-638のupdate関数 |
| 3-2 | commands/*.js | `editor/js/commands/` | 各種Commandクラス |

**主要処理フロー**:
- **行442-461**: Position変更処理
- **行449-453**: SetPositionCommand実行
- **行455-461**: Rotation変更処理
- **行462-467**: SetRotationCommand実行

#### Step 4: 動的表示制御を理解する

オブジェクトタイプに応じた行表示制御を追跡。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Sidebar.Object.js | `editor/js/Sidebar.Object.js` | 行640-696のupdateRows関数 |

### プログラム呼び出し階層図

```
Sidebar.Object.js
    │
    ├─ UIPanel (container)
    │
    ├─ Basic Properties
    │      ├─ UIText (objectType)
    │      ├─ UIInput (objectUUID) + UIButton (renew)
    │      ├─ UIInput (objectName)
    │      ├─ UINumber x3 (objectPosition X/Y/Z)
    │      ├─ UINumber x3 (objectRotation X/Y/Z)
    │      └─ UINumber x3 (objectScale X/Y/Z)
    │
    ├─ Camera Properties
    │      ├─ UINumber (objectFov)
    │      ├─ UINumber (objectLeft/Right/Top/Bottom)
    │      └─ UINumber (objectNear/Far)
    │
    ├─ Light Properties
    │      ├─ UINumber (objectIntensity)
    │      ├─ UIColor (objectColor)
    │      ├─ UIColor (objectGroundColor)
    │      ├─ UINumber (objectDistance/Angle/Penumbra/Decay)
    │      └─ Shadow Settings
    │
    ├─ Common Properties
    │      ├─ UICheckbox (objectVisible)
    │      ├─ UICheckbox (objectFrustumCulled)
    │      ├─ UIInteger (objectRenderOrder)
    │      └─ UITextArea (objectUserData)
    │
    ├─ UIButton (exportJson)
    │
    └─ SidebarObjectAnimation

Commands:
    ├─ SetUuidCommand
    ├─ SetValueCommand
    ├─ SetPositionCommand
    ├─ SetRotationCommand
    ├─ SetScaleCommand
    ├─ SetColorCommand
    └─ SetShadowValueCommand
```

### データフロー図

```
[入力]               [処理]                    [出力]

数値入力 ─────────▶ update() ───────────────▶ SetPositionCommand
                         │                     SetRotationCommand
                         │                     SetScaleCommand
                         ▼
                    editor.execute()
                         │
                         ▼
                    History登録
                         │
                         ▼
                    signals.objectChanged
                         │
                         ▼
                    Viewport再描画

選択変更 ─────────▶ signals.objectSelected ─▶ updateRows()
                                               updateUI()
                                                  │
                                                  ▼
                                            UI表示更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Sidebar.Object.js | `editor/js/Sidebar.Object.js` | ソース | Objectパネルメインコンポーネント |
| Sidebar.Object.Animation.js | `editor/js/Sidebar.Object.Animation.js` | ソース | アニメーション管理 |
| SetUuidCommand.js | `editor/js/commands/SetUuidCommand.js` | ソース | UUID変更コマンド |
| SetValueCommand.js | `editor/js/commands/SetValueCommand.js` | ソース | 汎用値変更コマンド |
| SetPositionCommand.js | `editor/js/commands/SetPositionCommand.js` | ソース | 位置変更コマンド |
| SetRotationCommand.js | `editor/js/commands/SetRotationCommand.js` | ソース | 回転変更コマンド |
| SetScaleCommand.js | `editor/js/commands/SetScaleCommand.js` | ソース | スケール変更コマンド |
| SetColorCommand.js | `editor/js/commands/SetColorCommand.js` | ソース | 色変更コマンド |
| SetShadowValueCommand.js | `editor/js/commands/SetShadowValueCommand.js` | ソース | シャドウ設定変更コマンド |
| ui.js | `editor/js/libs/ui.js` | ライブラリ | 基本UIコンポーネント |
| ui.three.js | `editor/js/libs/ui.three.js` | ライブラリ | UIBoolean等 |
