# 画面設計書 40-ユニットテスト

## 概要

本ドキュメントは、three.jsライブラリのユニットテストランナー（test/unit/UnitTests.html）の設計書である。QUnitテストフレームワークを使用して、three.jsのソースコード品質を検証するための自動テスト環境を提供する。

### 本画面の処理概要

このページは、three.jsの各クラス・モジュールに対するユニットテストを実行し、結果を表示する。three.source.unit.jsにて定義された約290のテストモジュールをImport Map経由でインポートし、QUnitフレームワークで実行する。

**業務上の目的・背景**：three.jsは大規模な3Dグラフィックスライブラリであり、コード変更時のリグレッション検出が不可欠である。本ユニットテストランナーは、アニメーション、オーディオ、カメラ、コア、ジオメトリ、ヘルパー、ライト、ローダー、マテリアル、数学ライブラリ、オブジェクト、レンダラー、シーン、テクスチャの各カテゴリに対するテストを網羅的に実行し、ライブラリの品質を保証する。

**画面へのアクセス方法**：test/unit/UnitTests.htmlをブラウザで直接開くか、テストサーバーでアクセス。

**主要な操作・処理内容**：
1. QUnitテストフレームワークの初期化
2. Import Mapによるthree.jsモジュールのマッピング
3. three.source.unit.jsのインポート
4. 各カテゴリのテストモジュールの読み込み
5. テスト実行と結果表示
6. 成功/失敗のカウント表示

**画面遷移**：単一ページアプリケーション。テスト結果ページ内で完結。

**権限による表示制御**：特になし。開発者向けツールとして認証不要でアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Object3D | 主機能 | Object3Dクラスのテスト |
| 2 | BufferGeometry | 主機能 | BufferGeometryクラスのテスト |
| 124 | Vector3 | 主機能 | Vector3クラスのテスト |
| 127 | Matrix4 | 主機能 | Matrix4クラスのテスト |

## 画面種別

開発者向けテストランナー画面

## URL/ルーティング

- ベースURL: `test/unit/UnitTests.html`
- パスパラメータなし

## 入出力項目

| 項目名 | 入出力 | データ型 | 説明 |
|--------|--------|----------|------|
| テストモジュール | 入力 | ES Module | three.source.unit.js経由でインポート |
| three.jsライブラリ | 入力 | ES Module | Import Mapでbuild/three.module.jsをマッピング |
| テスト結果 | 出力 | HTML/DOM | QUnitが生成するテスト結果表示 |
| テスト統計 | 出力 | Number | 成功/失敗/スキップ数 |

## 表示項目

| 表示項目 | 説明 |
|----------|------|
| QUnitヘッダー | タイトル、テスト統計サマリー |
| テストスイート一覧 | カテゴリ別のテストグループ |
| テストケース結果 | 各テストの成功/失敗/エラー |
| 詳細ログ | 失敗時のアサーション詳細 |
| フィルター入力 | テスト名でのフィルタリング |

### テストカテゴリ一覧

three.source.unit.jsでインポートされるテストカテゴリ：

- **src/constants.tests.js** - 定数テスト
- **src/utils.tests.js** - ユーティリティテスト
- **src/animation/** - アニメーション関連テスト（8ファイル）
- **src/animation/tracks/** - キーフレームトラックテスト（6ファイル）
- **src/audio/** - オーディオ関連テスト（5ファイル）
- **src/cameras/** - カメラ関連テスト（6ファイル）
- **src/core/** - コア機能テスト（15ファイル）
- **src/extras/** - エクストラ機能テスト（5ファイル）
- **src/extras/core/** - Curve/Path関連テスト（6ファイル）
- **src/extras/curves/** - Curve派生クラステスト（10ファイル）
- **src/geometries/** - ジオメトリテスト（21ファイル）
- **src/helpers/** - ヘルパークラステスト（13ファイル）
- **src/lights/** - ライト関連テスト（12ファイル）
- **src/loaders/** - ローダー関連テスト（17ファイル）
- **src/materials/** - マテリアル関連テスト（19ファイル）
- **src/math/** - 数学ライブラリテスト（23ファイル）
- **src/math/interpolants/** - 補間関数テスト（4ファイル）
- **src/objects/** - オブジェクト関連テスト（13ファイル）
- **src/renderers/** - レンダラーテスト（5ファイル）
- **src/renderers/shaders/** - シェーダー関連テスト（4ファイル）
- **src/renderers/webgl/** - WebGL内部テスト（21ファイル）
- **src/renderers/webgpu/nodes/** - WebGPUノードテスト（1ファイル）
- **src/nodes/accessors/** - ノードアクセサテスト（1ファイル）
- **src/scenes/** - シーン関連テスト（3ファイル）
- **src/textures/** - テクスチャ関連テスト（12ファイル）

## イベント仕様

### 1-ページロード

**トリガー**: DOMContentLoaded / モジュール実行
**処理内容**:
1. QUnit初期化（qunit.js読み込み）
2. Import Mapでthree -> build/three.module.jsをマッピング
3. three.source.unit.jsのmoduleロード
4. console-wrapper.jsとqunit-utils.jsのインポート
5. 各テストファイルの順次インポート
6. QUnitによるテスト自動実行開始

### 2-テスト実行

**トリガー**: QUnit自動開始
**処理内容**:
1. QUnit.module()で定義されたテストスイートを順次実行
2. QUnit.test()で定義された各テストケースを実行
3. 成功/失敗をDOMに反映
4. 統計情報の更新

### 3-フィルタリング

**トリガー**: フィルター入力欄への入力
**処理内容**:
1. QUnit組み込みのフィルター機能
2. 入力文字列でテスト名をマッチング
3. 該当テストのみ再実行

### 4-テスト再実行

**トリガー**: 個別テストのRerunボタンクリック
**処理内容**:
1. 該当テストのみを再実行
2. 結果を更新

## データベース更新仕様

該当なし（クライアントサイドのみで動作）

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| 成功 | テストパス数/総数 | テスト完了時 |
| 失敗 | アサーション失敗詳細 | テスト失敗時 |
| エラー | 例外スタックトレース | テスト実行エラー時 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| モジュール読み込みエラー | QUnitがエラーとして報告 |
| アサーション失敗 | 詳細情報と期待値/実際値を表示 |
| 例外発生 | スタックトレースを表示 |

## 備考

- QUnit 2.x テストフレームワークを使用
- Import Mapでthreeモジュールをbuild/three.module.jsにマッピング
- console-wrapper.jsでconsole出力をテスト用に調整
- qunit-utils.jsでthree.js固有のテストユーティリティを提供
- テストファイル総数: 約210ファイル
- ブラウザ環境でのテスト実行（Node.jsでの実行は別途設定が必要）
- WebGPU関連のテストも含む（WGSLNodeBuilder.tests.js等）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テストランナーのHTMLとImport Mapの構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UnitTests.html | `test/unit/UnitTests.html` | QUnit読み込みとImport Map定義 |

**読解のコツ**: Import Mapでthreeをbuild/three.module.jsにマッピング。これによりテストコード内でimport * as THREE from 'three'が使用可能になる。

#### Step 2: エントリーポイントを理解する

テストインポートの構成を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | three.source.unit.js | `test/unit/three.source.unit.js` | テストモジュールのインポート一覧 |
| 2-2 | console-wrapper.js | `test/unit/utils/console-wrapper.js` | コンソールラッパー |
| 2-3 | qunit-utils.js | `test/unit/utils/qunit-utils.js` | QUnitユーティリティ |

**主要処理フロー**:
1. **1行目**: console-wrapper.jsをインポート
2. **2行目**: qunit-utils.jsをインポート
3. **5-6行目**: 基本テスト（constants, utils）をインポート
4. **9-17行目**: animation関連テストをインポート
5. **19-25行目**: animation/tracks関連テストをインポート
6. **28-33行目**: audio関連テストをインポート
7. **36-42行目**: cameras関連テストをインポート
8. **45-60行目**: core関連テストをインポート
9. **63-76行目**: extras関連テストをインポート
10. **78-88行目**: extras/curves関連テストをインポート
11. **90-111行目**: geometries関連テストをインポート
12. **114-127行目**: helpers関連テストをインポート
13. **130-142行目**: lights関連テストをインポート
14. **145-161行目**: loaders関連テストをインポート
15. **164-182行目**: materials関連テストをインポート
16. **185-213行目**: math関連テストをインポート
17. **216-229行目**: objects関連テストをインポート
18. **232-266行目**: renderers関連テストをインポート
19. **268-272行目**: webgpu/nodes関連テストをインポート
20. **275-278行目**: scenes関連テストをインポート
21. **281-293行目**: textures関連テストをインポート

#### Step 3: 個別テストの構造を理解する

代表的なテストファイルの構造を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Object3D.tests.js | `test/unit/src/core/Object3D.tests.js` | Object3Dテストの例 |
| 3-2 | Vector3.tests.js | `test/unit/src/math/Vector3.tests.js` | Vector3テストの例 |
| 3-3 | BufferGeometry.tests.js | `test/unit/src/core/BufferGeometry.tests.js` | BufferGeometryテストの例 |

**典型的なテスト構造**:
```javascript
QUnit.module('ClassName', () => {
    QUnit.test('constructor', (assert) => {
        // コンストラクタのテスト
    });
    QUnit.test('methodName', (assert) => {
        // メソッドのテスト
    });
});
```

### プログラム呼び出し階層図

```
test/unit/UnitTests.html
    │
    ├─ <link> node_modules/qunit/qunit/qunit.css
    │      └─ QUnitスタイルシート
    │
    ├─ <script> node_modules/qunit/qunit/qunit.js
    │      └─ QUnitフレームワーク初期化
    │
    ├─ Import Map定義
    │      └─ "three" -> "../../build/three.module.js"
    │
    └─ <script type="module"> three.source.unit.js
           │
           ├─ import './utils/console-wrapper.js'
           │      └─ console出力のラッピング
           │
           ├─ import './utils/qunit-utils.js'
           │      └─ テストユーティリティ関数
           │
           └─ import './src/**/*.tests.js' (約210ファイル)
                  │
                  ├─ animation/*.tests.js (8ファイル)
                  ├─ audio/*.tests.js (5ファイル)
                  ├─ cameras/*.tests.js (6ファイル)
                  ├─ core/*.tests.js (15ファイル)
                  ├─ extras/*.tests.js (21ファイル)
                  ├─ geometries/*.tests.js (21ファイル)
                  ├─ helpers/*.tests.js (13ファイル)
                  ├─ lights/*.tests.js (12ファイル)
                  ├─ loaders/*.tests.js (17ファイル)
                  ├─ materials/*.tests.js (19ファイル)
                  ├─ math/*.tests.js (27ファイル)
                  ├─ objects/*.tests.js (13ファイル)
                  ├─ renderers/*.tests.js (30ファイル)
                  ├─ nodes/*.tests.js (1ファイル)
                  ├─ scenes/*.tests.js (3ファイル)
                  └─ textures/*.tests.js (12ファイル)
```

### データフロー図

```
[入力]                     [処理]                         [出力]

qunit.js ────────────────▶ QUnit初期化 ─────────────────▶ テストフレームワーク準備
                                │
                                └─ QUnit.config設定

Import Map ─────────────▶ モジュール解決 ────────────────▶ three.module.js読み込み
    "three"                      │
                                └─ build/three.module.js

three.source.unit.js ──▶ テストモジュールインポート ────▶ QUnit.module()登録
                                │
                                └─ 約210テストファイル

QUnit.start() ─────────▶ テスト実行ループ ───────────────▶ DOM更新
                                │
                                ├─ QUnit.module()
                                │      └─ テストスイート
                                │
                                └─ QUnit.test()
                                       ├─ assert.ok()
                                       ├─ assert.equal()
                                       ├─ assert.deepEqual()
                                       └─ assert.strictEqual()

フィルター入力 ────────▶ QUnit.filter() ─────────────────▶ 該当テストのみ実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UnitTests.html | `test/unit/UnitTests.html` | HTMLテンプレート | テストランナーのエントリーポイント |
| three.source.unit.js | `test/unit/three.source.unit.js` | ES Module | テストインポートの集約 |
| console-wrapper.js | `test/unit/utils/console-wrapper.js` | ユーティリティ | コンソール出力のラッピング |
| qunit-utils.js | `test/unit/utils/qunit-utils.js` | ユーティリティ | three.js用テストヘルパー |
| qunit.js | `node_modules/qunit/qunit/qunit.js` | ライブラリ | QUnitテストフレームワーク |
| qunit.css | `node_modules/qunit/qunit/qunit.css` | スタイル | QUnit結果表示スタイル |
| three.module.js | `build/three.module.js` | ライブラリ | テスト対象のthree.js本体 |
| *.tests.js | `test/unit/src/**/*.tests.js` | テスト | 各クラス・モジュールのテスト（約210ファイル） |
