# 画面設計書 5-Sidebar - Geometry

## 概要

three.js EditorのSidebar - Geometryパネルの設計書。本ドキュメントでは、選択オブジェクトのジオメトリパラメータを編集する機能について詳細に記述する。

### 本画面の処理概要

Sidebar - Geometryパネルは、現在選択されているメッシュオブジェクトのジオメトリ情報を表示・編集するための画面である。ジオメトリタイプに応じたパラメータエディタを動的に読み込み、各種プリミティブ（Box、Sphere、Cylinder等）の寸法やセグメント数を調整できる。また、モーフターゲットの操作も本パネルで行う。

**業務上の目的・背景**：プリミティブジオメトリの編集において、寸法やセグメント数を視覚的に確認しながら調整することは、モデリング作業の効率化に不可欠である。本パネルにより、ユーザーはジオメトリパラメータを数値で直接指定し、即座に結果を確認できる。

**画面へのアクセス方法**：Viewportまたは Outlinerでジオメトリを持つオブジェクト（Mesh等）を選択すると自動的に表示される。ジオメトリを持たないオブジェクト選択時は非表示。

**主要な操作・処理内容**：
1. ジオメトリタイプの確認
2. UUID、名前の表示・編集
3. ジオメトリタイプ固有のパラメータ編集（幅、高さ、セグメント数等）
4. BufferGeometryの属性情報表示
5. バウンディングボックスサイズの確認
6. 頂点法線ヘルパーの表示/非表示
7. UserDataのJSON編集
8. ジオメトリのJSONエクスポート
9. モーフターゲットのウェイト調整

**画面遷移**：選択オブジェクトの変更により内容が更新される。ジオメトリなしオブジェクト選択時はパネルが非表示になる。

**権限による表示制御**：権限による制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | BufferGeometry | 主機能 | 選択オブジェクトのジオメトリ情報表示・編集 |
| 27 | BoxGeometry | 補助機能 | 直方体パラメータの編集 |
| 28 | SphereGeometry | 補助機能 | 球体パラメータの編集 |
| 30 | CylinderGeometry | 補助機能 | 円柱パラメータの編集 |
| 32 | TorusGeometry | 補助機能 | トーラスパラメータの編集 |
| 29 | PlaneGeometry | 補助機能 | 平面パラメータの編集 |

## 画面種別

プロパティエディタ / 詳細パネル

## URL/ルーティング

URLルーティングなし（エディタ内コンポーネント）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 説明 |
|--------|----------|----------|------|
| Type | 出力 | String | ジオメトリタイプ |
| UUID | 入出力 | String | 一意識別子 |
| Name | 入力 | String | ジオメトリ名 |
| パラメータ（タイプ別） | 入力 | Number | 幅、高さ、半径、セグメント数等 |
| Bounds | 出力 | String | バウンディングボックスサイズ（X/Y/Z） |
| User Data | 入力 | JSON | カスタムデータ |
| Morph Targets | 入力 | Number (0-1) | モーフターゲットウェイト |

## 表示項目

| 要素 | 表示内容 | 説明 |
|------|----------|------|
| Type | ジオメトリタイプ | BoxGeometry等 |
| UUID | UUID + 再生成ボタン | 一意識別子の表示と更新 |
| Name | 名前入力フィールド | ジオメトリ名 |
| Parameters | タイプ別パラメータUI | 動的読み込み |
| BufferGeometry Info | 属性情報 | 位置、法線、UV等 |
| Bounds | X/Y/Zサイズ表示 | バウンディングボックス |
| Show Vertex Normals | ボタン | 法線ヘルパー表示 |
| User Data | テキストエリア | JSONデータ |
| Export | ボタン | JSONエクスポート |
| Morph Targets | 名前 + スライダー | モーフターゲット操作 |

## イベント仕様

### 1-ジオメトリパラメータ変更

パラメータ変更時の処理。

1. 各パラメータUIのonChangeイベント発火
2. ジオメトリタイプ別パネル（Sidebar.Geometry.{Type}.js）内で処理
3. 新しいジオメトリを生成してSetGeometryCommandを実行
4. `signals.geometryChanged`が発火
5. Viewportが再描画

### 2-UUID再生成

UUIDの再生成ボタン押下処理。

1. 「New」ボタンをクリック（行102-108）
2. `THREE.MathUtils.generateUUID()`で新UUIDを生成
3. `SetGeometryValueCommand`を実行

### 3-頂点法線ヘルパー表示

頂点法線の可視化処理。

1. 「Show Vertex Normals」ボタンをクリック（行200-218）
2. ヘルパーが未作成なら`VertexNormalsHelper`を生成し`editor.addHelper()`
3. 既存なら`editor.removeHelper()`で削除（トグル動作）
4. `signals.sceneGraphChanged`を発火

### 4-モーフターゲット操作

モーフターゲットウェイト変更処理。

1. モーフターゲットの数値入力を変更（行363-368）
2. `morphTargetInfluences[index]`を更新
3. `signals.objectChanged`を発火

### 5-オブジェクト選択変更時の表示更新

選択オブジェクト変更時のUI更新処理。

1. `signals.objectSelected`を受信（行396-402）
2. `currentGeometryType`をリセット
3. `build()`関数を呼び出し（行263-352）
4. ジオメトリタイプが変更されていれば、動的に`Sidebar.Geometry.{Type}.js`をimport
5. パラメータUIを再構築

### 6-ジオメトリ変更時の再構築

geometryChangedシグナル受信時の処理。

1. `signals.geometryChanged`を受信（行404）
2. `build()`関数を呼び出し
3. バウンディングボックスを再計算
4. パラメータUIを更新

## データベース更新仕様

### 操作別データベース影響一覧

Sidebar - Geometry単体でのデータベース操作はない。パラメータ変更はCommandパターンでHistoryに記録され、自動保存機能によりIndexedDBに永続化される。

## メッセージ仕様

メッセージ表示はない。UserDataのJSON構文エラーはCSSクラスによる視覚フィードバックで表示。

## 例外処理

| 状況 | 処理 |
|------|------|
| UserData JSONパースエラー | console.warnでログ出力、変更を適用しない |
| 動的importエラー | ジオメトリタイプ別パネルが表示されない |

## 備考

- ジオメトリタイプ別のパラメータパネルは動的にimportされる（行290）
- BufferGeometryまたはInstancedBufferGeometryの場合はSidebarGeometryModifiersが表示される
- バウンディングボックスはgeometry.computeBoundingBox()で計算される
- 頂点法線ヘルパーは法線属性を持つジオメトリでのみ表示される
- モーフターゲットセクションはmorphTargetInfluencesを持つオブジェクトでのみ表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ジオメトリの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Sidebar.Geometry.js | `editor/js/Sidebar.Geometry.js` | 行23のcurrentGeometryType、行132のparametersコンテナ |
| 1-2 | BufferGeometry | `src/core/BufferGeometry.js` | BufferGeometryの基本構造 |

#### Step 2: エントリーポイントを理解する

SidebarGeometryの初期化を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Sidebar.Geometry.js | `editor/js/Sidebar.Geometry.js` | 行12のSidebarGeometry関数開始 |

**主要処理フロー**:
1. **行18-21**: UIPanel作成、初期非表示設定
2. **行90-114**: Type、UUID、Name行の構築
3. **行132-133**: parametersコンテナ（動的読み込み先）
4. **行137**: SidebarGeometryBufferGeometryの追加
5. **行141-146**: Bounds表示行
6. **行150-193**: UserData行
7. **行197-218**: 頂点法線ヘルパーボタン
8. **行222-245**: Exportボタン
9. **行249-260**: モーフターゲットセクション
10. **行263-352**: build関数（メイン構築処理）

#### Step 3: 動的パラメータパネル読み込みを理解する

ジオメトリタイプ別パネルの読み込みを追跡。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Sidebar.Geometry.js | `editor/js/Sidebar.Geometry.js` | 行280-298のif分岐とdynamic import |
| 3-2 | Sidebar.Geometry.BoxGeometry.js | `editor/js/Sidebar.Geometry.BoxGeometry.js` | パラメータパネルの例 |

### プログラム呼び出し階層図

```
Sidebar.Geometry.js
    │
    ├─ UIPanel (container)
    │
    ├─ Basic Info
    │      ├─ UIText (geometryType)
    │      ├─ UIInput (geometryUUID) + UIButton (renew)
    │      └─ UIInput (geometryName)
    │
    ├─ UISpan (parameters) ← 動的読み込み先
    │      └─ Sidebar.Geometry.{Type}.js (dynamic import)
    │             ├─ Sidebar.Geometry.BoxGeometry.js
    │             ├─ Sidebar.Geometry.SphereGeometry.js
    │             ├─ Sidebar.Geometry.CylinderGeometry.js
    │             └─ etc.
    │
    ├─ SidebarGeometryBufferGeometry
    │
    ├─ Bounds Display
    │      └─ UIText (geometryBoundingBox)
    │
    ├─ Helpers
    │      └─ UIButton (vertexNormalsButton)
    │             └─ VertexNormalsHelper
    │
    ├─ UITextArea (geometryUserData)
    │
    ├─ UIButton (exportJson)
    │
    └─ Morph Targets Section
           └─ Morph (per target)
                  ├─ UIText (name)
                  └─ UINumber (influence)
```

### データフロー図

```
[入力]               [処理]                    [出力]

選択変更 ─────────▶ signals.objectSelected ─▶ build()
                                                  │
                                                  ▼
                                            currentGeometryType判定
                                                  │
                         ┌────────────────────────┴────────────────────────┐
                         ▼                                                 ▼
                    BufferGeometry?                                  Other Type?
                         │                                                 │
                         ▼                                                 ▼
                    SidebarGeometryModifiers                     dynamic import
                                                                           │
                                                                           ▼
                                                                  GeometryParametersPanel

パラメータ変更 ────▶ GeometryParametersPanel ─▶ SetGeometryCommand
                                                  │
                                                  ▼
                                            signals.geometryChanged
                                                  │
                                                  ▼
                                            Viewport再描画
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Sidebar.Geometry.js | `editor/js/Sidebar.Geometry.js` | ソース | Geometryパネルメインコンポーネント |
| Sidebar.Geometry.BufferGeometry.js | `editor/js/Sidebar.Geometry.BufferGeometry.js` | ソース | BufferGeometry属性表示 |
| Sidebar.Geometry.Modifiers.js | `editor/js/Sidebar.Geometry.Modifiers.js` | ソース | ジオメトリ修飾子 |
| Sidebar.Geometry.BoxGeometry.js | `editor/js/Sidebar.Geometry.BoxGeometry.js` | ソース | Boxパラメータパネル |
| Sidebar.Geometry.SphereGeometry.js | `editor/js/Sidebar.Geometry.SphereGeometry.js` | ソース | Sphereパラメータパネル |
| Sidebar.Geometry.CylinderGeometry.js | `editor/js/Sidebar.Geometry.CylinderGeometry.js` | ソース | Cylinderパラメータパネル |
| Sidebar.Geometry.TorusGeometry.js | `editor/js/Sidebar.Geometry.TorusGeometry.js` | ソース | Torusパラメータパネル |
| Sidebar.Geometry.PlaneGeometry.js | `editor/js/Sidebar.Geometry.PlaneGeometry.js` | ソース | Planeパラメータパネル |
| SetGeometryValueCommand.js | `editor/js/commands/SetGeometryValueCommand.js` | ソース | ジオメトリ値変更コマンド |
| VertexNormalsHelper.js | `examples/jsm/helpers/VertexNormalsHelper.js` | ライブラリ | 頂点法線可視化 |
