# 画面設計書 7-Sidebar - Script

## 概要

three.js EditorのSidebar - Scriptパネルの設計書。本ドキュメントでは、オブジェクトに紐付くスクリプトの管理機能について詳細に記述する。

### 本画面の処理概要

Sidebar - Scriptパネルは、選択オブジェクトに関連付けられたJavaScriptスクリプトを管理するための画面である。スクリプトの追加、名前変更、編集（Script Editorへの遷移）、削除の機能を提供し、オブジェクトごとにインタラクティブな動作を定義できる。

**業務上の目的・背景**：3Dシーンにインタラクティブ性を追加するためには、オブジェクトごとにイベントハンドラ（update、keydown、keyup等）を定義する必要がある。本パネルにより、ユーザーはプログラミング知識を活用してオブジェクトの動作をカスタマイズできる。

**画面へのアクセス方法**：ViewportまたはOutlinerでScene/Camera以外のオブジェクトを選択すると自動的に表示される。

**主要な操作・処理内容**：
1. 新規スクリプトの追加
2. スクリプト名の変更
3. スクリプトの編集（Script Editorを開く）
4. スクリプトの削除

**画面遷移**：「Edit」ボタンをクリックすると`signals.editScript`が発火し、Script Editor（CodeMirror）が開く。

**権限による表示制御**：権限による制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | EventDispatcher | 主機能 | スクリプトイベントの発行と購読管理 |

## 画面種別

管理パネル / リスト表示

## URL/ルーティング

URLルーティングなし（エディタ内コンポーネント）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 説明 |
|--------|----------|----------|------|
| スクリプト名 | 入力 | String | スクリプトの識別名 |
| スクリプトソース | 入出力 | String | JavaScriptコード |

## 表示項目

| 要素 | 表示内容 | 説明 |
|------|----------|------|
| Scripts List | 名前入力 + Edit + Remove | 各スクリプトの行 |
| New Button | 「New」ボタン | 新規スクリプト追加 |

## イベント仕様

### 1-新規スクリプト追加

新規スクリプトを追加する処理。

1. 「New」ボタンをクリック（行23-29）
2. デフォルトスクリプトオブジェクトを作成: `{ name: '', source: 'function update( event ) {}' }`
3. `AddScriptCommand`を実行
4. `signals.scriptAdded`が発火
5. `update()`でUI更新

### 2-スクリプト名変更

スクリプト名を変更する処理。

1. 名前入力フィールドを編集（行63-68）
2. `SetScriptValueCommand`を実行（'name'プロパティ）
3. Outlinerの表示も更新される（スクリプトマーク）

### 3-スクリプト編集

スクリプトをScript Editorで編集する処理。

1. 「Edit」ボタンをクリック（行71-77）
2. `signals.editScript.dispatch(object, script)`を発火
3. Script Editorコンポーネントがスクリプトを表示

### 4-スクリプト削除

スクリプトを削除する処理。

1. 「Remove」ボタンをクリック（行80-90）
2. 確認ダイアログを表示（`confirm(strings.getKey('prompt/script/remove'))`）
3. 承諾された場合、`RemoveScriptCommand`を実行
4. `signals.scriptRemoved`が発火
5. `update()`でUI更新

### 5-オブジェクト選択変更時の表示更新

選択オブジェクト変更時のUI更新処理。

1. `signals.objectSelected`を受信（行105-119）
2. オブジェクトが存在しカメラでない場合、パネルを表示
3. `update()`関数を呼び出し
4. `editor.scripts[object.uuid]`からスクリプト一覧を取得
5. 各スクリプトに対して名前入力、Edit、Removeボタンを生成

## データベース更新仕様

### 操作別データベース影響一覧

Sidebar - Script単体でのデータベース操作はない。スクリプト変更はCommandパターンでHistoryに記録され、自動保存機能によりIndexedDBに永続化される。

## メッセージ仕様

| 種別 | キー | メッセージ内容 | 表示条件 |
|------|------|--------------|----------|
| 確認 | prompt/script/remove | スクリプトを削除しますか？ | 削除ボタン押下時 |

## 例外処理

特別な例外処理はない。

## 備考

- スクリプトは`editor.scripts`オブジェクトでUUIDをキーとして管理される
- デフォルトのスクリプトテンプレートは`function update( event ) {}`
- スクリプトを持つオブジェクトはOutlinerでスクリプトアイコンが表示される
- Cameraオブジェクト選択時はパネルが非表示になる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

スクリプト管理の構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Editor.js | `editor/js/Editor.js` | 行124のthis.scripts、addScript/removeScriptメソッド |
| 1-2 | Sidebar.Script.js | `editor/js/Sidebar.Script.js` | スクリプトオブジェクトの構造（name, source） |

#### Step 2: エントリーポイントを理解する

SidebarScriptの初期化を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Sidebar.Script.js | `editor/js/Sidebar.Script.js` | 行7のSidebarScript関数開始 |

**主要処理フロー**:
1. **行13-16**: UIPanel作成、初期非表示設定
2. **行20-21**: scriptsContainerの作成
3. **行23-29**: 「New」ボタンの作成とイベント設定
4. **行40-101**: update関数（スクリプト一覧UI生成）
5. **行105-123**: シグナルハンドラ登録

#### Step 3: コマンドクラスを理解する

スクリプト操作コマンドの実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AddScriptCommand.js | `editor/js/commands/AddScriptCommand.js` | スクリプト追加処理 |
| 3-2 | SetScriptValueCommand.js | `editor/js/commands/SetScriptValueCommand.js` | スクリプト値変更処理 |
| 3-3 | RemoveScriptCommand.js | `editor/js/commands/RemoveScriptCommand.js` | スクリプト削除処理 |

### プログラム呼び出し階層図

```
Sidebar.Script.js
    │
    ├─ UIPanel (container)
    │
    ├─ UIRow (scriptsContainer)
    │      └─ Per Script:
    │             ├─ UIInput (name)
    │             ├─ UIButton (edit)
    │             └─ UIButton (remove)
    │
    └─ UIButton (newScript)

Commands:
    ├─ AddScriptCommand
    ├─ SetScriptValueCommand
    └─ RemoveScriptCommand

Signals:
    ├─ editScript (→ Script.js)
    ├─ scriptAdded
    ├─ scriptRemoved
    └─ scriptChanged
```

### データフロー図

```
[入力]               [処理]                    [出力]

New押下 ──────────▶ AddScriptCommand ────────▶ editor.scripts[uuid].push()
                                                  │
                                                  ▼
                                            signals.scriptAdded
                                                  │
                                                  ▼
                                            update() → UI更新

Edit押下 ─────────▶ signals.editScript ──────▶ Script.js (CodeMirror)

Remove押下 ───────▶ confirm() ───────────────▶ RemoveScriptCommand
                                                  │
                                                  ▼
                                            signals.scriptRemoved
                                                  │
                                                  ▼
                                            update() → UI更新

名前変更 ─────────▶ SetScriptValueCommand ───▶ script.name更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Sidebar.Script.js | `editor/js/Sidebar.Script.js` | ソース | Scriptパネルメインコンポーネント |
| Script.js | `editor/js/Script.js` | ソース | Script Editor（CodeMirror統合） |
| AddScriptCommand.js | `editor/js/commands/AddScriptCommand.js` | ソース | スクリプト追加コマンド |
| SetScriptValueCommand.js | `editor/js/commands/SetScriptValueCommand.js` | ソース | スクリプト値変更コマンド |
| RemoveScriptCommand.js | `editor/js/commands/RemoveScriptCommand.js` | ソース | スクリプト削除コマンド |
| Editor.js | `editor/js/Editor.js` | ソース | scripts管理 |
