# 画面設計書 8-Sidebar - Project

## 概要

three.js EditorのSidebar - Projectパネルの設計書。本ドキュメントでは、プロジェクト設定（レンダラー設定、アプリ設定、リソース管理）について詳細に記述する。

### 本画面の処理概要

Sidebar - Projectパネルは、プロジェクト全体の設定を管理するための画面である。レンダラータイプ（WebGL/WebGPU）の選択、シャドウマップ設定、トーンマッピング設定、アプリケーション設定、リソース（マテリアル、テクスチャ等）の一覧管理機能を提供する。

**業務上の目的・背景**：3Dアプリケーションの品質と性能は、レンダラー設定に大きく依存する。本パネルにより、ユーザーはWebGL/WebGPUの選択、アンチエイリアス、シャドウ品質、トーンマッピングなどのグローバル設定を一元管理できる。また、プロジェクト内のリソースを可視化し、不要なリソースの特定に役立てることができる。

**画面へのアクセス方法**：Sidebarの「Project」タブをクリックしてアクセス。

**主要な操作・処理内容**：
1. レンダラータイプ（WebGL/WebGPU）の選択
2. アンチエイリアスの有効/無効
3. シャドウマップの有効/無効とタイプ選択
4. トーンマッピングの選択と露出値調整
5. アプリ設定（タイトル、説明等）の編集
6. リソース（マテリアル、テクスチャ、ジオメトリ等）の一覧確認

**画面遷移**：設定変更はリアルタイムにViewportに反映される。

**権限による表示制御**：権限による制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | WebGLRenderer | 主機能 | レンダラー設定の管理 |
| 14 | WebGPURenderer | 主機能 | WebGPUレンダラー設定の管理 |

## 画面種別

設定パネル

## URL/ルーティング

URLルーティングなし（エディタ内コンポーネント）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 説明 |
|--------|----------|----------|------|
| Renderer | 入力 | String | WebGLRenderer / WebGPURenderer |
| Antialias | 入力 | Boolean | アンチエイリアス有効/無効 |
| Shadows | 入力 | Boolean | シャドウマップ有効/無効 |
| Shadow Type | 入力 | Enum | Basic(0) / PCF(1) / VSM(3) |
| Tone Mapping | 入力 | Enum | No(0) / Linear(1) / Reinhard(2) / Cineon(3) / ACESFilmic(4) / AgX(6) / Neutral(7) |
| Exposure | 入力 | Number | トーンマッピング露出値 (0-10) |

## 表示項目

| 要素 | 表示内容 | 説明 |
|------|----------|------|
| Renderer | レンダラータイプ選択 | WebGL/WebGPU |
| Antialias | チェックボックス | アンチエイリアス |
| Shadows | チェックボックス + タイプ選択 | シャドウ設定 |
| Tone Mapping | ドロップダウン + 数値入力 | トーンマッピング |
| App Settings | 入力フィールド群 | SidebarProjectApp |
| Resources | リソース一覧 | SidebarProjectResources |

## イベント仕様

### 1-レンダラータイプ変更

レンダラータイプを変更した際の処理。

1. rendererTypeSelectを変更（行25-30）
2. `createRenderer()`関数を呼び出し（行107-131）
3. WebGPURendererの場合は`await currentRenderer.init()`を実行
4. シャドウ、トーンマッピング設定を適用
5. `signals.rendererCreated`と`signals.rendererUpdated`を発火
6. Viewportが新しいレンダラーで描画開始

### 2-シャドウ設定変更

シャドウマップ設定を変更した際の処理。

1. shadowsBoolean/shadowTypeSelectを変更（行44-58）
2. `updateShadows()`関数を呼び出し（行60-67）
3. `currentRenderer.shadowMap.enabled`と`shadowMap.type`を更新
4. `signals.rendererUpdated`を発火

### 3-トーンマッピング設定変更

トーンマッピング設定を変更した際の処理。

1. toneMappingSelect/toneMappingExposureを変更（行69-93）
2. `updateToneMapping()`関数を呼び出し（行95-103）
3. `currentRenderer.toneMapping`と`toneMappingExposure`を更新
4. トーンマッピングが「No」の場合、露出値入力を非表示
5. `signals.rendererUpdated`を発火

### 4-エディタクリア時の設定リセット

editorClearedシグナル受信時の処理。

1. `signals.editorCleared`を受信（行138-153）
2. シャドウをPCFShadowMapにリセット
3. トーンマッピングをNeutralにリセット
4. UIを更新
5. `signals.rendererUpdated`を発火

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ストレージ | 操作種別 | 概要 |
|----------------|---------------|---------|------|
| 設定変更 | Config | UPDATE | レンダラー設定をConfigに保存 |

### テーブル別更新項目詳細

#### Config (editor.config)

| 操作 | キー | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SET | project/renderer/type | 'WebGLRenderer' または 'WebGPURenderer' | |
| SET | project/renderer/antialias | Boolean | |
| SET | project/renderer/shadows | Boolean | |
| SET | project/renderer/shadowType | Number (0/1/3) | |
| SET | project/renderer/toneMapping | Number (0-7) | |
| SET | project/renderer/toneMappingExposure | Number | |

## メッセージ仕様

メッセージ表示はない。

## 例外処理

| 状況 | 処理 |
|------|------|
| WebGPU非対応ブラウザ | レンダラー生成時にエラー（未対応時の処理は明示されていない） |

## 備考

- SidebarProjectはコンテナのみで、実際の内容はSidebarProjectRenderer、SidebarProjectApp、SidebarProjectResourcesで構成
- レンダラー設定変更時はレンダラー自体を再生成する（パラメータ変更のみでは対応できない設定があるため）
- Configへの保存はrendererUpdatedシグナルのハンドラで行われる
- logarithmicDepthBufferは常に有効化されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 構成を理解する

Projectパネルの構成を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Sidebar.Project.js | `editor/js/Sidebar.Project.js` | 行7-20でサブコンポーネントを追加 |

#### Step 2: レンダラー設定を理解する

レンダラー設定の実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Sidebar.Project.Renderer.js | `editor/js/Sidebar.Project.Renderer.js` | レンダラー設定全体 |

**主要処理フロー**:
1. **行20-30**: レンダラータイプ選択UI
2. **行34-40**: アンチエイリアス設定
3. **行44-58**: シャドウ設定
4. **行69-93**: トーンマッピング設定
5. **行107-131**: createRenderer関数（レンダラー生成）
6. **行138-166**: シグナルハンドラ

#### Step 3: サブコンポーネントを理解する

App設定とリソース管理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Sidebar.Project.App.js | `editor/js/Sidebar.Project.App.js` | アプリケーション設定 |
| 3-2 | Sidebar.Project.Resources.js | `editor/js/Sidebar.Project.Resources.js` | リソース一覧 |

### プログラム呼び出し階層図

```
Sidebar.Project.js
    │
    ├─ SidebarProjectRenderer
    │      ├─ UISelect (rendererTypeSelect)
    │      │      └─ createRenderer()
    │      ├─ UIBoolean (antialiasBoolean)
    │      │      └─ createRenderer()
    │      ├─ UIBoolean (shadowsBoolean)
    │      │      └─ updateShadows()
    │      ├─ UISelect (shadowTypeSelect)
    │      │      └─ updateShadows()
    │      ├─ UISelect (toneMappingSelect)
    │      │      └─ updateToneMapping()
    │      └─ UINumber (toneMappingExposure)
    │             └─ updateToneMapping()
    │
    ├─ SidebarProjectApp
    │
    └─ SidebarProjectResources
```

### データフロー図

```
[入力]               [処理]                    [出力]

レンダラー変更 ─────▶ createRenderer() ──────▶ signals.rendererCreated
                           │                       │
                           ▼                       ▼
                    new WebGL/WebGPURenderer  Viewport.js
                           │                  renderer設定
                           ▼
                    signals.rendererUpdated
                           │
                           ▼
                    config.setKey()

シャドウ変更 ───────▶ updateShadows() ────────▶ signals.rendererUpdated
                                                  │
                                                  ▼
                                            config.setKey()

トーンマッピング変更 ▶ updateToneMapping() ──▶ signals.rendererUpdated
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Sidebar.Project.js | `editor/js/Sidebar.Project.js` | ソース | Projectパネルコンテナ |
| Sidebar.Project.Renderer.js | `editor/js/Sidebar.Project.Renderer.js` | ソース | レンダラー設定 |
| Sidebar.Project.App.js | `editor/js/Sidebar.Project.App.js` | ソース | アプリケーション設定 |
| Sidebar.Project.Resources.js | `editor/js/Sidebar.Project.Resources.js` | ソース | リソース管理 |
| Config.js | `editor/js/Config.js` | ソース | 設定永続化 |
