# 画面設計書 9-Sidebar - Settings

## 概要

three.js EditorのSidebar - Settingsパネルの設計書。本ドキュメントでは、言語設定、キーボードショートカット設定、履歴管理機能について詳細に記述する。

### 本画面の処理概要

Sidebar - Settingsパネルは、エディタのグローバル設定を管理するための画面である。言語選択（英語、フランス語、中国語、日本語、韓国語、ペルシャ語）、キーボードショートカットのカスタマイズ（移動、回転、スケール、Undo、フォーカス）、および操作履歴の表示・管理機能を提供する。履歴機能では、実行されたコマンドの一覧表示、任意の状態への復帰、履歴の永続化設定が可能である。

**業務上の目的・背景**：3Dエディタの操作効率は、ユーザーの使用言語やキーボードショートカットの設定に大きく依存する。本パネルにより、ユーザーは自身の作業スタイルに合わせてエディタをカスタマイズできる。また、履歴機能により操作の取り消しや特定時点への復帰が容易になり、試行錯誤を伴う3Dモデリング作業の効率を向上させる。

**画面へのアクセス方法**：Sidebarの「Settings」タブをクリックしてアクセス。

**主要な操作・処理内容**：
1. 言語の選択と切り替え
2. キーボードショートカットのカスタマイズ
3. 操作履歴の確認と任意の状態への復帰
4. 履歴永続化の有効/無効設定
5. 履歴のクリア

**画面遷移**：言語設定の変更は次回起動時に反映。ショートカット設定は即時反映。履歴からの状態復帰はViewportおよび各パネルに即時反映。

**権限による表示制御**：権限による制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | History (Undo/Redo) | 主機能 | 操作履歴の管理とUndo/Redo |
| 5 | EventDispatcher | 副機能 | 設定変更シグナルの発行 |

## 画面種別

設定パネル

## URL/ルーティング

URLルーティングなし（エディタ内コンポーネント）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 説明 |
|--------|----------|----------|------|
| Language | 入力 | String | 言語コード（en/fr/zh/ja/ko/fa） |
| Translate Shortcut | 入力 | String | 移動モードショートカットキー（1文字） |
| Rotate Shortcut | 入力 | String | 回転モードショートカットキー（1文字） |
| Scale Shortcut | 入力 | String | スケールモードショートカットキー（1文字） |
| Undo Shortcut | 入力 | String | Undoショートカットキー（1文字） |
| Focus Shortcut | 入力 | String | フォーカスショートカットキー（1文字） |
| History Persistent | 入力 | Boolean | 履歴永続化の有効/無効 |

## 表示項目

| 要素 | 表示内容 | 説明 |
|------|----------|------|
| Language Select | ドロップダウン | 言語選択 |
| Shortcuts Section | 入力フィールド群 | 各種ショートカットキー設定 |
| History Persistent | チェックボックス | 履歴永続化設定 |
| History Outliner | リスト | 操作履歴一覧 |
| Clear History Button | ボタン | 履歴クリア |

## イベント仕様

### 1-言語変更

言語設定を変更する処理。

1. 言語セレクトを変更（行27-42）
2. `config.setKey('language', value)`で設定を保存
3. 変更は次回起動時に反映される

### 2-ショートカットキー変更

キーボードショートカットを変更する処理。

1. ショートカット入力フィールドを編集（行28-90）
2. `isValidKeyBinding()`でA-Z、0-9の1文字かを検証
3. 有効な場合、`config.setKey()`で保存
4. 無効な場合、元の値に戻す
5. 即座にキーボードイベントリスナーに反映

### 3-ショートカットキー実行

登録されたショートカットキーを押下した際の処理。

1. `document.addEventListener('keydown')`でキー入力を監視（行98-169）
2. Delete/Backspaceキー：選択オブジェクトを削除（`RemoveObjectCommand`）
3. Translateキー：`signals.transformModeChanged.dispatch('translate')`
4. Rotateキー：`signals.transformModeChanged.dispatch('rotate')`
5. Scaleキー：`signals.transformModeChanged.dispatch('scale')`
6. Undoキー + Ctrl/Cmd：`editor.undo()`または`editor.redo()`
7. Focusキー：`editor.focus(editor.selected)`

### 4-履歴永続化設定変更

履歴永続化の有効/無効を切り替える処理。

1. persistentチェックボックスを変更（行18-40）
2. `config.setKey('settings/history', value)`で保存
3. 有効化時：確認アラート表示、`history.enableSerialization()`呼び出し
4. 無効化時：`signals.historyChanged`を発火してUI更新

### 5-履歴状態への復帰

履歴から任意の状態へ復帰する処理。

1. 履歴リスト（outliner）で項目をクリック（行47-56）
2. `editor.history.goToState(id)`を呼び出し
3. シーンが選択された状態に復帰
4. `ignoreObjectSelectedSignal`フラグで無限ループを防止

### 6-履歴クリア

操作履歴を全てクリアする処理。

1. 「Clear」ボタンをクリック（行63-72）
2. 確認ダイアログを表示
3. 承諾された場合、`editor.history.clear()`を実行
4. `signals.historyChanged`が発火してUI更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ストレージ | 操作種別 | 概要 |
|----------------|---------------|---------|------|
| 言語変更 | Config | UPDATE | 言語設定を保存 |
| ショートカット変更 | Config | UPDATE | ショートカット設定を保存 |
| 履歴永続化変更 | Config | UPDATE | 永続化設定を保存 |
| 履歴永続化有効時 | IndexedDB | INSERT/UPDATE | 履歴をシリアライズして保存 |

### テーブル別更新項目詳細

#### Config (editor.config)

| 操作 | キー | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SET | language | 'en' / 'fr' / 'zh' / 'ja' / 'ko' / 'fa' | |
| SET | settings/shortcuts/translate | String (1文字) | デフォルト: 'w' |
| SET | settings/shortcuts/rotate | String (1文字) | デフォルト: 'e' |
| SET | settings/shortcuts/scale | String (1文字) | デフォルト: 'r' |
| SET | settings/shortcuts/undo | String (1文字) | デフォルト: 'z' |
| SET | settings/shortcuts/focus | String (1文字) | デフォルト: 'f' |
| SET | settings/history | Boolean | 履歴永続化フラグ |

## メッセージ仕様

| 種別 | キー | メッセージ内容 | 表示条件 |
|------|------|--------------|----------|
| 確認 | prompt/history/preserve | 履歴を保存しますか？ | 永続化有効化時 |
| 確認 | prompt/history/clear | 履歴をクリアしますか？ | クリアボタン押下時 |

## 例外処理

| 状況 | 処理 |
|------|------|
| 無効なショートカットキー入力 | 元の値に戻す（blur時に検証） |

## 備考

- 言語設定はIntl.DisplayNamesを使用して各言語の表示名を自動取得
- ショートカットキーはA-Z、0-9の英数字1文字のみ有効
- Mac環境ではCtrlの代わりにCommandキーを使用（IS_MACフラグで判定）
- 履歴のOutlinerはundos配列を正順、redos配列を逆順で表示
- redos（やり直し可能な操作）は透明度0.3で表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 構成を理解する

Settingsパネルの構成を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Sidebar.Settings.js | `editor/js/Sidebar.Settings.js` | 行6-54でメイン構成、サブコンポーネント追加 |

**主要処理フロー**:
1. **行11-16**: UIPanel作成
2. **行20-24**: 言語オプション生成（Intl.DisplayNames使用）
3. **行26-47**: 言語選択UIと変更ハンドラ
4. **行51-52**: Shortcuts、Historyサブコンポーネント追加

#### Step 2: ショートカット設定を理解する

キーボードショートカットの実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Sidebar.Settings.Shortcuts.js | `editor/js/Sidebar.Settings.Shortcuts.js` | ショートカット設定全体 |

**主要処理フロー**:
1. **行11-15**: isValidKeyBinding検証関数
2. **行26**: ショートカット名定義（translate/rotate/scale/undo/focus）
3. **行28-90**: createShortcutInput関数（入力UI生成）
4. **行98-169**: document.addEventListenerでキー入力処理

#### Step 3: 履歴管理を理解する

操作履歴の実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Sidebar.Settings.History.js | `editor/js/Sidebar.Settings.History.js` | 履歴管理全体 |

**主要処理フロー**:
1. **行12-14**: UIPanel作成、タイトル設定
2. **行18-41**: persistent（永続化）チェックボックス
3. **行47-57**: outliner（履歴リスト）とgoToState呼び出し
4. **行63-73**: Clear Historyボタン
5. **行77-124**: refreshUI関数（undos/redos配列をUI反映）
6. **行130-139**: シグナルハンドラ登録

### プログラム呼び出し階層図

```
Sidebar.Settings.js
    │
    ├─ UIPanel (settings)
    │      └─ UISelect (language)
    │             └─ config.setKey('language')
    │
    ├─ SidebarSettingsShortcuts
    │      ├─ UIInput (translate)
    │      ├─ UIInput (rotate)
    │      ├─ UIInput (scale)
    │      ├─ UIInput (undo)
    │      └─ UIInput (focus)
    │             └─ config.setKey('settings/shortcuts/...')
    │      │
    │      └─ document.addEventListener('keydown')
    │             ├─ RemoveObjectCommand
    │             ├─ signals.transformModeChanged
    │             ├─ editor.undo() / editor.redo()
    │             └─ editor.focus()
    │
    └─ SidebarSettingsHistory
           ├─ UIBoolean (persistent)
           │      └─ history.enableSerialization()
           ├─ UIOutliner (history list)
           │      └─ history.goToState()
           └─ UIButton (clear)
                  └─ history.clear()
```

### データフロー図

```
[入力]               [処理]                    [出力]

言語選択 ──────────▶ config.setKey() ─────────▶ localStorage
                                                  │
                                                  ▼
                                            次回起動時反映

ショートカット入力 ──▶ isValidKeyBinding() ────▶ config.setKey()
                           │                       │
                           ▼                       ▼
                        無効時は元値に          即時反映（keydownリスナー）

履歴項目クリック ────▶ history.goToState() ────▶ signals.historyChanged
                                                  │
                                                  ▼
                                            シーン状態復帰
                                            UI更新（refreshUI）

永続化ON ───────────▶ enableSerialization() ──▶ IndexedDB保存

Clear押下 ──────────▶ confirm() ──────────────▶ history.clear()
                                                  │
                                                  ▼
                                            signals.historyChanged
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Sidebar.Settings.js | `editor/js/Sidebar.Settings.js` | ソース | Settingsパネルコンテナ |
| Sidebar.Settings.Shortcuts.js | `editor/js/Sidebar.Settings.Shortcuts.js` | ソース | ショートカット設定 |
| Sidebar.Settings.History.js | `editor/js/Sidebar.Settings.History.js` | ソース | 履歴管理 |
| Config.js | `editor/js/Config.js` | ソース | 設定永続化 |
| History.js | `editor/js/History.js` | ソース | 履歴管理コア |
| RemoveObjectCommand.js | `editor/js/commands/RemoveObjectCommand.js` | ソース | オブジェクト削除コマンド |
