---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-エディタメイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **PWAオフライン動作の詳細**：ServiceWorkerの具体的なキャッシュ戦略が未確認
  2. **IndexedDBストレージの具体的なスキーマ**：Storage.jsの詳細実装が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `editor/index.html` - メインHTMLファイル、行1-259
- E-02: `editor/js/Editor.js` - Editorクラス定義、行1-816
- E-03: `editor/js/Viewport.js` - Viewportクラス定義、行1-950
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SPAアーキテクチャを採用 | E-01行60-257, E-06 | ○ |
| C-02 | Viewport、Sidebar、Menubar等を統合 | E-01行83-102 | ○ |
| C-03 | PWA対応（ServiceWorker）| E-01行245-255, E-04 | ○ |
| C-04 | WebGLRendererでレンダリング | E-02行10, E-05 | ○ |
| C-05 | WebGPURendererでレンダリング | E-05 | ○ |
| C-06 | PerspectiveCameraでカメラ制御 | E-02行10-14 | ○ |
| C-07 | AnimationMixerでアニメーション管理 | E-02行128 | ○ |
| C-08 | 自動保存機能が1秒デバウンスで動作 | E-01行134-160 | ○ |
| C-09 | IndexedDBに状態を永続化 | E-01行106-131, E-02行104 | ○ |
| C-10 | ファイルドラッグ&ドロップ対応 | E-01行180-205 | ○ |
| C-11 | URLハッシュからプロジェクト読み込み | E-01行219-241 | ○ |
| C-12 | CodeMirrorをスクリプトエディタに使用 | E-01行31-35 | ○ |
| C-13 | signals.jsでイベント管理 | E-01行58, E-02行17 | ○ |
| C-14 | Import Mapsでモジュール管理 | E-01行15-27 | ○ |
| C-15 | THREE.FileLoaderでファイル読み込み | E-01行228-235 | ○ |
| C-16 | editor.toJSON()でプロジェクト保存 | E-02行706-745 | ○ |
| C-17 | editor.fromJSON()でプロジェクト復元 | E-02行671-703 | ○ |
| C-18 | editor.clear()でプロジェクトクリア | E-02行624-666 | ○ |
| C-19 | シグナルによるコンポーネント間通信 | E-02行19-98 | ○ |
| C-20 | Editorインスタンスをwindowに公開 | E-01行80 | ○ |
| C-21 | THREEをwindowに公開 | E-01行81 | ○ |
| C-22 | 確認ダイアログで操作確認 | E-01行226 | ○ |
| C-23 | レンダラーのシャドウマップ設定 | E-05 | ○ |
| C-24 | オフライン環境で完全動作 | **根拠なし** | △ |
| C-25 | Storage.jsのIndexedDBスキーマ詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ServiceWorkerのキャッシュ戦略の詳細（sw.jsの内容未確認）
  - 候補：sw.js / キャッシュ対象リスト / オフライン動作テスト結果
- IndexedDBのデータベース名、オブジェクトストア名、バージョン管理
  - 候補：Storage.js詳細解析 / ブラウザDevToolsでの確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコード参照に基づく主張（C-01〜C-23）
- 1: 中リスク - オフライン動作の完全性（C-24）
- 1: 中リスク - ストレージ詳細（C-25）

## 6) レビュアーチェックリスト（最小）
- [ ] index.htmlの初期化シーケンスが正しく記述されているか確認
- [ ] シグナル一覧がEditor.jsの定義と一致しているか確認
- [ ] ServiceWorkerの実装を確認し、オフライン動作の記述を検証
- [ ] Storage.jsを確認し、IndexedDBの具体的な仕様を補完
- [ ] 画面機能マッピングの関連機能が網羅されているか確認
