---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-Menubar - File

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張に根拠が確認された。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `editor/js/Menubar.File.js` - MenubarFileクラス定義、行1-468
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Newサブメニュー存在 | E-01行25-43 | ○ |
| C-02 | Empty項目でeditor.clear() | E-01行47-56 | ○ |
| C-03 | サンプル5種（Arkanoid/Camera/Particles/Pong/Shaders） | E-01行65-71 | ○ |
| C-04 | FileLoaderでサンプル読み込み | E-01行73, 88 | ○ |
| C-05 | サンプル読み込み後にeditor.fromJSON() | E-01行91 | ○ |
| C-06 | Open項目でファイル選択 | E-01行151-162 | ○ |
| C-07 | .json形式のみ受付 | E-01行113 | ○ |
| C-08 | file.text()でJSON読み込み | E-01行122 | ○ |
| C-09 | editorClearedシグナル経由でfromJSON | E-01行124-130 | ○ |
| C-10 | JSONパースエラー時にアラート | E-01行138 | ○ |
| C-11 | Save項目でtoJSON | E-01行173 | ○ |
| C-12 | Blob作成とsave呼び出し | E-01行174-175 | ○ |
| C-13 | Import項目で複数ファイル選択可能 | E-01行192 | ○ |
| C-14 | editor.loader.loadFiles()呼び出し | E-01行196 | ○ |
| C-15 | Exportサブメニュー存在 | E-01行214-232 | ○ |
| C-16 | DRACOExporter動的インポート | E-01行250 | ○ |
| C-17 | DRC出力時にMesh確認 | E-01行243-248 | ○ |
| C-18 | GLTFExporter動的インポート | E-01行289, 320 | ○ |
| C-19 | getAnimations()でアニメーション収集 | E-01行279, 310 | ○ |
| C-20 | OBJExporter動的インポート | E-01行350 | ○ |
| C-21 | OBJ出力時にオブジェクト選択確認 | E-01行343-348 | ○ |
| C-22 | PLYExporter動的インポート（ASCII/Binary） | E-01行366, 386 | ○ |
| C-23 | STLExporter動的インポート（ASCII/Binary） | E-01行406, 422 | ○ |
| C-24 | USDZExporter動的インポート | E-01行438 | ○ |
| C-25 | saveArrayBuffer/saveStringはeditor.utilsから取得 | E-01行8-9 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Menubar.File.jsの行番号参照が正確か確認
- [ ] 各エクスポーターの動的インポートパスが正しいか確認
- [ ] サンプルプロジェクトのファイル名が正しいか確認
- [ ] 画面機能マッピングの関連機能が網羅されているか確認
