---
generated_at: 2026-01-27 12:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-Toolbar 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/js/Toolbar.js` - ツールバーの実装ファイル（76行）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | containerのidは'toolbar' | E-01 (9行目) | ○ |
| C-02 | Translateアイコンはimages/translate.svg | E-01 (15行目) | ○ |
| C-03 | Rotateアイコンはimages/rotate.svg | E-01 (29行目) | ○ |
| C-04 | Scaleアイコンはimages/scale.svg | E-01 (41行目) | ○ |
| C-05 | Translateボタンの初期状態は'Button selected' | E-01 (18行目) | ○ |
| C-06 | TranslateクリックでtransformModeChanged.dispatch('translate') | E-01 (22行目) | ○ |
| C-07 | RotateクリックでtransformModeChanged.dispatch('rotate') | E-01 (35行目) | ○ |
| C-08 | ScaleクリックでtransformModeChanged.dispatch('scale') | E-01 (48行目) | ○ |
| C-09 | transformModeChanged時にすべてのボタンからselectedを削除 | E-01 (57-59行目) | ○ |
| C-10 | translateモード時にtranslateボタンにselectedを追加 | E-01 (63行目) | ○ |
| C-11 | rotateモード時にrotateボタンにselectedを追加 | E-01 (64行目) | ○ |
| C-12 | scaleモード時にscaleボタンにselectedを追加 | E-01 (65行目) | ○ |
| C-13 | ツールチップはstrings.getKey()で取得 | E-01 (14, 28, 40行目) | ○ |
| C-14 | 関連機能にObject3Dが含まれる | E-03 (73行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張についてソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [x] 各ボタンのアイコンパスが正確か
- [x] 初期状態（Translate選択）の記載が正確か
- [x] シグナル発行処理が正確か
- [x] ボタン状態同期ロジックが正確か
- [x] 関連機能一覧が画面機能マッピングと一致しているか
