---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：2-Viewport

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **EditorControlsの詳細操作**：EditorControls.jsの詳細実装が未参照

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `editor/js/Viewport.js` - Viewportクラス定義、行1-950
- E-02: `editor/js/Editor.js` - Editorクラス定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-04: `editor/index.html` - Viewportの初期化、行83-84

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebGLRendererでレンダリング | E-01行391-394, E-03 | ○ |
| C-02 | WebGPURendererでレンダリング | E-01行398-402, E-03 | ○ |
| C-03 | Raycasterでオブジェクト選択 | E-01行198, E-03 | ○ |
| C-04 | PerspectiveCameraで透視投影 | E-01行42, E-02 | ○ |
| C-05 | OrthographicCamera対応 | E-01行167-171, E-03 | ○ |
| C-06 | GridHelperで2層グリッド表示 | E-01行48-62 | ○ |
| C-07 | Box3Helperで選択ボックス表示 | E-01行67-73 | ○ |
| C-08 | PMREMGeneratorで環境マップ処理 | E-01行2, 393, 400 | ○ |
| C-09 | Timerでアニメーション時間計測 | E-01行805 | ○ |
| C-10 | TransformControlsで変形操作 | E-01行79-147 | ○ |
| C-11 | SetPositionCommandで位置変更を履歴登録 | E-01行113 | ○ |
| C-12 | SetRotationCommandで回転変更を履歴登録 | E-01行121 | ○ |
| C-13 | SetScaleCommandでスケール変更を履歴登録 | E-01行129 | ○ |
| C-14 | mousedown/mouseupでクリック検出 | E-01行207-228 | ○ |
| C-15 | dblclickでフォーカス処理 | E-01行255-270 | ○ |
| C-16 | EditorControlsでカメラ操作 | E-01行279-288 | ○ |
| C-17 | ViewHelperで視点切替 | E-01行63, 929 | ○ |
| C-18 | animate関数でループ | E-01行807-857 | ○ |
| C-19 | render関数で描画 | E-01行915-936 | ○ |
| C-20 | realisticモードでパストレーサー | E-01行708 | ○ |
| C-21 | solidモードでoverideMaterial=null | E-01行712 | ○ |
| C-22 | normalsモードでMeshNormalMaterial | E-01行716 | ○ |
| C-23 | wireframeモードでMeshBasicMaterial | E-01行720 | ○ |
| C-24 | ダークモード対応 | E-01行371-386 | ○ |
| C-25 | sceneRenderedシグナルでレンダリング時間通知 | E-01行935 | ○ |
| C-26 | XRサポート | E-01行151, 847 | ○ |
| C-27 | パストレーサーはWebGLのみ | E-01行396, 402 | ○ |
| C-28 | EditorControlsの左/中/右ドラッグ操作の詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- EditorControls.jsの詳細実装（左ドラッグ=回転、中/右ドラッグ=パン、スクロール=ズームの具体的実装）
  - 候補：EditorControls.js詳細解析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Viewport.jsから直接確認できる主張（C-01〜C-27）
- 1: 中リスク - EditorControlsの操作詳細（C-28）

## 6) レビュアーチェックリスト（最小）
- [ ] Viewport.jsの行番号参照が正確か確認
- [ ] TransformControlsのイベント処理が正しく記述されているか確認
- [ ] EditorControls.jsを確認し、カメラ操作の詳細を補完
- [ ] 画面機能マッピングの関連機能が網羅されているか確認
- [ ] パストレーサーの動作条件が正しいか確認
