---
generated_at: 2026-01-27 12:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-Examples一覧画面 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `examples/index.html` - Examples画面の実装（416行）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | files.jsonをfetchで読み込む | E-01 (69行目) | ○ |
| C-02 | tags.jsonをfetchで読み込む | E-01 (70行目) | ○ |
| C-03 | カテゴリはh2要素で表示 | E-01 (76-79行目) | ○ |
| C-04 | サンプルカードはcreateLink()で生成 | E-01 (85行目) | ○ |
| C-05 | URLハッシュでサンプルを選択 | E-01 (97-110行目) | ○ |
| C-06 | validRedirectsマップで検証 | E-01 (103行目) | ○ |
| C-07 | プレースホルダーHTMLはテンプレートで定義 | E-01 (388-413行目) | ○ |
| C-08 | サムネイルはscreenshots/{file}.jpg | E-01 (218行目) | ○ |
| C-09 | communityタグでバッジ表示 | E-01 (204行目) | ○ |
| C-10 | selectFile()でURLハッシュを更新 | E-01 (246行目) | ○ |
| C-11 | selectFile()でpanelからopenクラスを削除 | E-01 (250行目) | ○ |
| C-12 | View Sourceのhrefを更新 | E-01 (256行目) | ○ |
| C-13 | フィルタ入力でURLクエリパラメータを更新 | E-01 (276, 280行目) | ○ |
| C-14 | 正規表現でマッチング | E-01 (284行目) | ○ |
| C-15 | マッチしないサンプルにhiddenクラスを追加 | E-01 (314行目) | ○ |
| C-16 | カテゴリ内全非表示でカテゴリ見出しも非表示 | E-01 (351行目) | ○ |
| C-17 | expandButtonでpanelのopenをトグル | E-01 (172行目) | ○ |
| C-18 | previewsTogglerでminimalをトグル | E-01 (186行目) | ○ |
| C-19 | iOS向けiframeワークアラウンド | E-01 (192-198行目) | ○ |
| C-20 | css3d_mixedはタイムスタンプ付きURL | E-01 (208-210行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張についてソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [x] 初期化処理（files.json/tags.json読み込み）が正確か
- [x] サンプル選択処理が正確か
- [x] フィルタリング処理が正確か
- [x] URLハッシュ/クエリパラメータの処理が正確か
- [x] 特殊ケース（community, css3d_mixed, iOS）の処理が正確か
