---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：21-WebGL基本サンプル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **サンプル件数（約217件）**：files.json から計算した値だが、正確な件数は変動する可能性
  2. **全サンプルでの共通パターン**：代表的なサンプルからの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `examples/index.html` (サンプル一覧画面の実装)
- E-02: `examples/files.json` (サンプルファイルのカテゴリ分類)
- E-03: `examples/webgl_animation_keyframes.html` (代表的なWebGLサンプル)
- E-04: `examples/jsm/controls/OrbitControls.js` (カメラコントロール実装)
- E-05: `examples/jsm/loaders/GLTFLoader.js` (モデルローダー実装)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面一覧定義)
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング定義)
- E-08: `build/three.module.js` (three.js コアモジュール)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebGL基本サンプルは約217件存在する | E-02 (files.json の webgl 配列) | ○ |
| C-02 | サンプルは examples/index.html から iframe で表示される | E-01 (Line 41: iframe id="viewer") | ○ |
| C-03 | 検索フィルタで絞り込み可能 | E-01 (Line 29-30: filterInput) | ○ |
| C-04 | サムネイルクリックでサンプル表示 | E-01 (Line 228-234: click イベント) | ○ |
| C-05 | requestAnimationFrame ベースのレンダリングループ | E-03 (Line 107: setAnimationLoop) | ○ |
| C-06 | OrbitControls でカメラ操作 | E-03 (Line 87-90), E-04 | ○ |
| C-07 | GLTFLoader でモデル読み込み | E-03 (Line 95-113), E-05 | ○ |
| C-08 | Timer.update() で経過時間を取得 | E-03 (Line 53-54, 126-128) | ○ |
| C-09 | AnimationMixer でアニメーション再生 | E-03 (Line 104-105, 130) | ○ |
| C-10 | window.resize イベントでサイズ更新 | E-03 (Line 115-121) | ○ |
| C-11 | ES Modules 形式で実装 | E-03 (Line 30-37: importmap, Line 39-41: import) | ○ |
| C-12 | Import Map でモジュールパス解決 | E-03 (Line 30-37) | ○ |
| C-13 | WebGLRenderer の主機能 | E-07 (画面No 21 の関連機能) | ○ |
| C-14 | BufferGeometry の補助機能 | E-07 (画面No 21 の関連機能) | ○ |
| C-15 | Material の補助機能 | E-07 (画面No 21 の関連機能) | ○ |
| C-16 | toneMapping 設定が可能 | E-03 (Line 63: renderer.toneMapping) | ○ |
| C-17 | PMREMGenerator で環境マップ生成 | E-03 (Line 79-82) | ○ |
| C-18 | Stats でパフォーマンス表示 | E-03 (Line 57-58, 134) | ○ |
| C-19 | DRACOLoader で圧縮対応 | E-03 (Line 92-96) | ○ |
| C-20 | GUI パラメータ調整が可能 | E-02 (多くのサンプルで lil-gui 使用) | ○ |
| C-21 | GitHub ソースへの外部リンクあり | E-01 (Line 255-257: viewSrcButton) | ○ |
| C-22 | canvas にレンダリング結果出力 | E-03 (Line 64: container.appendChild) | ○ |
| C-23 | WebGL非対応ブラウザへのフォールバック | E-08 (WebGLRenderer 内の対応) | ○ |
| C-24 | 全サンプルで共通の初期化パターン | **根拠なし** (代表サンプルからの推測) | △ |
| C-25 | 約217件の正確な件数 | **根拠不足** (files.json は動的に変更可能) | △ |

## 4) 不足情報（Unknown / Missing）
- **全サンプルの網羅的確認**：217件全てのサンプルを個別に確認することは現実的ではないため、代表的なサンプルからパターンを推測
  - 候補：webgl_animation_keyframes.html / webgl_geometry_cube.html / webgl_loader_gltf.html
- **件数の厳密性**：files.json の webgl 配列から計算したが、開発中に増減する可能性がある

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面構造と機能の記述
- 0: 低リスク - コードリーディングガイドの内容
- 1: 中リスク - サンプル件数の記述（変動可能性あり）

## 6) レビュアーチェックリスト（最小）
- [ ] files.json の webgl 配列件数が「約217件」と整合するか確認
- [ ] 代表サンプル以外のサンプルでも同様の構造が使われているか抽出確認
- [ ] WebGL非対応ブラウザでの動作確認が必要な場合は実機テスト
