---
generated_at: 2026-01-27 12:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：22-WebGLポストプロセシング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **サンプル件数（約26件）**：files.json から計算した値

## 2) 参照した情報（Evidence一覧）

- E-01: `examples/webgl_postprocessing_unreal_bloom.html` (Bloomサンプル実装)
- E-02: `examples/files.json` (サンプルファイル一覧)
- E-03: `examples/jsm/postprocessing/EffectComposer.js` (パス管理)
- E-04: `examples/jsm/postprocessing/RenderPass.js` (シーンレンダリング)
- E-05: `examples/jsm/postprocessing/UnrealBloomPass.js` (Bloom効果)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ポストプロセシングサンプルは約26件 | E-02 (files.json の "webgl / postprocessing" 配列) | ○ |
| C-02 | EffectComposer でパスを管理 | E-01 (Line 110), E-03 | ○ |
| C-03 | RenderPass でシーンをレンダリング | E-01 (Line 101), E-04 | ○ |
| C-04 | UnrealBloomPass で Bloom 効果 | E-01 (Line 103-106), E-05 | ○ |
| C-05 | OutputPass で最終出力 | E-01 (Line 108) | ○ |
| C-06 | threshold パラメータ | E-01 (Line 54, 104, 133-137) | ○ |
| C-07 | strength パラメータ | E-01 (Line 55, 105, 139-143) | ○ |
| C-08 | radius パラメータ | E-01 (Line 56, 106, 145-149) | ○ |
| C-09 | exposure パラメータ | E-01 (Line 57, 153-157) | ○ |
| C-10 | GUI でパラメータ調整 | E-01 (Line 129-157) | ○ |
| C-11 | composer.render() でパイプライン実行 | E-01 (Line 186) | ○ |
| C-12 | ウィンドウリサイズ時に composer.setSize() | E-01 (Line 172) | ○ |
| C-13 | PostProcessing が主機能 | E-06 (画面No 22 の関連機能) | ○ |
| C-14 | WebGLRenderer が補助機能 | E-06 (画面No 22 の関連機能) | ○ |
| C-15 | WebGLRenderTarget が補助機能 | E-06 (画面No 22 の関連機能) | ○ |
| C-16 | ACESFilmicToneMapping を使用 | E-01 (Line 96) | ○ |
| C-17 | パスを連鎖させて複数エフェクト適用可能 | E-01 (Line 110-113: addPass を複数回呼び出し), E-03 | ○ |
| C-18 | AnimationMixer でアニメーション更新 | E-01 (Line 86-88, 182) | ○ |
| C-19 | Stats でパフォーマンス表示 | E-01 (Line 117-118, 184) | ○ |
| C-20 | OrbitControls でカメラ操作 | E-01 (Line 122-125) | ○ |
| C-21 | GLTFLoader でモデル読み込み | E-01 (Line 80-88) | ○ |
| C-22 | 約26件の正確な件数 | **根拠不足** (files.json は動的に変更可能) | △ |

## 4) 不足情報（Unknown / Missing）
- **件数の厳密性**：files.json の "webgl / postprocessing" 配列から計算したが、開発中に増減する可能性がある
  - 候補：files.json を定期的に確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - EffectComposer とパスの基本構造
- 0: 低リスク - パラメータと GUI の連携
- 1: 中リスク - サンプル件数の記述

## 6) レビュアーチェックリスト（最小）
- [ ] files.json の "webgl / postprocessing" 配列件数が「約26件」と整合するか確認
- [ ] 他のポストプロセシングサンプルでも同様のパターンが使われているか確認
