---
generated_at: 2026-01-27 12:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：23-WebGL上級サンプル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **サンプル件数（約47件）**：files.json から計算した値
  2. **全サンプルでのパターン共通性**：代表サンプルからの推測

## 2) 参照した情報（Evidence一覧）

- E-01: `examples/files.json` (サンプルファイル一覧)
- E-02: `src/core/BufferGeometry.js` (BufferGeometry 実装)
- E-03: `src/core/BufferAttribute.js` (BufferAttribute 実装)
- E-04: `src/objects/InstancedMesh.js` (InstancedMesh 実装)
- E-05: `examples/jsm/misc/GPUComputationRenderer.js` (GPGPU ヘルパー)
- E-06: `examples/jsm/csm/CSM.js` (CSM 実装)
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 上級サンプルは約47件 | E-01 (files.json の "webgl / advanced" 配列) | ○ |
| C-02 | BufferGeometry が主機能 | E-07 (画面No 23 の関連機能) | ○ |
| C-03 | BufferAttribute で頂点属性管理 | E-02, E-03 | ○ |
| C-04 | InstancedMesh でインスタンシング | E-04 | ○ |
| C-05 | setMatrixAt で変換行列設定 | E-04 (InstancedMesh.js) | ○ |
| C-06 | instanceMatrix.needsUpdate で GPU 転送 | E-04 (InstancedMesh.js) | ○ |
| C-07 | GPUComputationRenderer で GPGPU | E-05 | ○ |
| C-08 | createTexture() でデータテクスチャ作成 | E-05 | ○ |
| C-09 | compute() でシミュレーション実行 | E-05 | ○ |
| C-10 | CSM でカスケードシャドウマップ | E-06 | ○ |
| C-11 | BufferAttribute に needsUpdate フラグ | E-03 | ○ |
| C-12 | Float32Array でデータ格納 | E-03 | ○ |
| C-13 | setAttribute() で属性を設定 | E-02 | ○ |
| C-14 | computeBoundingSphere() でバウンディング球計算 | E-02 | ○ |
| C-15 | WebGLRenderTarget で GPGPU | E-05 (GPUComputationRenderer 内部) | ○ |
| C-16 | DataTexture に状態を格納 | E-05 | ○ |
| C-17 | ピンポンバッファリングでスワップ | E-05 | ○ |
| C-18 | WebGL2 または拡張が必要 | E-05 (コメントに記載) | ○ |
| C-19 | 約47件の正確な件数 | **根拠不足** (files.json は動的に変更可能) | △ |
| C-20 | 全サンプルで共通パターン | **根拠なし** (代表サンプルからの推測) | △ |

## 4) 不足情報（Unknown / Missing）
- **件数の厳密性**：files.json の "webgl / advanced" 配列から計算
- **全サンプルの網羅的確認**：47件全てを個別確認することは困難
  - 候補：webgl_buffergeometry.html / webgl_gpgpu_birds.html / webgl_shadowmap_csm.html

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - BufferGeometry/BufferAttribute の基本構造
- 0: 低リスク - InstancedMesh の使用方法
- 0: 低リスク - GPGPU の基本パターン
- 1: 中リスク - サンプル件数の記述

## 6) レビュアーチェックリスト（最小）
- [ ] files.json の "webgl / advanced" 配列件数が「約47件」と整合するか確認
- [ ] GPUComputationRenderer の最新仕様を確認
- [ ] CSM.js の最新仕様を確認
