---
generated_at: 2026-01-27 12:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：24-WebGPUサンプル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **サンプル件数（約194件）**：files.json から計算した値
  2. **ブラウザサポート状況**：急速に変化する可能性

## 2) 参照した情報（Evidence一覧）

- E-01: `examples/files.json` (サンプルファイル一覧)
- E-02: `examples/webgpu_camera.html` (基本的な WebGPU サンプル)
- E-03: `build/three.webgpu.js` (WebGPU 用ビルド)
- E-04: `build/three.tsl.js` (TSL ビルド)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebGPUサンプルは約194件 | E-01 (files.json の "webgpu (wip)" 配列) | ○ |
| C-02 | WebGPURenderer が主機能 | E-05 (画面No 24 の関連機能) | ○ |
| C-03 | TSL が補助機能 | E-05 (画面No 24 の関連機能) | ○ |
| C-04 | Import Map で three/webgpu を指定 | E-02 (Line 21-30) | ○ |
| C-05 | Import Map で three/tsl を指定 | E-02 (Line 26-27) | ○ |
| C-06 | THREE.WebGPURenderer でレンダラー作成 | E-02 (Line 132) | ○ |
| C-07 | setAnimationLoop でレンダリングループ | E-02 (Line 135) | ○ |
| C-08 | setScissorTest が使用可能 | E-02 (Line 138) | ○ |
| C-09 | setClearColor が使用可能 | E-02 (Line 139, 245, 254) | ○ |
| C-10 | render() で描画 | E-02 (Line 248, 257) | ○ |
| C-11 | PerspectiveCamera が使用可能 | E-02 (Line 58, 61) | ○ |
| C-12 | OrthographicCamera が使用可能 | E-02 (Line 67) | ○ |
| C-13 | CameraHelper が使用可能 | E-02 (Line 63, 69) | ○ |
| C-14 | Scene に add() でオブジェクト追加 | E-02 (Line 64, 70, 88, 96 等) | ○ |
| C-15 | Mesh, Points が使用可能 | E-02 (Line 92-95, 127) | ○ |
| C-16 | キーボードイベントでカメラ切替 | E-02 (Line 144, 150-168) | ○ |
| C-17 | ウィンドウリサイズに対応 | E-02 (Line 143, 174-193) | ○ |
| C-18 | WIP (Work In Progress) 状態 | E-01 (カテゴリ名が "webgpu (wip)") | ○ |
| C-19 | three.webgpu.js と three.tsl.js が存在 | E-03, E-04 | ○ |
| C-20 | example.css を使用 | E-02 (Line 8) | ○ |
| C-21 | 約194件の正確な件数 | **根拠不足** (files.json は動的に変更可能) | △ |
| C-22 | ブラウザサポート状況 (Chrome 113+等) | **根拠不足** (外部情報、変化する可能性) | △ |

## 4) 不足情報（Unknown / Missing）
- **件数の厳密性**：files.json の "webgpu (wip)" 配列から計算したが、開発中に増減する可能性
- **ブラウザサポート**：WebGPU の仕様とブラウザ実装は急速に進化中
  - 候補：公式ドキュメント、caniuse.com を参照

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - WebGPURenderer の基本的な使用方法
- 0: 低リスク - Import Map の設定
- 1: 中リスク - サンプル件数の記述
- 1: 中リスク - ブラウザサポート状況

## 6) レビュアーチェックリスト（最小）
- [ ] files.json の "webgpu (wip)" 配列件数が「約194件」と整合するか確認
- [ ] WebGPU の最新ブラウザサポート状況を確認
- [ ] TSL の最新仕様を three.js ドキュメントで確認
